/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.abc;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import com.dassault.cecilia.plugin.mbsa.abc.ABCTargetModel;
import com.dassault.cecilia.plugin.mbsa.abc.PluginCmdABCTree;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.UtilityPluginTargetsDB;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;

public class UtilityPluginTargetsABC
extends UtilityPluginTargetsDB {
    private final PluginCmdABCTree _plugin;
    private String _dbConflictOption;

    public UtilityPluginTargetsABC(PluginCmdABCTree owner, List<TargetModel> targets, String dbConflictOption) {
        super(targets);
        this._plugin = owner;
        this._dbConflictOption = dbConflictOption;
    }

    protected String getTitle() {
        return this._plugin.getInfo("plugin.name");
    }

    protected File createFile(Plugable launch, String base, String ext) {
        return this._plugin.createFile(launch, base, ext);
    }

    @Override
    protected void defineUserProperties(Plugable launch, BanEntry entry) {
        File file = this._plugin.getFileExecutable(launch);
        if (file == null) {
            entry.setUserProperty("a2b.exec", FileUtility.getBasePath(((Object)((Object)this._plugin)).getClass()) + File.separator + "abc");
        } else {
            entry.setUserProperty("a2b.exec", file.getAbsolutePath());
        }
        entry.setUserProperty("a2b.algorithm", PlugableUtility.getStrOpt((Plugable)launch, (String)PluginCmdABCTree.OPT_ALGO, (String)"ITE").toLowerCase());
        entry.setUserProperty("a2b.simplify", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)PluginCmdABCTree.OPT_SIMPLIFY, (int)0)));
        entry.setUserProperty("a2b.format", PlugableUtility.getStrOpt((Plugable)launch, (String)PluginCmdABCTree.OPT_FORMAT, (String)"aralia"));
        entry.setUserProperty("a2b.log.format", PlugableUtility.getStrOpt((Plugable)launch, (String)PluginCmdABCTree.OPT_LOG_FORMAT, (String)"txt"));
    }

    protected String getTargetFilePathToABC(TargetModel tgt) {
        return tgt.getFilePath();
    }

    @Override
    protected void writeTargetToBanScript(Plugable plugable, Writer writer, TargetModel tgt, int cpt, int nbr) throws IOException {
        writer.write("<target name=\"");
        writer.write(XMLWriter.toXML((String)tgt.getVarTarget()));
        writer.write("\" value=\"");
        writer.write(XMLWriter.toXML((String)tgt.getValTarget()));
        writer.write("\" file=\"");
        writer.write(XMLWriter.toXML((String)this.getTargetFilePathToABC(tgt)));
        this.writeOtherInfo(plugable, writer, tgt);
        writer.write("</target>\n");
    }

    protected String getPostProcessKey(Plugable launcher) {
        return launcher.getOption(PluginCmdABCTree.OPT_POST_PROCESS);
    }

    @Override
    protected String getDBConflictOption() {
        return this._dbConflictOption;
    }

    @Override
    protected String withDestination() {
        return "  <destination file='${ban.log.path}'>\n    <param name='Append' value='true'/>\n    <layout name='%{ban.log.format}'>\n      <param name='Info' value='" + Boolean.getBoolean("cecilia.mbsa.plugin.abc.DBImportWithInfo") + "'/>\n      <param name='Output' value='true'/>\n    </layout>\n  </destination>\n";
    }

    private void writeOtherInfo(Plugable plugable, Writer writer, TargetModel tgt) throws IOException {
        CeciliaAppl appl;
        CeciliaGUI gui;
        boolean withCrit = tgt instanceof ABCTargetModel && ((ABCTargetModel)tgt).getCriticity() != null;
        boolean withInitialConf = plugable.getModel("altarica.file") instanceof IModel.DefaultModel && ((IModel.DefaultModel)plugable.getModel("altarica.file")).getConfig() != null;
        boolean withTarget = tgt instanceof ABCTargetModel && ((ABCTargetModel)tgt).getValTarget() != null;
        DBInternalFrame frame = null;
        if (plugable.getAppl() instanceof CeciliaAppl && ((CeciliaAppl)plugable.getAppl()).getTopWindow() instanceof CeciliaGUI && (gui = (appl = (CeciliaAppl)plugable.getAppl()).getTopWindow()).getDesktop().getDesktop().getSelectedFrame() instanceof DBInternalFrame) {
            frame = (DBInternalFrame)gui.getDesktop().getDesktop().getSelectedFrame();
        }
        boolean withFolder = frame != null;
        writer.write("\">\n");
        BiFunction<String, String, String> func = (key, value) -> {
            StringBuilder sb = new StringBuilder();
            sb.append("  <param name=\"");
            sb.append((String)key);
            sb.append("\" value=\"");
            sb.append((String)value);
            sb.append("\"/>\n");
            return sb.toString();
        };
        if (withCrit) {
            writer.write(func.apply("criticity", XMLWriter.toXML((String)((ABCTargetModel)tgt).getCriticity().getName())));
        }
        if (withInitialConf) {
            writer.write(func.apply("initialConf", XMLWriter.toXML((String)((IModel.DefaultModel)plugable.getModel("altarica.file")).getConfig())));
        }
        if (withTarget) {
            ABCTargetModel abcTgt = (ABCTargetModel)tgt;
            StringBuilder sb = new StringBuilder();
            sb.append(abcTgt.getVarTarget());
            sb.append(" = ");
            sb.append(abcTgt.getValTarget());
            writer.write(func.apply("target", XMLWriter.toXML((String)sb.toString())));
        }
        if (withFolder) {
            String refPath = frame.getDBFolder().getRefPath();
            writer.write(func.apply("refPath", refPath));
            Date generationDate = frame.getDBFolder().getDateModify();
            writer.write(func.apply("lastModifiedDateModel", String.valueOf(generationDate.getTime())));
        }
        String userGeneration = plugable.getAppl().getDBUser().getLogin();
        writer.write(func.apply("userGeneration", userGeneration));
    }
}

