/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.mcs.MCS2DagOptionsPanel;
import com.dassault.cecilia.plugin.mcs.MCS2DagParametersIO;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MCS2DagParameters {
    String _inputKey;
    String _outputKey;
    int _groupSize;
    char _separator;
    protected static IOParameters _instance = new MCS2DagParametersIO();

    public String getInput() {
        return this._inputKey;
    }

    public String getOutput() {
        return this._outputKey;
    }

    public int getSize() {
        return this._groupSize;
    }

    public char getSeparator() {
        return this._separator;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(ResMCS.getString("DLG_MCS2DAG_INFILE"));
        sb.append(" : ").append(this._inputKey).append("\n");
        sb.append(ResMCS.getString("DLG_MCS2DAG_OUTFILE"));
        sb.append(" : ").append(this._outputKey).append("\n");
        sb.append(ResMCS.getString("DLG_MCS2DAG_OPT_SIZE"));
        sb.append(" : ").append(this._groupSize).append("\n");
        sb.append(ResMCS.getString("DLG_MCS2DAG_OPT_SEP"));
        sb.append(" : '").append(this._separator).append("'\n");
        return sb.toString();
    }

    public MCS2DagParameters() {
        this("");
    }

    public MCS2DagParameters(String style) {
        this._inputKey = "%{file}";
        this._outputKey = "%{path}/%{name}.dag";
        this._groupSize = 100;
        this._separator = (char)46;
    }

    public MCS2DagParameters(MCS2DagParameters src) {
        this._inputKey = src._inputKey;
        this._outputKey = src._outputKey;
        this._groupSize = src._groupSize;
        this._separator = src._separator;
    }

    public boolean change(PluginManager launcher) {
        Window win = SwingUtilities.getWindowAncestor(launcher.getWindow());
        if (win == null) {
            win = launcher.getWindow();
        }
        DlgChangeMCS2DagParameters dlg = new DlgChangeMCS2DagParameters(win);
        dlg._ctrlInput.setText(this._inputKey);
        dlg._ctrlOutput.setText(this._outputKey);
        dlg._ctrlOptions.setGroupSize(this._groupSize);
        dlg._ctrlOptions.setSeparator(this._separator);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._inputKey = dlg._ctrlInput.getText().trim();
            this._outputKey = dlg._ctrlOutput.getText().trim();
            this._groupSize = dlg._ctrlOptions.getGroupSize();
            this._separator = dlg._ctrlOptions.getSeparator();
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        return _instance;
    }

    class DlgChangeMCS2DagParameters
    extends JDialogCecilia {
        JTextField _ctrlInput;
        JTextField _ctrlOutput;
        MCS2DagOptionsPanel _ctrlOptions;

        public DlgChangeMCS2DagParameters(Window win) {
            super(win, true);
            this.init();
        }

        protected JComponent createInOutPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            int line = 0;
            root.add((Component)new JCRLabel(ResMCS.getString("DLG_MCS2DAG_INFILE")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlInput = new JTextField(20);
            root.add((Component)this._ctrlInput, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResMCS.getString("DLG_MCS2DAG_OUTFILE")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlOutput = new JTextField(20);
            root.add((Component)this._ctrlOutput, new GridBagConstraints(1, line, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._result = false;
            rPanel.add((Component)this.createInOutPanel(), new GridBagConstraints(0, 0, 1, 1, 10.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlOptions = new MCS2DagOptionsPanel();
            rPanel.add((Component)this._ctrlOptions, new GridBagConstraints(0, 1, 1, 1, 10.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResMCS.getString("TREAT_MCS2DAG_NAME"));
        }

        protected boolean verifyParameters() {
            return this._ctrlOptions.verify();
        }
    }
}

