/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.mcs.MCS2DagParameters;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MCS2DagParametersIO
implements IOParameters {
    protected static final String KEY_MCS2DAG_PARAMS = "mcs2dag-treatment";
    protected static final String KEY_INPUT = "input";
    protected static final String KEY_OUTPUT = "output";
    protected static final String KEY_SIZE = "size";
    protected static final String KEY_SEP = "separator";
    private static final Logger __logger = Logger.getLogger(MCS2DagParametersIO.class.getPackage().getName());

    MCS2DagParametersIO() {
    }

    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (!(parameters instanceof MCS2DagParameters)) {
            throw new IOException("Unsupported object for MCS2DagParametersIO");
        }
        MCS2DagParameters mcs2dag = (MCS2DagParameters)parameters;
        out.write("      <");
        out.write(KEY_MCS2DAG_PARAMS);
        out.write(" ");
        out.write(KEY_INPUT);
        out.write("=\"");
        out.write(mcs2dag.getInput());
        out.write("\"");
        out.write(" ");
        out.write(KEY_OUTPUT);
        out.write("=\"");
        out.write(mcs2dag.getOutput());
        out.write("\"");
        out.write(" ");
        out.write(KEY_SIZE);
        out.write("=\"");
        out.write(Integer.toString(mcs2dag.getSize()));
        out.write("\"");
        out.write(" ");
        out.write(KEY_SEP);
        out.write("=\"");
        out.write(mcs2dag.getSeparator());
        out.write("\"");
        out.write("/>\n");
    }

    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_MCS2DAG_PARAMS)) {
            return null;
        }
        MCS2DagParameters mcs2dag = new MCS2DagParameters();
        Node attr = root.getAttributes().getNamedItem(KEY_INPUT);
        if (attr != null) {
            mcs2dag._inputKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_OUTPUT)) != null) {
            mcs2dag._outputKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_SIZE)) != null) {
            try {
                mcs2dag._groupSize = Integer.parseInt(attr.getNodeValue());
            }
            catch (NumberFormatException e) {
                __logger.log(Level.WARNING, "NumberFormatException for size (" + attr.getNodeValue() + ") attribute", e);
            }
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_SEP)) != null) {
            String value = attr.getNodeValue();
            if (value.length() == 1) {
                mcs2dag._separator = value.charAt(0);
            } else {
                __logger.log(Level.WARNING, "'separator' attribute must be a string size 1");
            }
        }
        return mcs2dag;
    }
}

