/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PluginCmdMCSDiff
extends AbstractPluginModel
implements PluginMAction {
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResMCS.getString("PLUG_CMD_DIFF_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResMCS.getString("PLUG_CMD_DIFF_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-03.svg"));
        }
        return super.getIcon(key);
    }

    public void createSession(final Plugable launcher, Object parameters) {
        BanEntry entry;
        InputStream script = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptMCSDiff.xml");
        if (script == null) {
            Logger.getLogger(PluginCmdMCSDiff.class.getPackage().getName()).severe("Resource script not found : BanScriptMCSDiff.xml");
            return;
        }
        DlgLaunch dlg = new DlgLaunch(launcher, launcher.getWindow());
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        try {
            entry = new BanEntry();
        }
        catch (BanLicenseException e) {
            Logger.getLogger(PluginCmdMCSDiff.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return;
        }
        File logFile = this.createFile(launcher, "MCSDiff", ".log");
        if (logFile == null) {
            return;
        }
        entry.setUserProperty("mcsdiff.log", logFile.getAbsolutePath());
        entry.setUserProperty("mcsdiff.file1", dlg._in1File);
        entry.setUserProperty("mcsdiff.file2", dlg._in2File);
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(-1L, launcher, entry, new BanInputStream(script, "MCSDiff"), logFile){

            protected String getDesc() {
                return this.getInfo("plugin.name");
            }

            protected String getName() {
                return "MCSDiff";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-03.svg"));
                }
                return super.getIcon(key);
            }

            public void run() {
                super.run();
                Object result = entry.getValueOfVariable("mcsdiff.result");
                if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResMCS.getString("DLG_MCSDIFF_NODIFF"), ResMCS.getString("PLUG_CMD_DIFF_NAME"), 1);
                }
            }
        };
        launcher.addTask((PlugTask)task, -1L);
    }

    class DlgLaunch
    extends JDialogCecilia {
        JTextField _ctrlIn1File;
        JTextField _ctrlIn2File;
        Plugable _launcher;
        JFileChooser _fileChooser;
        public String _in1File;
        public String _in2File;

        public DlgLaunch(Plugable launcher, Window win) {
            super(win, true);
            this._launcher = launcher;
            this.init();
        }

        protected JFileChooser getFileChooser() {
            if (this._fileChooser == null) {
                this._fileChooser = new JFileChooser();
                FileFilterExtention defaultFilter = new FileFilterExtention("MCS file (*.mcs,*.seq,*.xml)", ".mcs;.seq;.xml").verifyRead(true);
                this._fileChooser.addChoosableFileFilter((FileFilter)defaultFilter);
                this._fileChooser.addChoosableFileFilter((FileFilter)new FileFilterExtention("Export Text file (*.txt)", ".txt").verifyRead(true));
                this._fileChooser.addChoosableFileFilter((FileFilter)new FileFilterExtention("Export Xml file (*.xml)", ".xml").verifyRead(true));
                this._fileChooser.setFileFilter((FileFilter)defaultFilter);
            }
            this._fileChooser.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)"plugable.option.path", (String)".")));
            return this._fileChooser;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            int line = 0;
            rPanel.add((Component)new JLabel(ResMCS.getString("DLG_MCSDIFF_IN1FILE")), new GridBagConstraints(0, line++, 4, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this._ctrlIn1File = new JTextField(30);
            rPanel.add((Component)this._ctrlIn1File, new GridBagConstraints(0, line, 3, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            JButton bPath = new JButton("...");
            rPanel.add((Component)bPath, new GridBagConstraints(3, line++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            bPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = DlgLaunch.this.getFileChooser();
                    if (fc.showOpenDialog(DlgLaunch.this._ctrlIn1File) == 0) {
                        File f = fc.getSelectedFile();
                        DlgLaunch.this._launcher.setOption("plugable.option.path", f.getParent());
                        DlgLaunch.this._ctrlIn1File.setText(f.getPath());
                    }
                }
            });
            rPanel.add((Component)new JLabel(ResMCS.getString("DLG_MCSDIFF_IN2FILE")), new GridBagConstraints(0, line++, 4, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this._ctrlIn2File = new JTextField(30);
            rPanel.add((Component)this._ctrlIn2File, new GridBagConstraints(0, line, 3, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            bPath = new JButton("...");
            rPanel.add((Component)bPath, new GridBagConstraints(3, line++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            bPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = DlgLaunch.this.getFileChooser();
                    if (fc.showOpenDialog(DlgLaunch.this._ctrlIn2File) == 0) {
                        File f = fc.getSelectedFile();
                        DlgLaunch.this._launcher.setOption("plugable.option.path", f.getParent());
                        DlgLaunch.this._ctrlIn2File.setText(f.getPath());
                    }
                }
            });
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, line++, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setResizable(false);
            this.setTitle(ResMCS.getString("PLUG_CMD_DIFF_NAME"));
        }

        protected boolean verifyParameters() {
            String title = ResMCS.getString("PLUG_CMD_DIFF_NAME");
            this._in1File = this._ctrlIn1File.getText();
            if (!FileUtility.verifyPath((String)this._in1File, (boolean)false, (Component)this._ctrlIn1File, (String)title)) {
                return false;
            }
            this._in2File = this._ctrlIn2File.getText();
            return FileUtility.verifyPath((String)this._in2File, (boolean)false, (Component)this._ctrlIn2File, (String)title);
        }
    }
}

