/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.examples;

import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TimerTask
implements PlugTask {
    String _msg = "En attente";
    int _cpt;
    int _tgt;
    int _inc;
    boolean _cancel;
    boolean _hight;
    boolean _suspend;
    int _msgTyp;
    Plugable _launcher;

    public TimerTask(Plugable launcher, int tgt, int inc, boolean hight, int msg) {
        this._launcher = launcher;
        this._cpt = 0;
        this._tgt = tgt;
        this._inc = inc;
        this._cancel = false;
        this._suspend = false;
        this._hight = hight;
        this._msgTyp = msg;
    }

    public boolean isPriority() {
        return this._hight;
    }

    public void requestSuspend(boolean high) {
        this._suspend = true;
    }

    public void requestResume() {
        this._suspend = false;
    }

    public void requestStop() {
        this._cancel = true;
    }

    public void run() {
        try {
            while (this._cpt < this._tgt && !this._cancel) {
                Thread.sleep(this._inc * 100);
                if (this._suspend) continue;
                this._cpt += this._inc;
                int cur = (this._tgt - this._cpt + 1) * this._inc / 10;
                if (cur < 60) {
                    this._msg = "Reste au moins " + cur + " sec.";
                    continue;
                }
                if ((cur /= 60) < 60) {
                    this._msg = "Reste au moins " + cur + " min.";
                    continue;
                }
                if ((cur /= 60) < 24) {
                    this._msg = "Reste au moins " + cur + " h.";
                    continue;
                }
                this._msg = "Reste au moins " + (cur /= 24) + " j.";
            }
            if (this._msgTyp == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)TimerTask.this._launcher.getWindow()), "TimerTask finish");
                    }
                });
            } else if (this._msgTyp == 2) {
                class ResultPanel
                extends JPanel
                implements PlugPanel {
                    public ResultPanel() {
                        super(new BorderLayout());
                        this.add(new JLabel("TimerTask finish"));
                    }

                    public void trash() {
                    }

                    public Component getPanel() {
                        return this;
                    }

                    public String getInfo(String key) {
                        if (key.equals("ppanel.title")) {
                            return "TimerTask status";
                        }
                        if (key.equals("ppanel.default.width")) {
                            return "200";
                        }
                        if (key.equals("ppanel.default.height")) {
                            return "100";
                        }
                        return TimerTask.this.getInfo(key);
                    }

                    public Icon getIcon(String key) {
                        return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-02.svg"));
                    }
                }
                ResultPanel pPane = new ResultPanel();
                this._launcher.addPanel((PlugPanel)pPane, -1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getInfo(String key) {
        if (key.equals("process.msg")) {
            return this._msg;
        }
        if (key.equals("process.msg.high")) {
            float res = (float)this._cpt / (float)this._tgt * 100.0f;
            return Integer.toString((int)res) + " %";
        }
        if (key.equals("process.p1000")) {
            return Integer.toString((int)((double)this._cpt / (double)this._tgt * 1000.0));
        }
        if (key.equals("plugin.name")) {
            return "TimerTask";
        }
        if (key.equals("ptask.desc")) {
            return "Action de " + this._tgt * this._inc / 10 + " sec.";
        }
        return null;
    }

    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-02.svg"));
        }
        return null;
    }
}

