/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.stokstic;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.mbsa.stokstic.MocaDlgParams;
import com.dassault.cecilia.plugin.mbsa.stokstic.MocaTask;
import com.dassault.cecilia.plugin.mbsa.stokstic.ResMoca;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PluginCmdMocaRP
extends AbstractPluginModel
implements PluginMAction {
    protected static final String VERSION = "1.0.00";
    public static final String OPT_MOCABIN = PluginCmdMocaRP.class.getName() + "#Moca.Bin";
    public static final String OPT_MOCABIN_DEF = "Moca.exe";
    public static final String OPT_MOCA_LOOP = PluginCmdMocaRP.class.getName() + "#MaxLoop";
    public static final String OPT_MOCA_STEP = PluginCmdMocaRP.class.getName() + "#NbrStep";
    public static final String OPT_MOCA_DURATION = PluginCmdMocaRP.class.getName() + "#Duration";
    public static final String OPT_MOCA_DELAY = PluginCmdMocaRP.class.getName() + "#Delay";
    public static final String OPT_MOCA_SEED = PluginCmdMocaRP.class.getName() + "#Seed";
    public static final String OPT_MOCA_STORY = PluginCmdMocaRP.class.getName() + "#Story";
    MocaOptsPanel _opts = null;

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new MocaOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    public boolean withParameters() {
        return false;
    }

    public String getInfo(String key) {
        if (key.equals("plugin.version")) {
            return VERSION;
        }
        if (key.equals("plugin.name")) {
            return ResMoca.getString("PLUG_CMD_MOCARP_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResMoca.getString("PLUG_CMD_MOCARP_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "alt M";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        URL url;
        if (key.equals("plugin.default") && (url = ((Object)((Object)this)).getClass().getResource("/com/dassault/cecilia/plugin/mbsa/stokstic/Moca.gif")) != null) {
            return new ImageIcon(url);
        }
        return super.getIcon(key);
    }

    protected String getKeyTranslator() {
        return "com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginMocaRP";
    }

    protected String getDefaultExtention() {
        return ".mok";
    }

    public void createSession(Plugable launch, Object params) {
        File outFile;
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        PluginModel plugTrans = launcher.getPlugin(this.getKeyTranslator());
        if (plugTrans == null || !(plugTrans instanceof PluginMTranslate)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResMoca.getString("ERR_PLUG_TRANSLATE") + "\n   [" + this.getKeyTranslator() + "]", ResMoca.getString("DEF_TITLE"), 0);
            return;
        }
        Translator trans = ((PluginMTranslate)plugTrans).createTranslator((Plugable)launcher, null);
        if (trans == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResMoca.getString("ERR_TRANSLATOR"), ResMoca.getString("DEF_TITLE"), 0);
            return;
        }
        try {
            outFile = File.createTempFile("Net", this.getDefaultExtention());
            outFile.deleteOnExit();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResMoca.getString("ERR_TMP_FILE"), ResMoca.getString("DEF_TITLE"), 0);
            return;
        }
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        if (!trans.translate(outFile, true)) {
            return;
        }
        MocaDlgParams dlg = new MocaDlgParams(launcher.getWindow());
        if (!dlg.DoModal((Plugable)launcher)) {
            return;
        }
        MocaTask task = new MocaTask((Plugable)launcher, model, outFile.getAbsolutePath(), dlg.getDuration(), dlg.getStory(), dlg.getSeed(), dlg.getDelay());
        launcher.addTask((PlugTask)task, model.getUID());
    }

    class MocaOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JTextField _ctrlBin;
        JComboBox _ctrlLoop;
        JComboBox _ctrlStep;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlBin.setText(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)OPT_MOCABIN, (String)PluginCmdMocaRP.OPT_MOCABIN_DEF));
            this._ctrlLoop.setSelectedItem(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_MOCA_LOOP, (int)100)));
            this._ctrlStep.setSelectedItem(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_MOCA_STEP, (int)100)));
        }

        public MocaOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createTitledBorder(ResMoca.getString("DLG_OPT_MOCA")));
            int line = 0;
            root.add((Component)new JCRLabel(ResMoca.getString("DLG_OPT_MOCA_BIN")), new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlBin = new JTextField(20);
            root.add((Component)this._ctrlBin, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResMoca.getString("DLG_OPT_MOCA_LOOP")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlLoop = new JComboBox();
            root.add(this._ctrlLoop, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResMoca.getString("DLG_OPT_MOCA_STEP")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlStep = new JComboBox();
            root.add(this._ctrlStep, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            ++line;
            this._ctrlLoop.addItem("10");
            this._ctrlLoop.addItem("50");
            this._ctrlLoop.addItem("100");
            this._ctrlLoop.addItem("1000");
            this._ctrlLoop.setEditable(true);
            this._ctrlStep.addItem("10");
            this._ctrlStep.addItem("100");
            this._ctrlStep.addItem("1000");
            this._ctrlStep.setEditable(true);
            JButton defVal = new JButton(ResMoca.getString("DLG_OPT_MOCA_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MocaOptsPanel.this._ctrlBin.setText(PluginCmdMocaRP.OPT_MOCABIN_DEF);
                    MocaOptsPanel.this._ctrlLoop.setSelectedItem("100");
                    MocaOptsPanel.this._ctrlStep.setSelectedItem("10");
                    MocaOptsPanel.this._launcher.setOption(OPT_MOCABIN, MocaOptsPanel.this._ctrlBin.getText());
                    MocaOptsPanel.this._launcher.setOption(OPT_MOCA_LOOP, (String)MocaOptsPanel.this._ctrlLoop.getSelectedItem());
                    MocaOptsPanel.this._launcher.setOption(OPT_MOCA_STEP, (String)MocaOptsPanel.this._ctrlStep.getSelectedItem());
                }
            });
            root.add((Component)defVal, new GridBagConstraints(0, line, 2, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlBin.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    MocaOptsPanel.this._launcher.setOption(OPT_MOCABIN, MocaOptsPanel.this._ctrlBin.getText());
                }
            });
            this._ctrlLoop.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    String value = (String)MocaOptsPanel.this._ctrlLoop.getSelectedItem();
                    try {
                        int ival = Integer.parseInt(value);
                        if (ival > 0) {
                            MocaOptsPanel.this._launcher.setOption(OPT_MOCA_LOOP, value);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    MocaOptsPanel.this._ctrlLoop.setSelectedItem(Integer.toString(PlugableUtility.getIntOpt((Plugable)MocaOptsPanel.this._launcher, (String)OPT_MOCA_LOOP, (int)100)));
                }
            });
            this._ctrlStep.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    String value = (String)MocaOptsPanel.this._ctrlStep.getSelectedItem();
                    try {
                        int ival = Integer.parseInt(value);
                        if (ival > 0) {
                            MocaOptsPanel.this._launcher.setOption(OPT_MOCA_STEP, value);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    MocaOptsPanel.this._ctrlStep.setSelectedItem(Integer.toString(PlugableUtility.getIntOpt((Plugable)MocaOptsPanel.this._launcher, (String)OPT_MOCA_STEP, (int)10)));
                }
            });
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdMocaRP.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

