/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.plugin.seqconvert.Event;
import com.dassault.cecilia.plugin.seqconvert.ResSequenceConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class EventsTableDlg
extends JDialog {
    private JLabel label;
    private JTable eventsTable;
    private JButton nextButton;
    private JButton allButton;
    private JButton notAnyButton;
    private boolean result;

    public EventsTableDlg(JFrame frame, String title, Event[] events) {
        super((Frame)frame, title);
        this.eventsTable = new JTable(new EventTableModel(events));
        this.buildDialog();
        this.defineActions();
    }

    public Event[] getEventsToRemove() {
        ArrayList<Event> listEventsToRemove = new ArrayList<Event>(0);
        for (int i = 0; i < this.eventsTable.getRowCount(); ++i) {
            if (!((Boolean)this.eventsTable.getValueAt(i, 1)).booleanValue()) continue;
            listEventsToRemove.add(new Event((String)this.eventsTable.getValueAt(i, 0)));
        }
        Event[] eventsToRemove = listEventsToRemove.toArray(new Event[listEventsToRemove.size()]);
        return eventsToRemove;
    }

    private void buildDialog() {
        JPanel pane1 = new JPanel();
        JPanel pane2 = new JPanel();
        JPanel pane3 = new JPanel();
        pane1.setLayout(new GridBagLayout());
        pane2.setLayout(new GridBagLayout());
        pane3.setLayout(new GridBagLayout());
        this.label = new JLabel(ResSequenceConverter.getString("GUI_LABEL_LISTEVENTS"));
        this.nextButton = new JButton(ResSequenceConverter.getString("GUI_BUTTON_NEXT"));
        this.allButton = new JButton(ResSequenceConverter.getString("GUI_BUTTON_ALL"));
        this.notAnyButton = new JButton(ResSequenceConverter.getString("GUI_BUTTON_NOTANY"));
        TableColumn column = this.eventsTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column.setMaxWidth(60);
        column.setMinWidth(60);
        this.eventsTable.setPreferredScrollableViewportSize(new Dimension(350, 100));
        this.eventsTable.setAutoResizeMode(3);
        this.eventsTable.doLayout();
        JScrollPane eventsTableScrollPane = new JScrollPane(this.eventsTable);
        pane1.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 0, 0), 0, 0));
        pane1.add((Component)eventsTableScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
        pane2.add((Component)this.allButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(20, 10, 10, 5), 0, 0));
        pane2.add((Component)this.notAnyButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(20, 0, 10, 0), 0, 0));
        pane3.add((Component)this.nextButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(20, 0, 10, 10), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)pane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)pane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)pane3, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void defineActions() {
        this.nextButton.addActionListener(new NextButtonAction());
        this.allButton.addActionListener(new AllButtonAction());
        this.notAnyButton.addActionListener(new NotAnyButtonAction());
        this.addWindowListener(new CrossAction());
    }

    public boolean showDialog() {
        this.result = false;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(true);
        this.setModal(true);
        this.setVisible(true);
        return this.result;
    }

    class EventTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{ResSequenceConverter.getString("GUI_TABLE_EVENT"), ResSequenceConverter.getString("GUI_TABLE_REMOVE")};
        private Object[][] data;

        public EventTableModel(Event[] events) {
            this.data = new Object[events.length][2];
            for (int i = 0; i < events.length; ++i) {
                this.data[i][0] = events[i].getName();
                this.data[i][1] = false;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.data[row][column];
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column >= 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.data[row][column] = value;
            this.fireTableCellUpdated(row, column);
        }
    }

    class NextButtonAction
    implements ActionListener {
        NextButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventsTableDlg.this.result = true;
            EventsTableDlg.this.setVisible(false);
        }
    }

    class AllButtonAction
    implements ActionListener {
        AllButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < EventsTableDlg.this.eventsTable.getRowCount(); ++i) {
                EventsTableDlg.this.eventsTable.setValueAt(true, i, 1);
            }
        }
    }

    class NotAnyButtonAction
    implements ActionListener {
        NotAnyButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < EventsTableDlg.this.eventsTable.getRowCount(); ++i) {
                EventsTableDlg.this.eventsTable.setValueAt(false, i, 1);
            }
        }
    }

    class CrossAction
    extends WindowAdapter {
        CrossAction() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EventsTableDlg.this.result = false;
            EventsTableDlg.this.setVisible(false);
        }
    }
}

