/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.seqconvert.ResSequenceConverter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooseDlg
extends JDialog {
    private JLabel pathLabel;
    private JTextField pathTextField;
    private JButton pathButton;
    private JButton nextButton;
    private String defaultPath = ".";
    private String path;
    private String extensionName;
    private String extensionDesc;
    private String ask;
    private boolean write;
    private boolean result;

    public FileChooseDlg(Frame frame, String title) {
        super(frame, title);
    }

    public FileChooseDlg(Dialog dlg, String title) {
        super(dlg, title);
    }

    public void init(String label, String next, String extName, String extDesc, String msgAsk, boolean bWrite) {
        this.pathLabel = new JLabel(label);
        this.pathTextField = new JTextField(30);
        this.pathButton = new JButton("...");
        this.nextButton = new JButton(next);
        this.extensionName = extName;
        this.extensionDesc = extDesc;
        this.ask = msgAsk;
        this.write = bWrite;
        this.buildDialog();
        this.defineActions();
    }

    public static FileChooseDlg createFileChooseDlg(Window window, String title, String label, String next, String extensionName, String extensionDesc, String ask, boolean write) {
        FileChooseDlg dlg = null;
        dlg = window instanceof Frame ? new FileChooseDlg((Frame)window, title) : new FileChooseDlg((Dialog)window, title);
        dlg.init(label, next, extensionName, extensionDesc, ask, write);
        return dlg;
    }

    public void setDefaultPath(String defPath) {
        this.defaultPath = defPath;
    }

    public String getPath() {
        return this.pathTextField.getText();
    }

    private void buildDialog() {
        JPanel pane1 = new JPanel();
        JPanel pane2 = new JPanel();
        pane1.setLayout(new GridBagLayout());
        pane2.setLayout(new GridBagLayout());
        pane1.add((Component)this.pathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 0, 0), 0, 0));
        pane1.add((Component)this.pathTextField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 10, 0, 0), 0, 0));
        pane1.add((Component)this.pathButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 10), 0, 0));
        pane2.add((Component)this.nextButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(20, 0, 10, 10), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)pane1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)pane2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void defineActions() {
        this.pathButton.addActionListener(new PathButtonAction());
        this.nextButton.addActionListener(new NextButtonAction());
        this.addWindowListener(new CrossAction());
    }

    public boolean showDialog() {
        this.result = false;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.setModal(true);
        this.setVisible(true);
        return this.result;
    }

    class PathButtonAction
    implements ActionListener {
        PathButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(FileChooseDlg.this.defaultPath);
            fileChooser.setFileFilter((FileFilter)new FileFilterExtention(FileChooseDlg.this.extensionDesc, FileChooseDlg.this.extensionName));
            fileChooser.setDialogTitle(FileChooseDlg.this.ask);
            if (0 == fileChooser.showOpenDialog(null)) {
                if (fileChooser.getSelectedFile().getAbsolutePath().endsWith(FileChooseDlg.this.extensionName)) {
                    FileChooseDlg.this.pathTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                } else {
                    FileChooseDlg.this.pathTextField.setText(fileChooser.getSelectedFile().getAbsolutePath() + FileChooseDlg.this.extensionName);
                }
            }
        }
    }

    class NextButtonAction
    implements ActionListener {
        NextButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooseDlg.this.path = FileChooseDlg.this.pathTextField.getText();
            FileChooseDlg.this.result = FileUtility.verifyPath((String)FileChooseDlg.this.path, (boolean)FileChooseDlg.this.write, (Component)FileChooseDlg.this.getContentPane(), (String)ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"));
            FileChooseDlg.this.setVisible(false);
        }
    }

    class CrossAction
    extends WindowAdapter {
        CrossAction() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FileChooseDlg.this.result = false;
            FileChooseDlg.this.setVisible(false);
        }
    }
}

