/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.seqconvert.ParametersIOSequenceConverter;
import com.dassault.cecilia.plugin.seqconvert.ResSequenceConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ParametersSequenceConverter {
    boolean _xmlViewer;
    String _xmlViewerArgs;
    String _xmlViewerPath;
    protected static IOParameters _instance = null;

    public boolean getXmlViewer() {
        return this._xmlViewer;
    }

    public String getXmlViewerPath() {
        return this._xmlViewerPath;
    }

    public String getXmlViewerArgs() {
        return this._xmlViewerArgs;
    }

    public ParametersSequenceConverter() {
        this._xmlViewer = false;
        this._xmlViewerArgs = "$file$";
        this._xmlViewerPath = "";
    }

    public ParametersSequenceConverter(ParametersSequenceConverter src) {
        this._xmlViewer = src._xmlViewer;
        this._xmlViewerArgs = src._xmlViewerArgs;
        this._xmlViewerPath = src._xmlViewerPath;
    }

    public boolean VerifyData(Plugable launcher) {
        if (this._xmlViewer) {
            if (0 == this._xmlViewerPath.length()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSequenceConverter.msgFormat("GUI_MSG_BADXMLVIEWERPATH", this._xmlViewerPath));
                return false;
            }
            File execFile = new File(this._xmlViewerPath);
            if (!execFile.isFile() || !execFile.exists()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSequenceConverter.msgFormat("GUI_MSG_BADXMLVIEWERPATH", this._xmlViewerPath));
                return false;
            }
            if (!this._xmlViewerArgs.contains("$file$")) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSequenceConverter.msgFormat("GUI_MSG_BADXMLVIEWERARGS", this._xmlViewerArgs));
                return false;
            }
        }
        return true;
    }

    public boolean change(PluginManager launcher) {
        Window win = SwingUtilities.getWindowAncestor(launcher.getWindow());
        if (win == null) {
            win = launcher.getWindow();
        }
        DlgChange dlg = new DlgChange(win);
        if (this._xmlViewer) {
            dlg._xmlViewerCheckBox.doClick();
        }
        dlg._xmlViewerPathTextField.setText(this._xmlViewerPath);
        dlg._xmlViewerArgsTextField.setText(this._xmlViewerArgs);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._xmlViewer = dlg._xmlViewerCheckBox.isSelected();
            this._xmlViewerPath = dlg._xmlViewerPathTextField.getText();
            this._xmlViewerArgs = dlg._xmlViewerArgsTextField.getText();
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        if (_instance == null) {
            _instance = new ParametersIOSequenceConverter();
        }
        return _instance;
    }

    class DlgChange
    extends JDialogCecilia {
        JTextField _xmlViewerPathTextField;
        JTextField _xmlViewerArgsTextField;
        JCheckBox _xmlViewerCheckBox;

        public DlgChange(Window win) {
            super(win, true);
            this.init();
        }

        protected JPanel createXmlViewerPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createTitledBorder(ResSequenceConverter.getString("GUI_TITLEBORDER_XMLVIEWER")));
            this._xmlViewerCheckBox = new JCheckBox();
            this._xmlViewerCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgChange.this._xmlViewerPathTextField.setEditable(DlgChange.this._xmlViewerCheckBox.isSelected());
                    DlgChange.this._xmlViewerArgsTextField.setEditable(DlgChange.this._xmlViewerCheckBox.isSelected());
                }
            });
            int line = 0;
            root.add((Component)new JCRLabel(ResSequenceConverter.getString("GUI_LABEL_XMLVIEWERACTIVATED")), new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            root.add((Component)this._xmlViewerCheckBox, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResSequenceConverter.getString("GUI_LABEL_XMLVIEWERPATH")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._xmlViewerPathTextField = new JTextField(20);
            root.add((Component)this._xmlViewerPathTextField, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResSequenceConverter.getString("GUI_LABEL_XMLVIEWERARGS")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._xmlViewerArgsTextField = new JTextField(20);
            root.add((Component)this._xmlViewerArgsTextField, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._xmlViewerPathTextField.setEditable(false);
            this._xmlViewerArgsTextField.setEditable(false);
            JButton defVal = new JButton(ResSequenceConverter.getString("GUI_BUTTON_DEFAULT"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgChange.this._xmlViewerCheckBox.setSelected(false);
                    DlgChange.this._xmlViewerPathTextField.setText("");
                    DlgChange.this._xmlViewerArgsTextField.setText("$file$");
                    DlgChange.this._xmlViewerPathTextField.setEditable(false);
                    DlgChange.this._xmlViewerArgsTextField.setEditable(false);
                }
            });
            root.add((Component)defVal, new GridBagConstraints(1, ++line, 2, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rPanel.add((Component)this.createXmlViewerPanel(), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            tSize.height += 100;
            tSize.width += 50;
            this.setSize(tSize);
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResSequenceConverter.getString("PLUG_SEQUENCECONVERTER_NAME"));
        }

        protected boolean verifyParameters() {
            if (this._xmlViewerCheckBox.isSelected()) {
                if (0 == this._xmlViewerPathTextField.getText().length()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResSequenceConverter.msgFormat("GUI_MSG_BADXMLVIEWERPATH", this._xmlViewerPathTextField.getText()));
                    return false;
                }
                File execFile = new File(this._xmlViewerPathTextField.getText());
                if (!execFile.isFile() || !execFile.exists()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResSequenceConverter.msgFormat("GUI_MSG_BADXMLVIEWERPATH", this._xmlViewerPathTextField.getText()));
                    return false;
                }
                if (!this._xmlViewerArgsTextField.getText().contains("$file$")) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResSequenceConverter.msgFormat("GUI_MSG_BADXMLVIEWERARGS", this._xmlViewerArgsTextField.getText()));
                    return false;
                }
            }
            return true;
        }
    }
}

