/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.txtsimul;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.plugin.mbsa.txtsimul.ResSimul;
import com.dassault.cecilia.plugin.mbsa.txtsimul.TableModelNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DlgSelectNode
extends JDialogCecilia {
    private TableModelNode _model = new TableModelNode();
    private JTable _ctrlTable = new JTable(this._model);

    public String getNodeModel() {
        return this._model.getNodeModel();
    }

    public DlgSelectNode(Window win, File file) {
        super(win, ResSimul.getString("DLG_SELNODE_TITLE"), true);
        this._model.recupNodes(this._ctrlTable, file);
        this.init(win);
    }

    public DlgSelectNode(Window win, Collection nodes) {
        super(win, ResSimul.getString("DLG_SELNODE_TITLE"), true);
        this._model.setNodes(this._ctrlTable, nodes);
        this.init(win);
    }

    private void init(Window win) {
        super.init();
        Container contentPane = this.getContentPane();
        this._ctrlTable.getSelectionModel().setSelectionMode(0);
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                DlgSelectNode.this._model.selectIdx = lsm.isSelectionEmpty() ? -1 : lsm.getMinSelectionIndex();
            }
        });
        contentPane.add((Component)new JScrollPane(this._ctrlTable), "Center");
        contentPane.add((Component)this.createButPanel(), "South");
        this.pack();
        Dimension dThis = this.getSize();
        Dimension dParent = win.getSize();
        Point p = win.getLocation();
        p.x += dParent.width / 2 - dThis.width / 2;
        p.y += dParent.height / 2 - dThis.height / 2;
        this.setLocation(p);
    }

    protected boolean verifyParameters() {
        if (this._model.getNodeModel() == null) {
            this._ctrlTable.requestFocus();
            return false;
        }
        return true;
    }
}

