/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.txtsimul;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import com.dassault.cecilia.plugin.mbsa.txtsimul.DlgOptions;
import com.dassault.cecilia.plugin.mbsa.txtsimul.ResSimul;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SimulStepper
extends SimStepper {
    protected boolean _instantaneousFire = true;
    protected int _maxLoop = 100;
    protected String _monitoring = "null";
    private DlgOptions _dlgOptions = null;
    private DlgSheduler dlgSheduler = null;

    public boolean sendSimulOption(boolean update) throws StepperException {
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        params.add((CallSite)((Object)("instantaneous.auto=\"" + Boolean.toString(this._instantaneousFire) + "\"")));
        params.add((CallSite)((Object)("instantaneous.loop=\"" + Integer.toString(this._maxLoop) + "\"")));
        params.add((CallSite)((Object)("monitoring=\"" + this._monitoring + "\"")));
        if (!this._connect.setSimulOptions(params)) {
            return false;
        }
        if (update) {
            this.updateData(true, false);
        }
        return true;
    }

    public boolean changeOption() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this._parentComponent);
        return this.changeOption(frame, false);
    }

    public boolean changeOption(Window win, boolean update) {
        if (this._dlgOptions == null) {
            this._dlgOptions = new DlgOptions(win);
        }
        this._dlgOptions.setInstantaneousFire(this._instantaneousFire);
        this._dlgOptions.setMaxLoop(this._maxLoop);
        this._dlgOptions.setMonitoring(this._monitoring);
        this._dlgOptions.setVisible(true);
        if (this._dlgOptions.getResult()) {
            this._instantaneousFire = this._dlgOptions.getInstantaneousFire();
            this._maxLoop = this._dlgOptions.getMaxLoop();
            this._monitoring = this._dlgOptions.getMonitoring();
            if (!this.isConnected()) {
                return true;
            }
            try {
                if (!this.sendSimulOption(update)) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)win), ResMsgCore.getString((String)"SIM_ERR_OPTIONS"));
                    return false;
                }
            }
            catch (StepperException e) {
                this.displayStepperException(e);
                return false;
            }
        }
        return true;
    }

    public void shedulerViewer(Window win) {
        if (this.dlgSheduler == null) {
            this.dlgSheduler = new DlgSheduler(win);
        }
        this.dlgSheduler.setVisible(true);
    }

    class DlgSheduler
    extends JDialogCecilia {
        protected JLabel _loop;
        protected JLabel _time;
        protected JTextArea _sheduler;

        public DlgSheduler(Window win) {
            super(win, ResSimul.getString("DLG_SHEDULER_TITLE"), true);
            this.init();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new GridLayout(1, 2));
            this._loop = new JLabel();
            panel.add(this._loop);
            this._time = new JLabel();
            panel.add(this._time);
            contentPane.add((Component)panel, "North");
            this._sheduler = new JTextArea(20, 5);
            JScrollPane scroll = new JScrollPane(this._sheduler);
            contentPane.add((Component)scroll, "Center");
            contentPane.add((Component)this.createButPanelClose(), "South");
            this.setSize(250, 150);
            Dimension dThis = this.getSize();
            Dimension dParent = win.getSize();
            Point p = win.getLocation();
            p.x += dParent.width / 2 - dThis.width / 2;
            p.y += dParent.height / 2 - dThis.height / 2;
            this.setLocation(p);
        }

        public void setVisible(boolean show) {
            if (show) {
                if (SimulStepper.this._connect == null) {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(SimulStepper.class), (Level)Level.WARNING, (String)"Stepper with connect null");
                    return;
                }
                this._loop.setText(SimulStepper.this.getCurrentLoop());
                this._time.setText(SimulStepper.this.getCurrentTime());
                StringBuffer sb = new StringBuffer(1024);
                try {
                    int[] shedul = SimulStepper.this._connect.getSheduler();
                    if (shedul == null) {
                        sb.append(ResSimul.getString("SIM_ERR_SHEDULER"));
                    } else if (shedul.length > 0) {
                        int idx;
                        int nbr = shedul[0];
                        for (int cpt = 0; cpt < nbr && (idx = shedul[cpt + 1]) >= 0; ++cpt) {
                            sb.append(SimulStepper.this._connect.isValidTransition(idx));
                            sb.append("\t");
                            sb.append(SimulStepper.this._connect.getNameOfTransition(idx));
                            sb.append("\n");
                        }
                    }
                    this._sheduler.setText(sb.toString());
                }
                catch (StepperException exc) {
                    sb.append("Stepper exception : ").append(exc.getMessage()).append("\n");
                    this._sheduler.setText(sb.toString());
                }
            }
            super.setVisible(show);
        }
    }
}

