/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban;

import com.dassault.cecilia.lib.ban.BanFinnish;
import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Block;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.Var;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BanProcessComponent {
    private BanProcess _process;
    private static final Pattern PATTERN_FINDVAR = Pattern.compile("((\\$|%)\\{([A-za-z][A-Za-z0-9\\-_\\.]*)\\})|(\\\\([trn\\\\]))");
    protected static final Pattern PATTERN_ID_TESTER = Pattern.compile("^[A-za-z][A-Za-z0-9\\-_\\.]*$");
    public static final String PROP_BAN_XML_ENCODING = "cecilia.ban.xml.encoding";
    private static File __tmpDir = null;
    private static ThreadLocal __initTmpDir = new ThreadLocal();

    protected BanProcessComponent() {
    }

    public void setProcess(BanProcess process) {
        this._process = process;
    }

    protected BanProcess getProcess() {
        return this._process;
    }

    protected void log(String msg) {
        this.log(msg, 2);
    }

    protected void log(String msg, int msgLevel) {
        if (this._process != null) {
            this._process.log(msg, msgLevel);
        } else if (msgLevel <= 2) {
            System.err.println(msg);
        }
    }

    protected boolean castBool(String val, String name) {
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("accept")) {
            return true;
        }
        if (val.equalsIgnoreCase("yes")) {
            return true;
        }
        if (val.equalsIgnoreCase("on")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        if (val.equalsIgnoreCase("decline")) {
            return false;
        }
        if (val.equalsIgnoreCase("no")) {
            return false;
        }
        if (val.equalsIgnoreCase("off")) {
            return false;
        }
        if (name == null) {
            return false;
        }
        throw new BanProcessException("Attribute [" + name + ", " + val + "] can't cast to boolean");
    }

    protected int castInt(String val, String name) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new BanProcessException("Attribute [" + name + ", " + val + "] can't cast to integer", e);
        }
    }

    protected String getOpt(Map<String, String> opts, String key, String defValue) {
        String result = opts.get(key);
        if (result == null) {
            result = defValue;
        }
        return result;
    }

    protected Object valued(Unit unit) {
        if (unit instanceof UnitValued) {
            return ((UnitValued)((Object)unit)).getResult();
        }
        throw new BanProcessException(unit.getName() + " is not valued");
    }

    protected String string(Unit unit) {
        Object obj = this.valued(unit);
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    private String expanseVar(String msg) {
        int pos;
        Matcher match = PATTERN_FINDVAR.matcher(msg);
        if (!match.find(pos = 0)) {
            return msg;
        }
        StringBuffer sb = new StringBuffer(msg.length());
        do {
            sb.append(msg.substring(pos, match.start()));
            String type = match.group(2);
            if (type != null && type.length() > 0) {
                String key = match.group(3);
                if (type.equals("$")) {
                    String prop = this.getProcess().getProperty(key);
                    if (prop == null) continue;
                    sb.append(prop);
                    continue;
                }
                if (!type.equals("%")) continue;
                Var result = this.findVariable(key);
                if (result == null) {
                    this.log("Var  | Variable [" + key + "] unknow", 1);
                    sb.append("%").append(key);
                    continue;
                }
                if (result.getValue() == null) {
                    this.log("Var  | Variable [" + key + "] unvalued", 1);
                    continue;
                }
                sb.append(result.getValue().toString());
                continue;
            }
            type = match.group(5);
            if (type == null || type.length() <= 0) continue;
            if (type.equals("n")) {
                sb.append("\n");
                continue;
            }
            if (type.equals("t")) {
                sb.append("\t");
                continue;
            }
            if (type.equals("r")) {
                sb.append("\r");
                continue;
            }
            if (type.equals("\\")) {
                sb.append("\\");
                continue;
            }
            this.log("Txt  | Code [" + type + "] unknow", 1);
            sb.append("\\").append(type);
        } while (match.find(pos = match.end()));
        sb.append(msg.substring(pos));
        return sb.substring(0);
    }

    protected String expanse(String msg) {
        if (msg == null) {
            return "";
        }
        if (msg.length() > 0) {
            return this.expanseVar(msg);
        }
        return msg;
    }

    protected Var findVariable(String name) {
        Iterator<Block> iBlock = this.getProcess().iteratorBlock();
        while (iBlock.hasNext()) {
            Block cur = iBlock.next();
            Var var = cur.getVariable(name);
            if (var == null) continue;
            return var;
        }
        return null;
    }

    protected boolean isSimpleID(String name) {
        return PATTERN_ID_TESTER.matcher(name).find();
    }

    protected BanProcessException errorComplexId(String name, String value, String ref) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Attribute '").append(name).append("' expanse in complex-id");
        if (value != null) {
            sb.append(" : ").append(value);
        }
        if (ref != null) {
            sb.append(" <= ").append(ref);
        }
        return new BanProcessException(sb.toString());
    }

    protected BanFinnish getFinnisher() {
        BanProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        return process._finnisher;
    }

    protected String getXMLEncoding() {
        String encoding = null;
        BanProcess process = this.getProcess();
        if (process != null) {
            encoding = process.getProperty(PROP_BAN_XML_ENCODING, 3);
        }
        return encoding;
    }

    protected String getXMLHeader() {
        String encoding = this.getXMLEncoding();
        if (encoding != null && encoding.length() > 0) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("<?xml version='1.0' encoding='");
            sb.append(encoding);
            sb.append("'?>");
            sb.append(System.getProperty("line.separator"));
            return sb.toString();
        }
        return "<?xml version='1.0'?>\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File createTempFile(String prefix, String suffix) throws IOException {
        if (__initTmpDir.get() != null) return File.createTempFile(prefix, suffix, __tmpDir);
        Class<BanProcessComponent> clazz = BanProcessComponent.class;
        synchronized (BanProcessComponent.class) {
            if (__tmpDir == null) {
                String tmpPath = System.getProperty("java.io.tmpdir");
                __tmpDir = new File(tmpPath);
            }
            __initTmpDir.set(Boolean.TRUE);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return File.createTempFile(prefix, suffix, __tmpDir);
        }
    }
}

