/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.BanStoppedException;
import com.dassault.cecilia.lib.ban.ReturnException;
import com.dassault.cecilia.lib.ban.parser.XmlLocator;
import org.xml.sax.Locator;

public abstract class Unit
extends BanProcessComponent {
    private String _description;
    private Unit _ownerUnit;
    private String _locationFile = null;
    private int _locationLine = -1;

    public void execute() {
    }

    public final Unit perform() {
        try {
            this.checkSuspended();
        }
        catch (InterruptedException e) {
            throw new BanStoppedException(e);
        }
        if (this.checkStopped()) {
            throw new BanStoppedException();
        }
        this.getProcess().fireUnitStarted(this);
        Throwable reason = null;
        try {
            this.execute();
        }
        catch (BanProcessException ex) {
            if (ex.getLocator() == null) {
                ex.setLocator(this.getLocator());
            }
            reason = ex;
            throw ex;
        }
        catch (ReturnException ex) {
            throw ex;
        }
        catch (BanStoppedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            reason = ex;
            BanProcessException be = new BanProcessException(ex);
            be.setLocator(this.getLocator());
            throw be;
        }
        catch (Error ex) {
            reason = ex;
            throw ex;
        }
        finally {
            this.getProcess().fireUnitFinished(this, reason);
        }
        return this;
    }

    protected void checkSuspended() throws InterruptedException {
        this.getProcess().checkSuspended();
    }

    protected boolean checkStopped() {
        return this.getProcess().checkStopped();
    }

    @Override
    protected void log(String msg, int level) {
        BanProcess process = this.getProcess();
        if (process != null) {
            process.log(this, msg, level);
        } else {
            super.log(msg, level);
        }
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String info() {
        if (this._description != null) {
            return this._description;
        }
        return this.getName();
    }

    protected void progressed(float progress) {
        this.getProcess().fireUnitProgressed(this, progress);
    }

    public void setOwnerUnit(Unit owner) {
        this._ownerUnit = owner;
    }

    protected String getLocationFile() {
        if (this._locationFile != null) {
            return this._locationFile;
        }
        if (this._ownerUnit != null && this._ownerUnit != this) {
            return this._ownerUnit.getLocationFile();
        }
        return "[Undef location]";
    }

    protected void setLocationFile(String file) {
        this._locationFile = file;
    }

    public void setLocation(int line, int colu) {
        this._locationLine = line;
    }

    public Locator getLocator() {
        return new XmlLocator(this.getLocationFile(), this._locationLine, -1);
    }

    protected BanEntry getBanEntry() {
        return this.getProcess()._ownerEntry;
    }
}

