/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.examples;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import java.io.File;
import java.io.InputStream;

public abstract class BanCreateStepper {
    public static final String _ID_STEPPER = "BanCreateStepper.IDStepper";

    protected abstract String getScriptName();

    public Stepper createStepper(File compiledFile) throws BanLicenseException {
        BanEntry ban = new BanEntry();
        ban.setUserProperty("stepper.input.compil", compiledFile.getAbsolutePath());
        ban.setUserProperty("stepper.output.id", _ID_STEPPER);
        String script = this.getScriptName();
        InputStream inputStream = BanCreateStepper.class.getResourceAsStream(script);
        BanInputStream banStream = new BanInputStream(inputStream, script);
        try {
            ban.execute(banStream);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (BanProcessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BanProcessException(e);
        }
        catch (Error e) {
            throw new BanProcessException(e);
        }
        Object result = ban.getIdObject(_ID_STEPPER);
        if (result != null && !(result instanceof Stepper)) {
            throw new BanProcessException("BanCreateStepper : Result is not a Stepper");
        }
        return (Stepper)result;
    }

    private void printStepper(Stepper stepper) throws StepperException {
        int i;
        if (!stepper.goInitialState()) {
            System.out.println("No initial state - stop print stepper");
            return;
        }
        int nbr = stepper.getNbrState();
        System.out.println("Number state : " + nbr);
        for (i = 1; i <= nbr; ++i) {
            System.out.println("St" + i + "\t" + stepper.getNameOfState(i) + "\t" + stepper.getValueStringOfState(i));
        }
        nbr = stepper.getNbrFlow();
        System.out.println("Number flow : " + nbr);
        for (i = 1; i <= nbr; ++i) {
            System.out.println("Fl" + i + "\t" + stepper.getNameOfFlow(i) + "\t" + stepper.getValueStringOfFlow(i));
        }
        nbr = stepper.getNbrTransition();
        System.out.println("Number Transition : " + nbr);
        for (i = 1; i <= nbr; ++i) {
            System.out.println("Tr" + i + "\t" + stepper.getNameOfTransition(i) + "\t" + stepper.isValidTransition(i) + "\t" + stepper.getDescOfTransition(i));
        }
    }

    protected int execute(String[] args) {
        if (args.length < 1) {
            System.err.println("BanCreateStepper : syntax launch error");
            return 1;
        }
        File compiledFile = new File(args[0]);
        if (!(compiledFile.exists() && compiledFile.isFile() && compiledFile.canRead())) {
            System.err.println("BanCreateStepper : compiled file error");
            return 1;
        }
        Stepper stepper = null;
        try {
            stepper = this.createStepper(compiledFile);
        }
        catch (BanLicenseException e) {
            System.err.println("BanCreateStepper : License exception\n[" + e.getMessage() + "]");
            return 2;
        }
        catch (BanProcessException e) {
            System.err.println("BanCreateStepper : process exception\n[" + e.getMessage() + "]");
            return 3;
        }
        if (stepper == null) {
            return 4;
        }
        try {
            this.printStepper(stepper);
        }
        catch (StepperException e) {
            System.err.println("BanCreateStepper : print exception\n[" + e.getMessage() + "]");
            return 5;
        }
        return 0;
    }
}

