/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.examples.destination;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.util.destination.DestinationString;
import java.io.File;

public class DestinationExample {
    private static int Main(String[] args) {
        if (args.length != 1) {
            System.err.println("DestinationExample : syntax launch error");
            return 2;
        }
        File script = new File("DestinationStringScript.xml");
        if (!(script.exists() && script.isFile() && script.canRead())) {
            System.err.println("DestinationExample : script file error");
            return 2;
        }
        File input = new File(args[0]);
        if (!(script.exists() && script.isFile() && script.canRead())) {
            System.err.println("DestinationExample : input file error");
            return 2;
        }
        BanEntry ban = null;
        try {
            ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            System.err.println("DestinationExample : License exception\n[" + e.getMessage() + "]");
            return 5;
        }
        ban.setUserProperty("ban.alta.input", input.getAbsolutePath());
        try {
            ban.execute(script);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.out.println("DestinationExample : No Error");
        }
        catch (BanProcessException e) {
            System.err.println("DestinationExample : process exception\n[" + e.getMessage() + "]");
            DestinationExample.printLogAltaString(ban);
            return 1;
        }
        catch (Exception e) {
            System.err.println("DestinationExample : unknow exception\n[" + e.getMessage() + "]");
            return 3;
        }
        catch (Error e) {
            System.err.println("DestinationExample : unknow error\n[" + e.getMessage() + "]");
            return 3;
        }
        return 0;
    }

    protected static void printLogAltaString(BanEntry ban) {
        Object obj = ban.getIdObject("logAltaString");
        if (obj != null) {
            System.out.println("\nLogAltaString : ");
            if (obj instanceof DestinationString) {
                System.out.println(((DestinationString)obj).getString());
            } else {
                System.err.println("DestinationExample : LogAltaString is not DestinationString");
            }
        }
    }

    public static void main(String[] args) {
        int result = DestinationExample.Main(args);
        System.gc();
        System.exit(result);
    }
}

