/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.launcher;

import com.dassault.cecilia.lib.ban.launcher.LogExecLayout;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Record;

public class LogExecLayoutXML
extends LogExecLayout {
    private boolean formatRecord(StringBuffer sb, LogExecRecord rec) {
        String msg = rec.getMessage();
        if (msg.trim().length() == 0 && !this._displayBlankMsg) {
            return false;
        }
        sb.append("<record type=\"");
        LogExecRecord.LogType type = rec.getType();
        switch (type) {
            case INFO: {
                if (!this._displayInfo) {
                    return false;
                }
                sb.append("info");
                break;
            }
            case OUT: {
                if (!this._displayOutput) {
                    return false;
                }
                sb.append("warning");
                break;
            }
            case ERR: {
                if (!this._displayError) {
                    return false;
                }
                sb.append("error");
                break;
            }
            case EXC: {
                if (!this._displayException) {
                    return false;
                }
                sb.append("exception");
            }
        }
        sb.append("\">\n");
        sb.append("  <msg>");
        this.escapeXML(sb, msg);
        sb.append("</msg>\n");
        sb.append("</record>\n");
        return true;
    }

    @Override
    public String format(Record rec) {
        if (rec instanceof LogExecRecord) {
            StringBuffer sb = new StringBuffer(128);
            LogExecRecord record = (LogExecRecord)rec;
            if (this.formatRecord(sb, record)) {
                return sb.toString();
            }
            return "";
        }
        throw new RuntimeException("Record unknow");
    }

    @Override
    public String getHead(Destination destination2) {
        StringBuffer sb = new StringBuffer(128);
        this.prepareHeadXML(sb, destination2);
        sb.append("<" + this.getDocElement() + ">\n");
        return sb.toString();
    }

    @Override
    public String getTail(Destination destination2) {
        return "</" + this.getDocElement() + ">\n";
    }

    protected String getDocElement() {
        return "logexec";
    }
}

