/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.parser;

import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitContainer;
import com.dassault.cecilia.lib.ban.loader.UnitLoaderHelper;
import com.dassault.cecilia.lib.ban.parser.XmlElement;
import com.dassault.cecilia.lib.ban.parser.XmlRootHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public abstract class XmlHandler {
    public void onStartElement(XmlElement element, XmlRootHandler context) throws SAXParseException {
    }

    public XmlHandler onStartChild(XmlElement parent, XmlElement child, XmlRootHandler context) throws SAXParseException {
        throw new SAXParseException("Unexpected element [" + child.getName() + "]", context.getLocator());
    }

    public void onEndChild(XmlElement parent, XmlElement child, XmlRootHandler context) throws SAXParseException {
    }

    public void onEndElement(XmlElement element, XmlRootHandler context) throws SAXParseException {
    }

    protected XmlHandler callUnitStartChild(XmlElement parent, XmlElement child, XmlRootHandler context) throws SAXParseException {
        Class cl;
        Object xParent = parent.getBanObject();
        if (xParent instanceof UnitContainer && (cl = context.getUnitDef(child.getName())) != null) {
            Unit xChild = UnitLoaderHelper.createUnit(cl, context.getProcess());
            Locator loc = context.getLocator();
            xChild.setLocation(loc.getLineNumber(), loc.getColumnNumber());
            child.setBanObject(xChild);
            XmlHandler result = UnitLoaderHelper.findGetHandler(xChild, context.getProcess());
            if (result != null) {
                return result;
            }
            return this;
        }
        return null;
    }

    protected XmlHandler callElementStartChild(XmlElement parent, XmlElement child, XmlRootHandler context) throws SAXParseException {
        Object xParent = parent.getBanObject();
        Object xChild = UnitLoaderHelper.invokeCreateElement(xParent, child.getName(), context.getProcess());
        if (xChild != null) {
            UnitLoaderHelper.invokeSetProcess(xChild, context.getProcess());
            child.setBanObject(xChild);
            return this;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

