/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.parser;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.loader.UnitRepositoring;
import com.dassault.cecilia.lib.ban.parser.XmlElement;
import com.dassault.cecilia.lib.ban.parser.XmlHandler;
import com.dassault.cecilia.lib.ban.parser.XmlLocator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRootHandler
extends DefaultHandler {
    LinkedList<XmlElement> _elements = new LinkedList();
    LinkedList<XmlHandler> _handlers = new LinkedList();
    XmlHandler _currentHandler;
    BanProcess _process;
    Locator _locator;
    Map<String, String> _currentPrefixMapping = new HashMap<String, String>();

    public XmlRootHandler(XmlHandler root, BanProcess process) {
        this._currentHandler = root;
        this._process = process;
        this._elements.add(new XmlElement("", "<root>", null, null));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
        super.setDocumentLocator(locator);
    }

    public void log(String msg, int msgLevel) {
        if (msgLevel > 0) {
            this._process.log(msg, 4);
        }
    }

    protected void refreshProcessException(BanProcessException pe) {
        if (pe.getLocator() == null) {
            pe.setLocator(new XmlLocator(this.getLocator()));
        }
        pe.appendStack("Parsing stack : \n");
        ListIterator<XmlElement> iElem = this._elements.listIterator(this._elements.size());
        while (iElem.hasPrevious()) {
            XmlElement elem = iElem.previous();
            if (elem == null) continue;
            pe.appendStack("\t\t");
            pe.appendStack(elem.getName());
            pe.appendStack(" [line = ");
            int line = elem.getLine();
            if (line < 0) {
                pe.appendStack("?");
            } else {
                pe.appendStack(Integer.toString(line));
            }
            pe.appendStack("]\n");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._currentPrefixMapping.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this._currentPrefixMapping.remove(prefix);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.log("BeforeStart: " + this._handlers.toString(), 0);
        try {
            XmlElement parent = this._elements.getLast();
            XmlElement elem = new XmlElement(sName, qName, attrs, this.getLocator());
            elem.verifyNamespace(this._currentPrefixMapping);
            this._elements.addLast(elem);
            XmlHandler hd = this.onStartChild(this._currentHandler, parent, elem);
            this._handlers.addLast(this._currentHandler);
            this._currentHandler = hd;
            this.onStartElement(this._currentHandler, elem);
        }
        catch (BanProcessException e) {
            this.refreshProcessException(e);
            throw e;
        }
        this.log("AfterStart : " + this._handlers.toString(), 0);
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.log("BeforeEnd  : " + this._handlers.toString(), 0);
        try {
            XmlElement elem = this._elements.removeLast();
            this.onEndElement(this._currentHandler, elem);
            this._currentHandler = this._handlers.removeLast();
            this.onEndChild(this._currentHandler, this._elements.getLast(), elem);
        }
        catch (BanProcessException e) {
            this.refreshProcessException(e);
            throw e;
        }
        this.log("AfterEnd   : " + this._handlers.toString(), 0);
    }

    private void onStartElement(XmlHandler handler, XmlElement element) throws SAXParseException {
        this.log("XML  | StartElement : " + element.toString() + " {" + handler.getClass().getSimpleName() + "}", 1);
        handler.onStartElement(element, this);
    }

    private XmlHandler onStartChild(XmlHandler handler, XmlElement parent, XmlElement child) throws SAXParseException {
        this.log("XML  | StartChild   : " + (parent != null ? parent.getName() : "[root]") + "->" + child.getName() + " {" + handler.getClass().getSimpleName() + "}", 1);
        return handler.onStartChild(parent, child, this);
    }

    private void onEndChild(XmlHandler handler, XmlElement parent, XmlElement child) throws SAXParseException {
        this.log("XML  | EndChild     : " + (parent != null ? parent.getName() : "[root]") + "<-" + child.getName() + " {" + (handler != null ? handler.getClass().getSimpleName() : "NullHandle") + "}", 1);
        if (handler != null) {
            handler.onEndChild(parent, child, this);
        }
    }

    private void onEndElement(XmlHandler handler, XmlElement element) throws SAXParseException {
        this.log("XML  | EndElement   : " + element.toString() + " {" + handler.getClass().getSimpleName() + "}", 1);
        handler.onEndElement(element, this);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        XmlElement elem = this._elements.getLast();
        elem.appendText(s);
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        XmlElement elem = this._elements.getLast();
        elem.appendText(s);
    }

    public Locator getLocator() {
        return this._locator;
    }

    public BanProcess getProcess() {
        return this._process;
    }

    public Class getUnitDef(String name) {
        UnitRepositoring unitDefs = this.getProcess().getUnitDefs();
        return unitDefs.getUnitDef(name);
    }
}

