/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.Closable;
import com.dassault.cecilia.lib.ban.type.Handle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class HandleWriter
extends Handle
implements Closable {
    BufferedWriter _writer;
    boolean _closed = false;

    protected HandleWriter(Writer write) {
        if (write instanceof BufferedWriter) {
            this._writer = (BufferedWriter)write;
        }
        this._writer = new BufferedWriter(write);
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public String read() throws IOException {
        throw new IOException("Handle in write mode");
    }

    @Override
    public String read(int size) throws IOException {
        throw new IOException("Handle in write mode");
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void write(String msg) throws IOException {
        this._writer.write(msg);
    }

    @Override
    public void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void close(BanProcess process) {
        if (this._closed) {
            return;
        }
        try {
            this._writer.flush();
            this._closed = true;
            this._writer.close();
        }
        catch (IOException e) {
            process.log("Close Handle ioexception : " + e.getMessage(), 1);
        }
    }
}

