/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;

public class Pattern
extends BanProcessComponent {
    String _name;
    java.util.regex.Pattern _pattern;
    private static final String STAR = "[^/]*";
    private static final String QUEST = "[^/]{1}";
    private static final String PATH = ".*/";
    private static final String SPECIAL_CHAR = ".*+?{}[]()^|$";

    public void setName(String value) {
        this._name = value;
    }

    public void prepare() {
        String fullCode = this.expanse(this._name);
        StringBuffer regex = new StringBuffer(fullCode.length() * 2);
        StringTokenizer st = new StringTokenizer(fullCode, ",");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            regex.append("(^");
            int state = 1;
            if (code.startsWith("**")) {
                state = 1;
            }
            block31: for (int i = 0; i <= code.length(); ++i) {
                char car = '\u0000';
                if (i < code.length()) {
                    car = code.charAt(i);
                }
                if (car == '\\') {
                    car = '/';
                }
                switch (state) {
                    case 0: {
                        switch (car) {
                            case '\u0000': {
                                if (regex.length() >= 2) continue block31;
                                throw this.regexFormat("Empty expression");
                            }
                            case '*': {
                                regex.append(STAR);
                                break;
                            }
                            case '?': {
                                regex.append(QUEST);
                                break;
                            }
                            case '/': {
                                state = 1;
                                break;
                            }
                            default: {
                                regex.append(this.escapeRegex(car));
                                break;
                            }
                        }
                        continue block31;
                    }
                    case 1: {
                        switch (car) {
                            case '\u0000': {
                                if (regex.length() < 2) {
                                    throw this.regexFormat("Empty expression");
                                }
                                regex.append(PATH);
                                continue block31;
                            }
                            case '*': {
                                state = 2;
                                continue block31;
                            }
                            case '?': {
                                regex.append('/').append(QUEST);
                                state = 0;
                                continue block31;
                            }
                            case '/': {
                                throw this.regexFormat("double path char");
                            }
                        }
                        regex.append('/').append(this.escapeRegex(car));
                        state = 0;
                        continue block31;
                    }
                    case 2: {
                        switch (car) {
                            case '\u0000': {
                                regex.append('/').append(STAR);
                                continue block31;
                            }
                            case '*': {
                                state = 3;
                                continue block31;
                            }
                            case '?': {
                                regex.append('/').append(STAR).append(QUEST);
                                state = 0;
                                continue block31;
                            }
                            case '/': {
                                regex.append('/').append(STAR);
                                state = 1;
                                continue block31;
                            }
                        }
                        regex.append('/').append(STAR).append(this.escapeRegex(car));
                        state = 0;
                        continue block31;
                    }
                    case 3: {
                        switch (car) {
                            case '\u0000': {
                                regex.append("/.*");
                                continue block31;
                            }
                            case '/': {
                                regex.append(PATH);
                                state = 0;
                                continue block31;
                            }
                        }
                        throw this.regexFormat("'/' expected");
                    }
                    default: {
                        throw new BanProcessException("Internal error");
                    }
                }
            }
            regex.append("$)");
            if (!st.hasMoreTokens()) continue;
            regex.append("|");
        }
        this.log("Pattern compile : " + fullCode + " => " + regex.toString(), 4);
        try {
            this._pattern = java.util.regex.Pattern.compile(regex.toString());
        }
        catch (PatternSyntaxException e) {
            throw new BanProcessException("Error during compile pattern : " + fullCode + " [<= " + this._name + "]");
        }
    }

    private BanProcessException regexFormat(String msg) {
        return new BanProcessException("Error during pre-compile pattern : " + msg + " [name='" + this._name + "']");
    }

    private String escapeRegex(char car) {
        if (SPECIAL_CHAR.indexOf(car) != -1) {
            return "\\" + car;
        }
        return "" + car;
    }

    public boolean accept(String test) {
        if (this._pattern == null) {
            throw new BanProcessException("Internal error (not call prepare)");
        }
        return this._pattern.matcher(test).find();
    }
}

