/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.launcher.LogDestination;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.layout;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.destination.DestinationFile;
import com.dassault.cecilia.lib.util.destination.DestinationNull;
import com.dassault.cecilia.lib.util.destination.Layout;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class destination
extends BanProcessComponent {
    String _name;
    String _class;
    String _filepath;
    String _fileRefId;
    private String _id;
    private String _optionnal = "false";
    List<Param> _params = new ArrayList<Param>();
    layout _layout;

    private void verifyKey() {
        if (this._name != null) {
            throw new BanProcessException("Attribute 'name' already define : " + this._name);
        }
        if (this._class != null) {
            throw new BanProcessException("Attribute 'class' already define : " + this._class);
        }
        if (this._filepath != null) {
            throw new BanProcessException("Attribute 'file' already define : " + this._filepath);
        }
        if (this._fileRefId != null) {
            throw new BanProcessException("Attribute 'fileref' already define : " + this._fileRefId);
        }
    }

    public void setName(String value) {
        this.verifyKey();
        this._name = value;
    }

    public void setClass(String value) {
        this.verifyKey();
        this._class = value;
    }

    public void setFile(String value) {
        this.verifyKey();
        this._filepath = value;
    }

    public void setFileref(String value) {
        this.verifyKey();
        this._fileRefId = value;
    }

    public void setId(String value) {
        if (this._id != null) {
            this.log("File 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    public void setOptionnal(String value) {
        this._optionnal = value;
    }

    protected boolean isOptionnal() {
        String opt = this.expanse(this._optionnal);
        return this.castBool(opt, "optionnal");
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    public layout createLayout() {
        layout layout2;
        if (this._layout != null) {
            this.log("Layout already define", 1);
        }
        this._layout = layout2 = new layout();
        return this._layout;
    }

    private File getDestinationFile() {
        File dest = null;
        if (this._filepath != null) {
            String path = this.expanse(this._filepath);
            if (path == null || path.length() == 0) {
                throw new BanProcessException("Filepath '" + this._filepath + "' is empty");
            }
            dest = new File(path);
            File parent = dest.getParentFile();
            if (parent == null || !parent.isDirectory()) {
                throw new BanProcessException("File '" + dest.getAbsolutePath() + "' has no parent directory");
            }
        } else if (this._fileRefId != null) {
            String fileRef = this.expanse(this._fileRefId);
            if (!this.isSimpleID(fileRef)) {
                throw this.errorComplexId("fileref", fileRef, this._fileRefId);
            }
            Object obj = this.getProcess().getIdObject(fileRef);
            if (obj == null) {
                throw new BanProcessException("File '" + fileRef + "' unknow");
            }
            if (!(obj instanceof File)) {
                throw new BanProcessException("Object with id '" + fileRef + "' is not file");
            }
            dest = (File)obj;
        } else {
            throw new BanProcessException("Internal error");
        }
        return dest;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<? extends Destination> configureDestination(Map<String, Object> params) {
        void var2_11;
        Object var2_2 = null;
        if (this._name != null) {
            String name = this.expanse(this._name);
            if (name.equalsIgnoreCase("null")) {
                return var2_11;
            }
            if (this._name.equalsIgnoreCase("stdout")) {
                Class<DestinationConsole> clazz = DestinationConsole.class;
                params.put("Error", "false");
                return var2_11;
            } else if (this._name.equalsIgnoreCase("stderr")) {
                Class<DestinationConsole> clazz = DestinationConsole.class;
                params.put("Error", "true");
                return var2_11;
            } else {
                if (!this._name.equalsIgnoreCase("log")) throw new BanProcessException("Possible values for attribute 'name' for element 'destination' : null, stderr, stdout");
                Class<LogDestination> clazz = LogDestination.class;
                params.put("BanProcess", this.getProcess());
            }
            return var2_11;
        }
        if (this._class != null) {
            Class<?> tmpResult = null;
            ClassLoader loader = this.getProcess().getClassLoader();
            String classs = this.expanse(this._class);
            try {
                tmpResult = loader.loadClass(classs);
            }
            catch (ClassNotFoundException e) {
                throw new BanProcessException("Class [" + classs + "] not found");
            }
            if (!Destination.class.isAssignableFrom(tmpResult) || Modifier.isAbstract(tmpResult.getModifiers())) {
                throw new BanProcessException("Class [" + classs + "] is not Destination");
            }
            Class<?> clazz = tmpResult;
            return var2_11;
        }
        if (this._filepath == null && this._fileRefId == null) return var2_11;
        File dest = this.getDestinationFile();
        Class<DestinationFile> clazz = DestinationFile.class;
        params.put("File", dest.getAbsolutePath());
        return var2_11;
    }

    public Destination constructDestination(LayoutDefiner definer) {
        Destination result;
        block10: {
            result = null;
            String id = null;
            if (this._id != null && !this.isSimpleID(id = this.expanse(this._id))) {
                throw this.errorComplexId("id", id, this._id);
            }
            try {
                Object obj;
                Layout currentLayout = this._layout != null ? this._layout.constructLayout(definer) : layout.constructDefaultLayout(definer);
                if (id != null && (obj = this.getProcess().getIdObject(id)) != null && obj instanceof Destination) {
                    result = (Destination)obj;
                }
                if (result == null) {
                    Map<String, Object> params = Param.mapObjectParams(this._params);
                    Class<? extends Destination> cl = this.configureDestination(params);
                    if (cl == null) {
                        throw new BanProcessException("Internal error");
                    }
                    try {
                        result = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        result.configure(params, currentLayout);
                        if (id != null) {
                            this.getProcess().setIdObject(id, result, 2);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        throw new BanProcessException("Class [" + cl.getName() + "] not instantiate", e);
                    }
                }
                result.setLayout(currentLayout);
            }
            catch (BanProcessException e) {
                if (this.isOptionnal()) {
                    this.log(e.getMessage(), 1);
                    result = new DestinationNull();
                }
                throw e;
            }
        }
        return result;
    }
}

