/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutSimple;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutXML;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Layout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class DestinationUnit
extends Unit
implements LayoutDefiner {
    protected List<destination> _destinations = new ArrayList<destination>();
    List<Destination> _Dests;

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    @Override
    public Class<? extends Layout> configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return LogExecLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return LogExecLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for diff unit : " + key);
    }

    protected void openDestination() {
        this._Dests = new ArrayList<Destination>();
        for (destination dest : this._destinations) {
            this._Dests.add(dest.constructDestination(this));
        }
    }

    public void addRecord(LogExecRecord record) {
        if (this._Dests == null) {
            return;
        }
        for (Destination dest : this._Dests) {
            dest.publish(record);
        }
    }

    protected void closeDestination() {
        if (this._Dests == null) {
            return;
        }
        for (Destination dest : this._Dests) {
            dest.close();
        }
        this._Dests = null;
    }
}

