/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitContainer;
import com.dassault.cecilia.lib.ban.UnitValued;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Eval
extends Unit
implements UnitValued,
UnitContainer {
    private static final Map<String, Type> __defineType = new TreeMap<String, Type>();
    private Type _opType;
    protected String _result = "";
    protected List<Unit> _args = new ArrayList<Unit>(3);
    private static final Pattern __isBoolPattern;
    private static final Pattern PATTERN_IS_INT;
    private static final Pattern PATTERN_IS_FLOAT;

    private static Type getType(String opName) {
        return __defineType.get(opName);
    }

    public void setOp(String value) {
        this._opType = Eval.getType(value);
        if (this._opType == null) {
            StringBuffer sb = new StringBuffer(__defineType.size() * 4 + 50);
            sb.append("Attribut 'op' of 'eval' element must be equals : \n\t");
            sb.append(__defineType.keySet().toString());
            throw new BanProcessException(sb.toString());
        }
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    @Override
    public void addUnit(Unit unit) {
        if (!(unit instanceof UnitValued)) {
            throw new BanProcessException("Child of element 'eval' Must be valued unit");
        }
        this._args.add(unit);
        unit.setOwnerUnit(this);
    }

    protected void validArgs() {
        if (this._opType == null) {
            throw new BanProcessException("No attribut 'op' for element 'eval'");
        }
        if (this._opType._nbr < 0) {
            if (this._args.size() < 2) {
                throw new BanProcessException("Number argument for element 'eval' (with op='" + this._opType._code + "') must be greater than 1");
            }
        } else if (this._args.size() != this._opType._nbr) {
            throw new BanProcessException("Number argument for element 'eval' (with op='" + this._opType._code + "') must be equal " + this._opType._nbr);
        }
    }

    public void endValid() {
        this.validArgs();
    }

    @Override
    public void execute() {
        this.validArgs();
        String[] args = new String[this._args.size()];
        for (int i = 0; i < args.length; ++i) {
            Unit unit = this._args.get(i);
            unit.perform();
            args[i] = this.string(unit);
        }
        this._result = this._opType.eval(this, args);
    }

    public Eval() {
    }

    protected Eval(String op) {
        this();
        this.setOp(op);
    }

    public static boolean isNull(String val) {
        return val == null || val.length() == 0;
    }

    public static boolean isBool(String val) {
        return __isBoolPattern.matcher(val).find();
    }

    public static String defineBool() {
        return "[true, false, yes, no, accept]";
    }

    public static boolean Bool(String val) {
        if (val == null || val.length() == 0) {
            return false;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("accept")) {
            return true;
        }
        if (val.equalsIgnoreCase("yes")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        if (val.equalsIgnoreCase("no")) {
            return false;
        }
        if (Eval.isInt(val)) {
            return Eval.Int(val) != 0L;
        }
        return Eval.Float(val) != 0.0;
    }

    public static boolean isInt(String val) {
        return PATTERN_IS_INT.matcher(val).find();
    }

    public static long Int(String val) {
        if (val == null || val.length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static boolean isFloat(String val) {
        return PATTERN_IS_FLOAT.matcher(val).find();
    }

    public static double Float(String val) {
        if (val == null || val.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static boolean And(String ... args) {
        boolean result = true;
        for (int i = 0; i < args.length && (result &= Eval.Bool(args[i])); ++i) {
        }
        return result;
    }

    public static boolean Or(String ... args) {
        boolean result = false;
        for (int i = 0; i < args.length && !(result |= Eval.Bool(args[i])); ++i) {
        }
        return result;
    }

    public static boolean Xor(String ... args) {
        boolean result = Eval.Bool(args[0]);
        for (int i = 1; i < args.length; ++i) {
            result ^= Eval.Bool(args[i]);
        }
        return result;
    }

    public static boolean Iff(String ... args) {
        boolean result = Eval.Bool(args[0]);
        for (int i = 1; i < args.length; ++i) {
            result = !(result ^ Eval.Bool(args[i]));
        }
        return result;
    }

    public static int Crd(String ... args) {
        int result = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!Eval.Bool(args[i])) continue;
            ++result;
        }
        return result;
    }

    private static String arithmetique(int op, String ... args) {
        long iRes = 0L;
        double fRes = 0.0;
        switch (op) {
            case 1: {
                iRes = 0L;
                fRes = 0L;
                break;
            }
            case 2: {
                iRes = 1L;
                fRes = 1L;
                break;
            }
            case 3: {
                fRes = Double.MAX_VALUE;
                iRes = Long.MAX_VALUE;
                break;
            }
            case 4: {
                fRes = -1.7976931348623157E308;
                iRes = Long.MIN_VALUE;
            }
        }
        boolean isInt = true;
        block18: for (int i = 0; i < args.length; ++i) {
            if (isInt && !(isInt &= Eval.isInt(args[i])) && i > 0) {
                fRes = iRes;
            }
            if (isInt) {
                switch (op) {
                    case 1: {
                        iRes += Eval.Int(args[i]);
                        break;
                    }
                    case 2: {
                        iRes *= Eval.Int(args[i]);
                        break;
                    }
                    case 3: {
                        iRes = Math.min(iRes, Eval.Int(args[i]));
                        break;
                    }
                    case 4: {
                        iRes = Math.max(iRes, Eval.Int(args[i]));
                    }
                }
                continue;
            }
            switch (op) {
                case 1: {
                    fRes += Eval.Float(args[i]);
                    continue block18;
                }
                case 2: {
                    fRes *= Eval.Float(args[i]);
                    continue block18;
                }
                case 3: {
                    fRes = Math.min(fRes, Eval.Float(args[i]));
                    continue block18;
                }
                case 4: {
                    fRes = Math.max(fRes, Eval.Float(args[i]));
                }
            }
        }
        if (isInt) {
            return Long.toString(iRes);
        }
        return Double.toString(fRes);
    }

    public static String Add(String ... args) {
        return Eval.arithmetique(1, args);
    }

    public static String Mul(String ... args) {
        return Eval.arithmetique(2, args);
    }

    public static String Min(String ... args) {
        return Eval.arithmetique(3, args);
    }

    public static String Max(String ... args) {
        return Eval.arithmetique(4, args);
    }

    public static String Div(String arg1, String arg2) {
        boolean isInt = Eval.isInt(arg1) & Eval.isInt(arg2);
        if (isInt) {
            return Long.toString(Eval.Int(arg1) / Eval.Int(arg2));
        }
        return Double.toString(Eval.Float(arg1) / Eval.Float(arg2));
    }

    public static String Sub(String arg1, String arg2) {
        boolean isInt = Eval.isInt(arg1) & Eval.isInt(arg2);
        if (isInt) {
            return Long.toString(Eval.Int(arg1) - Eval.Int(arg2));
        }
        return Double.toString(Eval.Float(arg1) - Eval.Float(arg2));
    }

    public static String Mod(String arg1, String arg2) {
        boolean isInt = Eval.isInt(arg1) & Eval.isInt(arg2);
        if (isInt) {
            return Long.toString(Eval.Int(arg1) % Eval.Int(arg2));
        }
        return Double.toString(Eval.Float(arg1) % Eval.Float(arg2));
    }

    public static String Pow(String arg1, String arg2) {
        return Double.toString(Math.pow(Eval.Float(arg1), Eval.Float(arg2)));
    }

    public static String Log(String arg) {
        return Double.toString(Math.log(Eval.Float(arg)));
    }

    public static String Exp(String arg) {
        return Double.toString(Math.exp(Eval.Float(arg)));
    }

    public static String Sqrt(String arg) {
        return Double.toString(Math.sqrt(Eval.Float(arg)));
    }

    public static String Cos(String arg) {
        return Double.toString(Math.cos(Eval.Float(arg)));
    }

    public static String Sin(String arg) {
        return Double.toString(Math.sin(Eval.Float(arg)));
    }

    public static String Tan(String arg) {
        return Double.toString(Math.tan(Eval.Float(arg)));
    }

    public static String Ceil(String arg) {
        return Double.toString(Math.ceil(Eval.Float(arg)));
    }

    public static String Floor(String arg) {
        return Double.toString(Math.floor(Eval.Float(arg)));
    }

    public static String Abs(String arg) {
        if (Eval.isInt(arg)) {
            return Long.toString(Math.abs(Eval.Int(arg)));
        }
        return Double.toString(Math.abs(Eval.Float(arg)));
    }

    public static boolean EQ(String arg1, String arg2) {
        if (Eval.isBool(arg1) && Eval.isBool(arg2)) {
            return Eval.Bool(arg1) == Eval.Bool(arg2);
        }
        boolean i1 = Eval.isInt(arg1);
        boolean i2 = Eval.isInt(arg2);
        if (i1 && i2) {
            return Eval.Int(arg1) == Eval.Int(arg2);
        }
        i1 = i1 || Eval.isFloat(arg1);
        boolean bl = i2 = i2 || Eval.isFloat(arg2);
        if (i1 && i2) {
            return Eval.Float(arg1) == Eval.Float(arg2);
        }
        return arg1.equals(arg2);
    }

    public static boolean NEq(String arg1, String arg2) {
        if (Eval.isBool(arg1) && Eval.isBool(arg2)) {
            return Eval.Bool(arg1) != Eval.Bool(arg2);
        }
        boolean i1 = Eval.isInt(arg1);
        boolean i2 = Eval.isInt(arg2);
        if (i1 && i2) {
            return Eval.Int(arg1) != Eval.Int(arg2);
        }
        i1 = i1 || Eval.isFloat(arg1);
        boolean bl = i2 = i2 || Eval.isFloat(arg2);
        if (i1 && i2) {
            return Eval.Float(arg1) != Eval.Float(arg2);
        }
        return !arg1.equals(arg2);
    }

    public static boolean GT(String arg1, String arg2) {
        if (Eval.isBool(arg1) && Eval.isBool(arg2)) {
            return Eval.Bool(arg1) > Eval.Bool(arg2);
        }
        boolean i1 = Eval.isInt(arg1);
        boolean i2 = Eval.isInt(arg2);
        if (i1 && i2) {
            return Eval.Int(arg1) > Eval.Int(arg2);
        }
        i1 = i1 || Eval.isFloat(arg1);
        boolean bl = i2 = i2 || Eval.isFloat(arg2);
        if (i1 && i2) {
            return Eval.Float(arg1) > Eval.Float(arg2);
        }
        return arg1.compareTo(arg2) > 0;
    }

    public static boolean GEq(String arg1, String arg2) {
        if (Eval.isBool(arg1) && Eval.isBool(arg2)) {
            return Eval.Bool(arg1) >= Eval.Bool(arg2);
        }
        boolean i1 = Eval.isInt(arg1);
        boolean i2 = Eval.isInt(arg2);
        if (i1 && i2) {
            return Eval.Int(arg1) >= Eval.Int(arg2);
        }
        i1 = i1 || Eval.isFloat(arg1);
        boolean bl = i2 = i2 || Eval.isFloat(arg2);
        if (i1 && i2) {
            return Eval.Float(arg1) >= Eval.Float(arg2);
        }
        return arg1.compareTo(arg2) >= 0;
    }

    public static boolean LT(String arg1, String arg2) {
        if (Eval.isBool(arg1) && Eval.isBool(arg2)) {
            return Eval.Bool(arg1) < Eval.Bool(arg2);
        }
        boolean i1 = Eval.isInt(arg1);
        boolean i2 = Eval.isInt(arg2);
        if (i1 && i2) {
            return Eval.Int(arg1) < Eval.Int(arg2);
        }
        i1 = i1 || Eval.isFloat(arg1);
        boolean bl = i2 = i2 || Eval.isFloat(arg2);
        if (i1 && i2) {
            return Eval.Float(arg1) < Eval.Float(arg2);
        }
        return arg1.compareTo(arg2) < 0;
    }

    public static boolean LEq(String arg1, String arg2) {
        if (Eval.isBool(arg1) && Eval.isBool(arg2)) {
            return Eval.Bool(arg1) <= Eval.Bool(arg2);
        }
        boolean i1 = Eval.isInt(arg1);
        boolean i2 = Eval.isInt(arg2);
        if (i1 && i2) {
            return Eval.Int(arg1) <= Eval.Int(arg2);
        }
        i1 = i1 || Eval.isFloat(arg1);
        boolean bl = i2 = i2 || Eval.isFloat(arg2);
        if (i1 && i2) {
            return Eval.Float(arg1) <= Eval.Float(arg2);
        }
        return arg1.compareTo(arg2) <= 0;
    }

    public static int Length(String val) {
        if (val == null) {
            return 0;
        }
        return val.length();
    }

    public static String Concat(String ... args) {
        StringBuffer sb = new StringBuffer(args.length * 32);
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static boolean Prefix(String arg1, String arg2) {
        return arg2.startsWith(arg1);
    }

    public static boolean Matches(String arg1, String arg2) {
        return Pattern.compile(arg2).matcher(arg1).find();
    }

    private static void defineType() {
        Type typ = new Type("and", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.And(args));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("&", typ);
        typ = new Type("or", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.Or(args));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("|", typ);
        typ = new Type("xor", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.Xor(args));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("iff", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.Iff(args));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("crd", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Integer.toString(Eval.Crd(args));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("not", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(!Eval.Bool(args[0]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("!", typ);
        typ = new Type("add", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Add(args);
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("+", typ);
        typ = new Type("mul", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Mul(args);
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("*", typ);
        typ = new Type("min", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Min(args);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("max", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Max(args);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("sub", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Sub(args[0], args[1]);
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("-", typ);
        typ = new Type("div", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Div(args[0], args[1]);
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("/", typ);
        typ = new Type("mod", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Mod(args[0], args[1]);
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("%", typ);
        typ = new Type("pow", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Pow(args[0], args[1]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("log", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Log(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("exp", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Exp(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("sqrt", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Sqrt(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("cos", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Cos(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("sin", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Sin(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("tan", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Tan(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("ceil", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Ceil(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("floor", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Floor(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("abs", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Abs(args[0]);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("eq", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.EQ(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("==", typ);
        __defineType.put("=", typ);
        typ = new Type("neq", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.NEq(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("!=", typ);
        __defineType.put("#=", typ);
        typ = new Type("gt", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.GT(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put(">", typ);
        typ = new Type("geq", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.GEq(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put(">=", typ);
        typ = new Type("lt", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.LT(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("<", typ);
        typ = new Type("leq", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.LEq(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        __defineType.put("<=", typ);
        typ = new Type("isbool", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.isBool(args[0]));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("isint", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.isInt(args[0]));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("isfloat", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.isFloat(args[0]));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("isnull", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.isNull(args[0]));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("existobj", 1){

            @Override
            String eval(Eval eval, String ... args) {
                Object obj = eval.getProcess().getIdObject(args[0]);
                return Boolean.toString(obj != null);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("length", 1){

            @Override
            String eval(Eval eval, String ... args) {
                return Long.toString(Eval.Length(args[0]));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("concat", -1){

            @Override
            String eval(Eval eval, String ... args) {
                return Eval.Concat(args);
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("prefix", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.Prefix(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
        typ = new Type("matches", 2){

            @Override
            String eval(Eval eval, String ... args) {
                return Boolean.toString(Eval.Matches(args[0], args[1]));
            }
        };
        __defineType.put(typ._code, typ);
    }

    static {
        Eval.defineType();
        __isBoolPattern = Pattern.compile("^\\s*((true)|(false)|(yes)|(no)|(accept))\\s*$", 2);
        PATTERN_IS_INT = Pattern.compile("^(\\+|-)?[0-9]+$");
        PATTERN_IS_FLOAT = Pattern.compile("^(\\+|-)?(([0-9]+(\\.[0-9]*)?)|([0-9]*\\.[0-9]+))([eE]([+-])?([0-9])+)?$");
    }

    static abstract class Type {
        String _code;
        int _nbr;

        Type(String code, int nbr) {
            this._code = code;
            this._nbr = nbr;
        }

        abstract String eval(Eval var1, String ... var2);
    }
}

