/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.file;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import java.io.File;

public class FInfo
extends Unit
implements UnitValued {
    UtilFileDst _dst = new UtilFileDst();
    String _result;
    String _pattern;

    public void setSrcfile(String value) {
        this._dst.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._dst.setRef("srcref", value);
    }

    public void setFile(String value) {
        this._dst.setFile("file", value);
    }

    public void setFileref(String value) {
        this._dst.setRef("fileref", value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._dst.setProcess(process);
    }

    public void endValid() {
        this._dst.endValid();
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setPattern(String value) {
        if (this._pattern != null) {
            this.log("Attribute 'pattern' already define : " + this._pattern + " => " + value, 1);
        }
        this._pattern = value;
    }

    @Override
    public void execute() {
        String pattern = this.expanse(this._pattern);
        this._result = this.convertPattern(pattern, this._dst.getDstFile());
    }

    private String convertPattern(String pattern, File file) {
        StringBuffer result = new StringBuffer(64);
        block12: for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '%') {
                if (i + 1 >= pattern.length()) {
                    result.append('%');
                    this.log("End of pattern with simple %", 1);
                    continue;
                }
                switch (pattern.charAt(++i)) {
                    case 'P': {
                        result.append(file.getParentFile().getAbsolutePath());
                        break;
                    }
                    case 'p': {
                        result.append(file.getParent());
                        break;
                    }
                    case 'F': {
                        result.append(file.getAbsolutePath());
                        break;
                    }
                    case 'f': {
                        result.append(file.getPath());
                        break;
                    }
                    case 'N': {
                        result.append(file.getName());
                        break;
                    }
                    case 'n': {
                        String name = file.getName();
                        int pos = name.lastIndexOf(46);
                        if (pos != -1) {
                            result.append(name.substring(0, pos));
                            break;
                        }
                        result.append(name);
                        break;
                    }
                    case 'e': {
                        String name = file.getName();
                        int pos = name.lastIndexOf(46);
                        if (pos == -1) continue block12;
                        result.append(name.substring(pos));
                        break;
                    }
                    case 'S': {
                        if (file.exists() && file.isFile()) {
                            result.append(file.length());
                            break;
                        }
                        result.append(0);
                        break;
                    }
                    case 'M': {
                        if (file.exists() && file.isFile()) {
                            result.append(file.lastModified());
                            break;
                        }
                        result.append(-1);
                        break;
                    }
                    case '%': {
                        result.append('%');
                        break;
                    }
                    default: {
                        this.log("Unknow pattern '" + pattern.charAt(i) + "'", 1);
                        result.append('%').append(pattern.charAt(i));
                        break;
                    }
                }
                continue;
            }
            result.append(pattern.charAt(i));
        }
        return result.toString();
    }
}

