/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.file;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FZipExtract
extends Unit
implements UnitValued {
    private String _result;
    private String _id;
    String _zipFile;
    String _zipRefId;
    String _entry;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setId(String value) {
        if (this._id != null) {
            this.log("File 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    private void verifySetZip() {
        if (this._zipFile != null) {
            throw new BanProcessException("zipfile already define : " + this._zipFile);
        }
        if (this._zipRefId != null) {
            throw new BanProcessException("zipref already define : " + this._zipRefId);
        }
    }

    public void setZipfile(String value) {
        this.verifySetZip();
        this._zipFile = value;
    }

    public void setZipref(String value) {
        this.verifySetZip();
        this._zipRefId = value;
    }

    protected File getZipFile() {
        File zip = null;
        if (this._zipFile != null) {
            zip = new File(this.expanse(this._zipFile));
        } else if (this._zipRefId != null) {
            String zipRef = this.expanse(this._zipRefId);
            if (!this.isSimpleID(zipRef)) {
                throw this.errorComplexId("zipref", zipRef, this._zipRefId);
            }
            Object obj = this.getProcess().getIdObject(zipRef);
            if (obj == null) {
                throw new BanProcessException("File '" + zipRef + "' unknow");
            }
            if (!(obj instanceof File)) {
                throw new BanProcessException("Object with id '" + zipRef + "' is not file");
            }
            zip = (File)obj;
        } else {
            throw new BanProcessException("Internal error");
        }
        if (!zip.canRead()) {
            this.log("Can not read zip file [" + zip.getAbsolutePath() + "]", 1);
        }
        return zip;
    }

    public void setEntry(String value) {
        this._entry = value;
    }

    public void startValid() {
        if (this._zipFile == null && this._zipRefId == null) {
            throw new BanProcessException("No attribut 'zipfile' or 'zipref' define");
        }
        if (this._entry == null) {
            throw new BanProcessException("No attribut 'entry' define");
        }
    }

    @Override
    public void execute() {
        File zipFile = this.getZipFile();
        String name = this.expanse(this._entry);
        File result = null;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(zipFile));
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.getName().equals(name)) {
                    String ext = ".tmp";
                    int pos = name.lastIndexOf(46);
                    if (pos > 0) {
                        ext = name.substring(pos);
                    }
                    result = this.createTempFile("ZipExtract", ext);
                    this.getFinnisher().addTmpFile(result);
                    byte[] tmp = new byte[1024];
                    BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(result));
                    BufferedInputStream fin = new BufferedInputStream(zin);
                    int size = 0;
                    while ((size = fin.read(tmp)) != -1) {
                        fout.write(tmp, 0, size);
                    }
                    fout.close();
                    zin.closeEntry();
                    break;
                }
                zin.closeEntry();
            }
            if (result == null) {
                throw new BanProcessException("No find entry '" + name + "' in '" + zipFile.getPath() + "' zipfile.");
            }
        }
        catch (IOException e) {
            throw new BanProcessException("fzipextract - IOException", e);
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException e) {
                    this.log("IOException during close zipFile : " + e.getMessage(), 2);
                }
            }
        }
        if (this._id != null) {
            String id = this.expanse(this._id);
            if (!this.isSimpleID(id)) {
                throw this.errorComplexId("id", id, this._id);
            }
            this.getProcess().setIdObject(id, result);
        }
        this._result = result.getAbsolutePath();
    }
}

