/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.files;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.FileSet;
import com.dassault.cecilia.lib.ban.type.Pattern;
import com.dassault.cecilia.lib.ban.type.PatternSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class Delete
extends Unit
implements UnitValued {
    protected int _result;
    FileSet _defaultFileSet = new FileSet();
    String _deleteOnExit;
    String _failOnError;
    List<FileSet> _fileSets = new ArrayList<FileSet>();

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._defaultFileSet.setProcess(process);
    }

    public void setDir(String value) {
        this._defaultFileSet.setDir(value);
    }

    public void setFile(String value) {
        this._defaultFileSet.setFile(value);
    }

    public void setExcludes(String value) {
        this._defaultFileSet.setExcludes(value);
    }

    public void setIncludes(String value) {
        this._defaultFileSet.setIncludes(value);
    }

    public Pattern createExclude() {
        return this._defaultFileSet.createExclude();
    }

    public Pattern createInclude() {
        return this._defaultFileSet.createInclude();
    }

    public PatternSet createPatternset() {
        return this._defaultFileSet.createPatternset();
    }

    public void setDeleteonexit(String value) {
        this._deleteOnExit = value;
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    public void endValid() {
        if (this._defaultFileSet.verifyDefault()) {
            this._fileSets.add(this._defaultFileSet);
        }
    }

    public FileSet createFileset() {
        FileSet fs = new FileSet();
        this._fileSets.add(fs);
        return fs;
    }

    @Override
    public void execute() {
        boolean failOnError = false;
        if (this._failOnError != null) {
            failOnError = this.castBool(this.expanse(this._failOnError), "failonerror");
        }
        boolean deleteOnExit = false;
        if (this._deleteOnExit != null) {
            deleteOnExit = this.castBool(this.expanse(this._deleteOnExit), "deleteonexit");
        }
        this._result = 0;
        for (FileSet fs : this._fileSets) {
            fs.prepare();
            String[] files = fs.getIncludedFiles();
            this._result += files.length;
            File path = fs.getBaseDir();
            String pathName = path.getPath().replace('\\', '/');
            for (int i = 0; i < files.length; ++i) {
                String msg;
                File file = new File(path, files[i]);
                if (!file.exists()) {
                    msg = "File don't exist : " + pathName + files[i];
                    if (failOnError) {
                        throw new BanProcessException(msg);
                    }
                    this.log(msg, 0);
                    continue;
                }
                if (file.isDirectory()) {
                    msg = "Can't delete directory : " + pathName + files[i];
                    if (failOnError) {
                        throw new BanProcessException(msg);
                    }
                    this.log(msg, 0);
                    continue;
                }
                if (file.delete()) continue;
                try {
                    Files.delete(file.toPath());
                    continue;
                }
                catch (IOException ioe) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("Can't delete file");
                    buffer.append(" '").append(pathName).append(files[i]).append("'");
                    buffer.append("\n");
                    buffer.append(ioe.getMessage().trim());
                    String msg2 = buffer.toString();
                    if (failOnError) {
                        throw new BanProcessException(msg2);
                    }
                    this.log(msg2, 2);
                    if (!deleteOnExit) continue;
                    file.deleteOnExit();
                }
            }
        }
    }
}

