/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.files;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.FileSet;
import com.dassault.cecilia.lib.ban.type.Pattern;
import com.dassault.cecilia.lib.ban.type.PatternSet;
import com.dassault.cecilia.lib.ban.type.ZipFileSet;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip
extends Unit
implements UnitValued {
    protected int _result;
    UtilFileDst _dst = new UtilFileDst();
    ZipFileSet _defaultFileSet = new ZipFileSet();
    String _comment;
    List<ZipFileSet> _fileSets = new ArrayList<ZipFileSet>();

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._defaultFileSet.setProcess(process);
        this._dst.setProcess(process);
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    public void setBasedir(String value) {
        this._defaultFileSet.setDir(value);
    }

    public void setFile(String value) {
        this._defaultFileSet.setFile(value);
    }

    public void setExcludes(String value) {
        this._defaultFileSet.setExcludes(value);
    }

    public void setIncludes(String value) {
        this._defaultFileSet.setIncludes(value);
    }

    public Pattern createExclude() {
        return this._defaultFileSet.createExclude();
    }

    public Pattern createInclude() {
        return this._defaultFileSet.createInclude();
    }

    public PatternSet createPatternset() {
        return this._defaultFileSet.createPatternset();
    }

    public void setComment(String value) {
        this._comment = value;
    }

    public void endValid() {
        if (this._defaultFileSet.verifyDefault()) {
            this._defaultFileSet.setPrefix("");
            this._fileSets.add(this._defaultFileSet);
        }
        this._dst.endValid();
    }

    public FileSet createFileset() {
        ZipFileSet fs = this.createZipfileset();
        fs.setPrefix("");
        return fs;
    }

    public ZipFileSet createZipfileset() {
        ZipFileSet fs = new ZipFileSet();
        this._fileSets.add(fs);
        return fs;
    }

    @Override
    public void execute() {
        this._result = -1;
        int nbrFile = 0;
        for (ZipFileSet fs : this._fileSets) {
            fs.prepare();
            String[] files = fs.getIncludedFiles();
            if (fs.getFullpath() != null && files.length != 1) {
                throw new BanProcessException("zipfileset with fullpath attribute must define only one file");
            }
            nbrFile += files.length;
        }
        if (nbrFile == 0) {
            this.log("Empty zip", 1);
            this._result = 0;
            return;
        }
        File dst = this._dst.getDstFile();
        try {
            FileOutputStream fout = new FileOutputStream(dst);
            ZipOutputStream zout = new ZipOutputStream(fout);
            if (this._comment != null) {
                zout.setComment(this.expanse(this._comment));
            }
            byte[] tmp = new byte[1024];
            for (ZipFileSet fs : this._fileSets) {
                File path = fs.getBaseDir();
                String[] files = fs.getIncludedFiles();
                String fullpath = fs.getFullpath();
                String prefix = fs.getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                for (int i = 0; i < files.length; ++i) {
                    File file = new File(path, files[i]);
                    Object entrypath = fullpath;
                    if (entrypath == null) {
                        entrypath = prefix.replace('\\', '/');
                        if (((String)entrypath).length() == 0) {
                            entrypath = files[i].substring(1);
                        } else if (((String)entrypath).endsWith("/")) {
                            entrypath = ((String)entrypath).substring(0, ((String)entrypath).length() - 1);
                            entrypath = (String)entrypath + files[i];
                        } else {
                            entrypath = (String)entrypath + files[i];
                        }
                    } else {
                        ((String)entrypath).replace('\\', '/');
                    }
                    ZipEntry ze = new ZipEntry((String)entrypath);
                    zout.putNextEntry(ze);
                    BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
                    int size = 0;
                    while ((size = fin.read(tmp)) != -1) {
                        zout.write(tmp, 0, size);
                    }
                    fin.close();
                    zout.closeEntry();
                }
            }
            this.addExternalEntry(zout);
            zout.close();
            this._result = nbrFile;
        }
        catch (IOException e) {
            throw new BanProcessException(e);
        }
    }

    protected void addExternalEntry(ZipOutputStream zout) throws IOException {
    }
}

