/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.struct;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.Var;

public class Get
extends Unit
implements UnitValued {
    Object _result;
    String _name;
    String _property;
    String _defvalue;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
        this._result = null;
    }

    @Override
    public void execute() {
        if (this._name != null) {
            Var var = this.findVariable(this._name);
            if (var != null) {
                this._result = var.getValue();
            } else {
                this.log("Variable '" + this._name + "' not found", 1);
                this._result = "";
            }
        } else if (this._property != null) {
            String property = this.expanse(this._property);
            String res = this.getProcess().getProperty(property, 4);
            if (res == null) {
                if (this._defvalue == null) {
                    this.log("Property [" + this._property + "] unknow without default value", 1);
                    this._result = "";
                } else {
                    this._result = this._defvalue;
                }
            } else {
                this._result = res;
            }
        }
    }

    protected void verifyInput() {
        if (this._name != null) {
            throw new BanProcessException("'name' already define : " + this._name);
        }
        if (this._property != null) {
            throw new BanProcessException("'property' already define : " + this._name);
        }
    }

    public void setName(String value) {
        this.verifyInput();
        if (!this.isSimpleID(value)) {
            throw new BanProcessException("Variable with complex-name : " + value);
        }
        this._name = value;
    }

    public void setProperty(String value) {
        this.verifyInput();
        this._property = value;
    }

    public void setDefvalue(String value) {
        this._defvalue = value;
    }

    public void startValid() {
        if (this._name == null && this._property == null) {
            throw new BanProcessException("No attribute 'name' or 'property' define");
        }
        if (this._defvalue != null && this._property == null) {
            throw new BanProcessException("Attribute 'defvalue' only with attribute 'property'");
        }
    }
}

