/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.xslt;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.unitdefs.xslt.BanXSLT;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Style
extends BanXSLT
implements UnitValued {
    UtilFileSrc _src = new UtilFileSrc();
    private File _srcFile;
    UtilFileDst _dst = new UtilFileDst();
    String _failOnError;
    boolean _result;

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
        this._dst.setProcess(process);
    }

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public File getSrcFile() {
        if (this._srcFile == null) {
            this._srcFile = this._src.getSrcFile(true);
        }
        return this._srcFile;
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    public File getDstFile() {
        return this._dst.getDstFile();
    }

    @Override
    public void endValid() {
        this._src.endValid();
        this._dst.endValid();
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    protected boolean failOnError() {
        boolean result = true;
        if (this._failOnError != null) {
            result = this.castBool(this.expanse(this._failOnError), "failonerror");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        File srcFile = this._src.getSrcFile();
        File dstFile = this._dst.getDstFile();
        this._result = false;
        for (destination dest : this._destDefines) {
            this.addDestination(dest.constructDestination(this));
        }
        try {
            this.transform(srcFile, dstFile);
            this._result = true;
        }
        catch (Exception e) {
            if (this.failOnError()) {
                throw new BanProcessException("Style : Exception", e);
            }
            LogUtility.logException(Logger.getLogger(this.getClass().getPackage().getName()), Level.INFO, e, "Exception durant une convertion xslt", 2, 10);
            this.log(e.getMessage(), 0);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void freeResult() {
    }

    @Override
    public Object getResult() {
        return this._result;
    }
}

