/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.ban.BanConnected;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class PluginCmdSeqVerif
extends AbstractPluginWithStepper
implements PluginMAction {
    public static final String PROP_SEQVERIF_MAXERROR = "cecilia.mbsa.plugin.seqverif.MaxError";

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResSeqGen.getString("PLUG_CMD_SEQVERIF_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResSeqGen.getString("PLUG_CMD_SEQVERIF_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-05.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return false;
    }

    public void createSession(Plugable launch, Object parameters) {
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        Stepper stepper = null;
        if (parameters instanceof String) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("create.fmodel", "true");
            stepper = this.createStepper((Plugable)launcher, new AbstractPluginWithStepper.InfoStepper((String)parameters, model, params));
        } else {
            stepper = this.createStepper((Plugable)launcher, parameters);
        }
        if (stepper == null) {
            return;
        }
        JFileChooser dlg = new JFileChooser();
        dlg.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)launcher, (String)"plugable.option.path", (String)".")));
        FileFilterExtention xmlFilter = new FileFilterExtention("Sequences file (*.xml)", ".xml").verifyRead(true);
        dlg.addChoosableFileFilter((FileFilter)xmlFilter);
        dlg.setFileFilter((FileFilter)xmlFilter);
        dlg.setMultiSelectionEnabled(true);
        if (dlg.showOpenDialog(launch.getWindow()) != 0) {
            return;
        }
        launcher.setOption("plugable.option.path", dlg.getSelectedFile().getParent());
        BanEntry banStepper = this.verifyStepper(stepper);
        if (banStepper == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSeqGen.getString("ERR_STEPPER"));
            return;
        }
        File logFile = this.createFile((Plugable)launcher, "SeqVerif", ".log");
        if (logFile == null) {
            return;
        }
        BanEntry ban = this.createBanEntry((Plugable)launcher, banStepper, logFile);
        if (ban == null) {
            return;
        }
        ban.setIdObject("stepper-id", (Object)stepper);
        File scriptFile = this.createFile((Plugable)launcher, "BanScriptSeqVerif", ".xml");
        if (scriptFile == null) {
            return;
        }
        BanInputStream script = null;
        try {
            this.createBanScript(scriptFile, dlg.getSelectedFiles());
            script = new BanInputStream(scriptFile);
        }
        catch (IOException e) {
            Logger.getLogger(PluginCmdSeqVerif.class.getPackage().getName()).log(Level.INFO, "CreateBanScript exception", e);
            return;
        }
        this.createTask((Plugable)launcher, model, ban, script, logFile);
    }

    protected void createTask(Plugable launcher, IModel model, BanEntry ban, BanInputStream script, File logFile) {
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, ban, script, logFile){

            protected String getDesc() {
                return ResSeqGen.getString("PLUG_CMD_SEQVERIF_NAME");
            }

            protected String getName() {
                return "SeqVerif";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-05.svg"));
                }
                return super.getIcon(key);
            }
        };
        launcher.addTask((PlugTask)task, model.getUID());
    }

    private BanEntry verifyStepper(Stepper stepper) {
        if (!(stepper instanceof BanConnected)) {
            return null;
        }
        BanEntry ban = ((BanConnected)stepper).getBanEntry();
        if (ban == null) {
            return null;
        }
        Object step = ban.getIdObject("stepper-id");
        if (step == null) {
            return null;
        }
        if (!(step instanceof Stepper)) {
            return null;
        }
        return ban;
    }

    private void createBanScript(File scriptFile, File[] selectedFiles) throws IOException {
        FileWriter writer = new FileWriter(scriptFile);
        writer.write("<?xml version='1.0' encoding='iso-8859-15'?>\n<process name='Verify sequences file' basedir='.'>\n    <block>\n      <!--set name='propagate.onlychange' global='false'>\n        <get property='propagate.onlychange' defvalue='true'/> </set-->\n\n      <set name='seqverif.log.format' global='false'>\n        <get property='seqverif.log.format' defvalue='txt'/> </set>\n\n    <set name='seqverify.result'> \n      <seqverify stepper='stepper-id'> \n");
        for (File selected : selectedFiles) {
            writer.write("        <seqgen file='");
            writer.write(selected.getAbsolutePath().replace('\\', '/'));
            writer.write("'/>\n");
        }
        writer.write("\n        <param name='error.max' value='${seqverif.maxerror}'/>\n        <param name='progress.step' value='${seqverif.progress.step}'/>\n        <destination file='${seqverif.log.path}'>\n          <layout name='%{seqverif.log.format}'/>\n        </destination>\n      </seqverify>\n    </set>\n\n    </block>\n</process>\n");
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    protected BanEntry createBanEntry(Plugable launcher, BanEntry previous, File logFile) {
        BanEntry entry = null;
        try {
            entry = new BanEntry(previous);
        }
        catch (BanLicenseException e) {
            Logger.getLogger(PluginCmdSeqVerif.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return null;
        }
        entry.setUserProperty("seqverif.log.path", logFile.getAbsolutePath());
        entry.setUserProperty("seqverif.maxerror", Integer.toString(Integer.getInteger(PROP_SEQVERIF_MAXERROR, 10)));
        entry.setUserProperty("seqverif.progress.step", "100");
        return entry;
    }
}

