/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.core.swing.table.TableDecoredItem;
import com.dassault.cecilia.lib.mbsa.EventReader;
import com.dassault.cecilia.lib.mbsa.NodeReader;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class PluginItemFilter
implements TableDecoredItem {
    private static final String OP_EQ = "==";
    private static final String OP_NEQ = "!=";
    private static final String OP_GEQ = ">=";
    private static final String OP_GT = ">";
    private static final String OP_LEQ = "<=";
    private static final String OP_LT = "<";
    Filter _data = new Filter();
    private static final Pattern PATTERN_IDENTIFY = Pattern.compile("[a-zA-Z][a-zA-Z0-9._\\-]*");
    FilterDlg _dlg = null;
    private static final int __attribute_sep1 = 47;
    private static final int __attribute_sep2 = 91;
    private static final int __attribute_sep3 = 93;
    private static final Pattern PATTERN_UNICODE = Pattern.compile("0x[0-9a-fA-F]{4}");

    private PluginItemFilter() {
    }

    public static PluginItemFilter createFromCode(String code) {
        int pos = code.indexOf(59);
        if (pos == -1) {
            return null;
        }
        String typeCode = code.substring(0, pos);
        code = code.substring(pos + 1);
        PluginItemFilter result = null;
        for (FilterType type : FilterType.values()) {
            if (!typeCode.equals(type.getCode())) continue;
            result = new PluginItemFilter();
            result._data._type = type;
            break;
        }
        if (result == null) {
            return null;
        }
        if (result._data._type == FilterType.NAME) {
            result._data._patternName = code;
        } else if (result._data._type == FilterType.ATTRIBUTE) {
            pos = code.indexOf(59);
            if (pos == -1) {
                result._data._patternName = code;
                result._data._expressionValue = null;
            } else {
                result._data._patternName = code.substring(0, pos);
                result._data._expressionValue = code.substring(pos + 1);
            }
        }
        return result;
    }

    public PluginItemFilter(FilterType type, String patternName) {
        this(type, patternName, null);
    }

    public PluginItemFilter(FilterType type, String patternName, String expression) {
        this._data._type = type;
        this._data._patternName = patternName;
        this._data._expressionValue = expression;
    }

    public Filter getData() {
        return this._data;
    }

    public Object clone() {
        PluginItemFilter clone = new PluginItemFilter();
        clone._data.copy(this._data);
        return clone;
    }

    public TableDecoredItem getCopy() {
        PluginItemFilter clone = new PluginItemFilter();
        clone._data.copy(this._data);
        return clone;
    }

    public Class<?> getColumnClass(int c) {
        return Filter.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int c) {
        return ResSeqGen.getString("DLG_EXCLUDES");
    }

    public int getDefaultWidth(int c) {
        return 100;
    }

    public Object getValueAt(int c) {
        return this._data;
    }

    public boolean isCellEditable(int c) {
        return true;
    }

    public boolean setValueAt(Object item, int c) {
        if (item instanceof Filter) {
            this._data = (Filter)item;
            return true;
        }
        return false;
    }

    void prepareEditor(Window owner, NodeReader flatNode) {
        TreeSet<String> events = new TreeSet<String>();
        TreeMap<String, Collection> attributesMap = new TreeMap<String, Collection>();
        for (int i = 0; i < flatNode.getEventCount(); ++i) {
            EventReader evtR = flatNode.getEvent(i);
            events.add(evtR.getName());
            Set attributes = evtR.getNamedAttributes();
            if (attributes == null) continue;
            for (String attrName : attributes) {
                Object value;
                HashSet<Object> values = (HashSet<Object>)attributesMap.get(attrName = PluginItemFilter.convertAttributeFromUnicode(attrName));
                if (values == null) {
                    values = new HashSet<Object>();
                    attributesMap.put(attrName, values);
                }
                if ((value = evtR.getValueOfAttribute(attrName)) == null) continue;
                values.add(value);
            }
        }
        this._dlg = new FilterDlg(owner, events, attributesMap);
    }

    private static String convertAttributeFromUnicode(String path) {
        Matcher match = PATTERN_UNICODE.matcher(path);
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (match.find(pos)) {
            String code;
            int sep;
            if (pos < match.start()) {
                sb.append(path.substring(pos, match.start()));
            }
            if ((sep = Integer.parseInt(code = path.substring(match.start() + 2, match.end()), 16)) == 47 || sep == 91 || sep == 93) {
                sb.append((char)sep);
            }
            pos = match.end();
        }
        sb.append(path.substring(pos));
        return sb.toString();
    }

    private static String convertAttributeIntoUnicode(String path) {
        StringBuffer buf = new StringBuffer();
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '/' || c == '[' || c == ']') {
                buf.append("0x00").append(Integer.toHexString(c));
                continue;
            }
            buf.append(Character.toString(c));
        }
        return buf.toString();
    }

    public TableCellEditor getEditor(int c) {
        return new FilterEditor();
    }

    public boolean withError(int column) {
        if (this._data != null) {
            return this._data.withError();
        }
        return true;
    }

    static class Filter {
        FilterType _type;
        String _patternName;
        String _expressionValue;

        Filter() {
        }

        public FilterType getType() {
            return this._type;
        }

        public String getPatternName() {
            return this._patternName;
        }

        public String getExpressionValue() {
            return this._expressionValue;
        }

        public void copy(Filter data) {
            this._type = data._type;
            this._patternName = data._patternName;
            this._expressionValue = data._expressionValue;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append((Object)this._type).append("[");
            if (this._type == FilterType.ATTRIBUTE) {
                sb.append(PluginItemFilter.convertAttributeFromUnicode(this._patternName));
                if (this._expressionValue != null) {
                    sb.append(", ").append(this._expressionValue);
                }
            } else {
                sb.append(this._patternName);
            }
            return sb.append("]").toString();
        }

        public String getCode() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._type.getCode()).append(";");
            sb.append(this._patternName);
            if (this._type == FilterType.ATTRIBUTE && this._expressionValue != null) {
                sb.append(";").append(this._expressionValue);
            }
            return sb.toString();
        }

        boolean withError() {
            switch (this._type) {
                case NAME: {
                    try {
                        Pattern.compile(this._patternName);
                        break;
                    }
                    catch (Exception exc) {
                        return true;
                    }
                }
                case ATTRIBUTE: {
                    if (this._patternName.trim().length() == 0) {
                        return true;
                    }
                    if (this._expressionValue == null) break;
                    if (this._expressionValue.startsWith(PluginItemFilter.OP_EQ)) {
                        return this._expressionValue.substring(2).trim().length() == 0;
                    }
                    if (this._expressionValue.startsWith("=")) {
                        return this._expressionValue.substring(1).trim().length() == 0;
                    }
                    if (this._expressionValue.startsWith(PluginItemFilter.OP_NEQ)) {
                        return this._expressionValue.substring(2).trim().length() == 0;
                    }
                    if (this._expressionValue.startsWith("#")) {
                        return this._expressionValue.substring(1).trim().length() == 0;
                    }
                    if (this._expressionValue.startsWith(PluginItemFilter.OP_GEQ)) {
                        return this._expressionValue.substring(2).trim().length() == 0;
                    }
                    if (this._expressionValue.startsWith(PluginItemFilter.OP_GT)) {
                        return this._expressionValue.substring(1).trim().length() == 0;
                    }
                    if (this._expressionValue.startsWith(PluginItemFilter.OP_LEQ)) {
                        return this._expressionValue.substring(2).trim().length() == 0;
                    }
                    if (!this._expressionValue.startsWith(PluginItemFilter.OP_LT)) break;
                    return this._expressionValue.substring(1).trim().length() == 0;
                }
            }
            return false;
        }
    }

    class FilterDlg
    extends JDialogCecilia {
        private JComboBox _ctrlType;
        private JTextArea _ctrlNamePattern;
        private JComboBox _ctrlAttrSelect;
        private JCheckBox _ctrlAttrWithExpr;
        private JComboBox _ctrlAttrOperator;
        private JTextField _ctrlAttrValue;
        private JPanel _ctrlSwitchPanel;
        protected Filter _select;
        Set<String> _events;
        Map<String, Collection> _attributes;

        FilterDlg(Window win, Set<String> evts, Map<String, Collection> attributes) {
            super(win, true);
            this._events = evts;
            this._attributes = attributes;
            this.init();
        }

        protected void init() {
            super.init();
            this.setTitle(ResSeqGen.getString("DLG_CMD_SEQ_FILTER_TITLE"));
            this.getContentPane().setLayout(new BorderLayout());
            JPanel north = new JPanel(new GridBagLayout());
            north.add((Component)new JLabel(ResMsgVoc.getString((String)"VOC_TYPE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this._ctrlType = new JComboBox();
            this._ctrlType.addItem(FilterType.NAME);
            this._ctrlType.addItem(FilterType.ATTRIBUTE);
            this._ctrlType.setEditable(false);
            this._ctrlType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CardLayout switchLayout = (CardLayout)FilterDlg.this._ctrlSwitchPanel.getLayout();
                    switchLayout.show(FilterDlg.this._ctrlSwitchPanel, e.getItem().toString());
                }
            });
            north.add((Component)this._ctrlType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)north, "North");
            CardLayout switchLayout = new CardLayout();
            this._ctrlSwitchPanel = new JPanel(switchLayout);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
            JPanel internal = new JPanel(new GridBagLayout());
            internal.add((Component)new JLabel(ResSeqGen.getString("DLG_CMD_SEQ_FILTER_NAME_PATTERN")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlNamePattern = new JTextArea(1, 16);
            internal.add((Component)new JScrollPane(this._ctrlNamePattern), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            internal.add((Component)new JLabel(ResSeqGen.getString("DLG_CMD_SEQ_FILTER_NAME_INFO")), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)internal, "Center");
            this._ctrlSwitchPanel.add((Component)panel, FilterType.NAME.toString());
            panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
            this._ctrlAttrSelect = new JComboBox();
            for (String attr : this._attributes.keySet()) {
                this._ctrlAttrSelect.addItem(attr);
            }
            this._ctrlAttrSelect.setEditable(false);
            JPanel select = new JPanel(new GridBagLayout());
            select.add((Component)new JLabel(ResSeqGen.getString("DLG_ATTRIBUTE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            select.add((Component)this._ctrlAttrSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)select, "North");
            this._ctrlAttrOperator = new JComboBox();
            this._ctrlAttrOperator.addItem(PluginItemFilter.OP_EQ);
            this._ctrlAttrOperator.addItem(PluginItemFilter.OP_NEQ);
            this._ctrlAttrOperator.addItem(PluginItemFilter.OP_GT);
            this._ctrlAttrOperator.addItem(PluginItemFilter.OP_GEQ);
            this._ctrlAttrOperator.addItem(PluginItemFilter.OP_LT);
            this._ctrlAttrOperator.addItem(PluginItemFilter.OP_LEQ);
            this._ctrlAttrOperator.setEditable(false);
            this._ctrlAttrValue = new JTextField(16);
            this._ctrlAttrWithExpr = new JCheckBox(ResSeqGen.getString("DLG_EXPRESSION"));
            this._ctrlAttrWithExpr.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FilterDlg.this.refreshCtrl();
                }
            });
            JPanel expressionPanel = new JPanel((LayoutManager)new ToggleBorderLayout());
            expressionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel define = new JPanel(new GridBagLayout());
            define.add((Component)this._ctrlAttrOperator, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            define.add((Component)this._ctrlAttrValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 2, 2), 0, 0));
            ToggleBorderLayout.configure((Container)expressionPanel, (JToggleButton)this._ctrlAttrWithExpr, (JComponent)define);
            panel.add((Component)expressionPanel, "Center");
            if (this._ctrlAttrSelect.getItemCount() == 0) {
                this._ctrlAttrSelect.setEnabled(false);
                this._ctrlAttrWithExpr.setEnabled(false);
                this._ctrlAttrOperator.setEnabled(false);
                this._ctrlAttrValue.setEnabled(false);
            }
            this._ctrlSwitchPanel.add((Component)panel, FilterType.ATTRIBUTE.toString());
            this.getContentPane().add((Component)this._ctrlSwitchPanel, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.pack();
            Dimension size = this.getSize();
            size.width += 50;
            size.height += 50;
            this.setSize(size);
        }

        /*
         * Unable to fully structure code
         */
        protected boolean verifyParameters() {
            block7: {
                block8: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    error = true;
                                    type = (FilterType)this._ctrlType.getSelectedItem();
                                    if (type != FilterType.NAME) break block9;
                                    name = this._ctrlNamePattern.getText();
                                    try {
                                        Pattern.compile(name);
                                    }
                                    catch (Exception exc) {
                                        this._ctrlNamePattern.requestFocus();
                                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlNamePattern), ResSeqGen.getString("DLG_CMD_SEQ_FILTER_NAME_ERROR"), ResSeqGen.getString("DLG_CMD_SEQ_FILTER_TITLE"), 0);
                                        break block7;
                                    }
                                    this._select._type = type;
                                    this._select._patternName = name;
                                    this._select._expressionValue = null;
                                    ** GOTO lbl51
                                }
                                if (type != FilterType.ATTRIBUTE) ** GOTO lbl51
                                attr = this._ctrlAttrSelect.getSelectedItem();
                                if (attr != null) break block10;
                                this._ctrlAttrSelect.requestFocus();
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlAttrSelect), ResSeqGen.getString("DLG_CMD_SEQ_FILTER_ATTR_UNSELECT"), ResSeqGen.getString("DLG_CMD_SEQ_FILTER_TITLE"), 0);
                                break block7;
                            }
                            if (!this._ctrlAttrWithExpr.isSelected()) ** GOTO lbl-1000
                            value = this._ctrlAttrValue.getText().trim();
                            bErrValue = true;
                            if (value.length() == 0) break block8;
                            if (value.length() <= 2 || value.charAt(0) != '\"') break block11;
                            pos = value.indexOf(34, 1);
                            if (pos != -1 && pos == value.length() - 1) break block12;
                            break block8;
                        }
                        if (!PluginItemFilter.PATTERN_IDENTIFY.matcher(value).matches()) {
                            try {
                                Double.parseDouble(value);
                            }
                            catch (NumberFormatException exc) {
                                break block8;
                            }
                        }
                    }
                    bErrValue = false;
                }
                if (bErrValue) {
                    this._ctrlAttrValue.requestFocus();
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlAttrSelect), ResSeqGen.getString("DLG_CMD_SEQ_FILTER_ATTR_UNVALUED"), ResSeqGen.getString("DLG_CMD_SEQ_FILTER_TITLE"), 0);
                } else lbl-1000:
                // 2 sources

                {
                    this._select._type = type;
                    this._select._patternName = PluginItemFilter.convertAttributeIntoUnicode(attr.toString());
                    this._select._expressionValue = this._ctrlAttrWithExpr.isSelected() != false ? this._ctrlAttrOperator.getSelectedItem().toString() + this._ctrlAttrValue.getText().trim() : null;
lbl51:
                    // 3 sources

                    error = false;
                }
            }
            return error == false;
        }

        private void refreshCtrl() {
            boolean select = this._ctrlAttrWithExpr.isSelected();
            this._ctrlAttrOperator.setEnabled(select);
            this._ctrlAttrValue.setEnabled(select);
        }

        boolean DoModal() {
            if (this._select != null) {
                this._ctrlType.setSelectedItem((Object)this._select._type);
                switch (this._select._type) {
                    case NAME: {
                        this._ctrlNamePattern.setText(this._select._patternName);
                        break;
                    }
                    case ATTRIBUTE: {
                        this._ctrlAttrSelect.setSelectedItem(PluginItemFilter.convertAttributeFromUnicode(this._select._patternName));
                        if (this._select._expressionValue != null) {
                            this._ctrlAttrWithExpr.setSelected(true);
                            if (this._select._expressionValue.startsWith(PluginItemFilter.OP_EQ)) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_EQ);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(2));
                                break;
                            }
                            if (this._select._expressionValue.startsWith("=")) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_EQ);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(1));
                                break;
                            }
                            if (this._select._expressionValue.startsWith(PluginItemFilter.OP_NEQ)) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_NEQ);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(2));
                                break;
                            }
                            if (this._select._expressionValue.startsWith("#")) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_NEQ);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(1));
                                break;
                            }
                            if (this._select._expressionValue.startsWith(PluginItemFilter.OP_GEQ)) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_GEQ);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(2));
                                break;
                            }
                            if (this._select._expressionValue.startsWith(PluginItemFilter.OP_GT)) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_GT);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(1));
                                break;
                            }
                            if (this._select._expressionValue.startsWith(PluginItemFilter.OP_LEQ)) {
                                this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_LEQ);
                                this._ctrlAttrValue.setText(this._select._expressionValue.substring(2));
                                break;
                            }
                            if (!this._select._expressionValue.startsWith(PluginItemFilter.OP_LT)) break;
                            this._ctrlAttrOperator.setSelectedItem(PluginItemFilter.OP_LT);
                            this._ctrlAttrValue.setText(this._select._expressionValue.substring(1));
                            break;
                        }
                        this._ctrlAttrWithExpr.setSelected(false);
                        this._ctrlAttrValue.setText("");
                    }
                }
                this.refreshCtrl();
            }
            this.setVisible(true);
            return this.getResult();
        }
    }

    static enum FilterType {
        NAME("DLG_NAME"),
        ATTRIBUTE("DLG_ATTRIBUTE");

        String _lblKey;

        private FilterType(String keyLbl) {
            this._lblKey = keyLbl;
        }

        public String toString() {
            return ResSeqGen.getString(this._lblKey);
        }

        public String getCode() {
            return super.toString();
        }
    }

    class FilterEditor
    extends DefaultTableCellRenderer
    implements TableCellEditor {
        private EventListenerList _listeners = new EventListenerList();
        private ChangeEvent _evt = new ChangeEvent(this);

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PluginItemFilter.this._dlg._select = (Filter)value;
            PluginItemFilter.this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)table));
            Point pt = PluginItemFilter.this._dlg.getLocation();
            pt.x += 100;
            JOptionCecilia.ensureDialogIsIntoScreen((JDialog)((Object)PluginItemFilter.this._dlg));
            PluginItemFilter.this._dlg.setLocation(pt);
            return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }

        @Override
        public void cancelCellEditing() {
            if (PluginItemFilter.this._dlg != null) {
                PluginItemFilter.this._dlg.setVisible(false);
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (PluginItemFilter.this._dlg != null) {
                PluginItemFilter.this._dlg.setVisible(false);
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            if (PluginItemFilter.this._dlg != null) {
                return PluginItemFilter.this._dlg._select;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() >= 2;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PluginItemFilter.this._dlg.DoModal()) {
                        FilterEditor.this.fireEditionStopped();
                    } else {
                        FilterEditor.this.fireEditionCanceled();
                    }
                }
            });
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this._listeners.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this._listeners.remove(CellEditorListener.class, l);
        }

        protected void fireEditionStopped() {
            Object[] lists = this._listeners.getListenerList();
            for (int i = lists.length - 2; i >= 0; i -= 2) {
                ((CellEditorListener)lists[i + 1]).editingStopped(this._evt);
            }
        }

        protected void fireEditionCanceled() {
            Object[] lists = this._listeners.getListenerList();
            for (int i = lists.length - 2; i >= 0; i -= 2) {
                ((CellEditorListener)lists[i + 1]).editingCanceled(this._evt);
            }
        }
    }
}

