-- 
-- Suppression des donnees eventuellement precedentes
-- Pas forcement necessaire
-- 
DELETE FROM cec_db_properties;
DELETE FROM cec_folders;
DELETE FROM cec_users;
DELETE FROM cec_groups;

--
-- Insertion des proprietes de DB
--
INSERT INTO cec_db_properties(dbp_name, dbp_value, dbp_description) values('version', '6.0', 'Version of database');

--
-- Creation du groupe et de l'utilisateur par defaut
--
INSERT INTO cec_groups (grp_id, grp_name, grp_description, grp_flags)  VALUES (1, 'admins', NULL, 8388608);
INSERT INTO cec_users(usr_id, usr_name, usr_login, usr_password, usr_default_grp_id, usr_flags) VALUES (1, 'Master administrator', 'admin', '0A09081901', 1, 8388608);
INSERT INTO cec_groups_users(grp_grp_id, grp_usr_id) VALUES (1, 1);

DROP SEQUENCE cec_groups_pk_seq;
CREATE SEQUENCE cec_groups_pk_seq INCREMENT BY 1 START WITH 2  minvalue 1 nocycle nocache noorder;
DROP SEQUENCE cec_users_pk_seq;
CREATE SEQUENCE cec_users_pk_seq INCREMENT BY 1 START WITH 2  minvalue 1 nocycle nocache noorder;

--
-- Creation des folders par defaut
--

INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 1, NULL, 'ROOT',         	  1, 1, 1, 3, 3, 8388608);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 2, 1,    'BTP',                1, 1, 1, 3, 3, 8388608);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 3, 1,    'PROJECTS',           1, 1, 1, 3, 3, 8392704);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 4, 1,    'COMPONENT_FAMILIES', 1, 1, 1, 3, 3, 8396800);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 5, 1,    'EQUIPMENT_FAMILIES', 1, 1, 1, 3, 3, 8400896);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 6, 1,    'OPERATOR_FAMILIES',  1, 1, 1, 3, 3, 8404992);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 7, 1,    'TYPE_FAMILIES',      1, 1, 1, 3, 3, 8409088);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 8, 2,    'LAW_MODELS',   	  1, 1, 1, 3, 3, 8413184);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES ( 9, 2,    'ATTRIBUTES',   	  1, 1, 1, 3, 3, 8417280);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (10, 2,    'LAW_PARAMETERS',     1, 1, 1, 3, 3, 8421376);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (11, 2,    'BTP_APPLICATIONS',   1, 1, 1, 3, 3, 8425472);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (12, 2,    'BTP_AUTHORS',        1, 1, 1, 3, 3, 8429568);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (13, 2,    'BTP_SUBSTANTIATIONS',1, 1, 1, 3, 3, 8433664);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (14, 2,    'FMEA_MODELS',        1, 1, 1, 3, 3, 8437760);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (15, 2,    'CCF_MODELS',         1, 1, 1, 3, 3, 8441856);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (16, 1,    'IMAGE_FAMILIES',     1, 1, 1, 3, 3, 8450048);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (17,11,    'ALL',   	          1, 1, 1, 1, 1, 1085440);
INSERT INTO cec_folders(fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, fol_access_group, fol_access_other, fol_flags) VALUES (18,12,    'admin',   	          1, 1, 1, 1, 1, 1089536);

DROP SEQUENCE cec_folders_pk_seq;
CREATE SEQUENCE cec_folders_pk_seq INCREMENT BY 1 START WITH 19  minvalue 1 nocycle nocache noorder;

--
-- Commit en fin de traitement
--
COMMIT;
