
DROP TABLE cec_migration_parameters;
CREATE TABLE cec_migration_parameters (
  lpa_id INTEGER not null,
  lpa_fol_id INTEGER not null
);

DROP TABLE cec_migration_attributes;
CREATE TABLE cec_migration_attributes (
  att_id INTEGER not null,
  att_fol_id INTEGER not null
);

DROP TABLE cec_migration_ccfs;
CREATE TABLE cec_migration_ccfs (
  ccf_id INTEGER not null,
  ccf_fol_id INTEGER not null
);

DROP TABLE cec_migration_refobjects;
CREATE TABLE cec_migration_refobjects (
  obj_old_id INTEGER not null,
  fol_id INTEGER not null
);


--
-- insert groups
--
INSERT INTO
	cec_groups(grp_id, grp_name, grp_description) 
SELECT
	cec_groups_pk_seq.nextval, grp_name, grp_description
FROM
	groups 
WHERE 
	grp_name NOT IN (SELECT grp_name FROM cec_groups); 

UPDATE cec_groups SET grp_flags = to_number('00800000', 'XXXXXXXX')
WHERE grp_name='admins';


CREATE TABLE tmp_migration_groups (
  grp_old_id INTEGER not null,
  grp_new_id INTEGER not null
);
INSERT INTO 
  tmp_migration_groups(grp_old_id, grp_new_id)
SELECT
  groups.grp_id, cec_groups.grp_id
FROM
  groups, cec_groups
WHERE
  groups.grp_name = cec_groups.grp_name; 


-- select * from cec_groups; 

--
-- insert users
--
INSERT INTO 
	cec_users(usr_id, usr_name, usr_login, usr_password, usr_default_grp_id, usr_description, usr_flags) 
SELECT
	cec_users_pk_seq.NEXTVAL, usr_name, usr_login, usr_password, tmp_migration_groups.grp_new_id, usr_description, usr_flags 
FROM
  users, groups, tmp_migration_groups  
WHERE 
	usr_login NOT IN (SELECT usr_login FROM cec_users) 
	AND usr_name NOT IN (SELECT usr_name FROM cec_users)
	AND users.usr_default_grp_id = groups.grp_id
	AND groups.grp_id = tmp_migration_groups.grp_old_id; 

UPDATE cec_users SET usr_flags = to_number('00800000', 'XXXXXXXX')
WHERE usr_login='admin';


CREATE TABLE tmp_migration_users (
  usr_old_id INTEGER not null,
  usr_new_id INTEGER not null
);
INSERT INTO 
  tmp_migration_users(usr_old_id, usr_new_id)
SELECT
  users.usr_id, cec_users.usr_id
FROM
  users, cec_users
WHERE
  users.usr_login = cec_users.usr_login; 


-- select * from cec_users; 

--
-- insert relationships between users and groups
--
INSERT INTO 
	cec_groups_users(grp_grp_id, grp_usr_id) 
SELECT 
	tmp_migration_groups.grp_new_id, tmp_migration_users.usr_new_id 
FROM 
	groups_users, groups, tmp_migration_groups, users, tmp_migration_users 
WHERE 
  groups_users.grp_grp_id = groups.grp_id
  AND groups_users.grp_usr_id = users.usr_id
  AND groups.grp_id = tmp_migration_groups.grp_old_id
  AND users.usr_id = tmp_migration_users.usr_old_id
	AND NOT EXISTS (SELECT grp_grp_id, grp_usr_id FROM cec_groups_users); 
 

 
--
-- Gestion des utilisateurs 'orphelins' n'appartenant a aucun groupe
--
INSERT INTO	cec_groups(grp_id, grp_name, grp_description) 
  VALUES (cec_groups_pk_seq.nextval, 'orphans', 'migration orphans'); 

UPDATE cec_users 
  SET usr_default_grp_id = (SELECT grp_id AS sel_grp_id FROM cec_groups WHERE grp_name = 'orphans')
  WHERE usr_id IN (
    SELECT usr_new_id
    FROM users, tmp_migration_users 
    WHERE 
      users.usr_id = tmp_migration_users.usr_old_id
      AND users.usr_id NOT IN (SELECT grp_usr_id FROM groups_users)
  );

INSERT INTO 
	cec_groups_users(grp_grp_id, grp_usr_id) 
SELECT 
	usr_default_grp_id, usr_id 
FROM 
  cec_users
WHERE 
	usr_default_grp_id = (SELECT grp_id FROM cec_groups WHERE grp_name = 'orphans');
	AND NOT EXISTS (SELECT grp_grp_id, grp_usr_id FROM cec_groups_users); 

DROP TABLE tmp_migration_groups;
DROP TABLE tmp_migration_users;
 
--
-- Recuperation des donnees (folders/objects)
--

CREATE TABLE tmp_folders(
 tmp_fol_id INTEGER NOT NULL ,
 tmp_fol_parent_id INTEGER,
 tmp_fol_obj_id INTEGER,
 tmp_fol_name VARCHAR(255) NOT NULL,
 tmp_fol_description VARCHAR(1023),
 tmp_fol_grp_id INTEGER NOT NULL,
 tmp_fol_usr_id INTEGER NOT NULL,
 tmp_fol_access_group NUMERIC(1) DEFAULT 0 NOT NULL,
 tmp_fol_access_other NUMERIC(1) DEFAULT 0 NOT NULL,
 tmp_fol_date_creation DATE NOT NULL,
 tmp_fol_date_modification DATE NOT NULL,
 tmp_fol_last_modifier_usr_id INTEGER NOT NULL,
 tmp_fol_flags INTEGER DEFAULT 0 NOT NULL,
 tmp_fol_obj_flags INTEGER DEFAULT 0 NOT NULL
) ;

INSERT INTO 
	tmp_folders(
		tmp_fol_id, tmp_fol_parent_id, tmp_fol_obj_id, 
		tmp_fol_name, tmp_fol_description,
		tmp_fol_date_creation, tmp_fol_date_modification,
		tmp_fol_grp_id, tmp_fol_usr_id, tmp_fol_last_modifier_usr_id, 
		tmp_fol_access_group, tmp_fol_access_other, 
		tmp_fol_flags, tmp_fol_obj_flags
	) 
SELECT 
	fol_id, fol_parent_id, obj_ver_id,
	fol_name, fol_description,
	obj_ver_creation_date,
	obj_last_modification_date,
	new_group.grp_id,
	new_user.usr_id,
	new_user_mod.usr_id,
	obj_group_access,
	obj_other_access,
	fol_flags, obj_flags
FROM 
	folders, objects, 
		groups old_group,     users old_user,     users old_user_mod, 
	cec_groups new_group, cec_users new_user, cec_users new_user_mod
WHERE 
	fol_obj_ver_id = obj_ver_id 
	AND obj_grp_id = old_group.grp_id 
	AND obj_usr_id = old_user.usr_id 
	AND obj_last_modifier_usr_id = old_user_mod.usr_id 
	AND old_group.grp_name = new_group.grp_name 
	AND old_user.usr_login = new_user.usr_login
	AND old_user_mod.usr_login = new_user_mod.usr_login;

INSERT INTO 
	tmp_folders(
		tmp_fol_id, tmp_fol_parent_id, 
		tmp_fol_name, tmp_fol_description,
		tmp_fol_date_creation, tmp_fol_date_modification,
		tmp_fol_grp_id, tmp_fol_usr_id, tmp_fol_last_modifier_usr_id, 
		tmp_fol_access_group, tmp_fol_access_other, tmp_fol_flags
	) 
SELECT DISTINCT 
	child.fol_id, 
	child.fol_parent_id, 
	child.fol_name, 
	child.fol_description,
	obj_ver_creation_date, 
	obj_last_modification_date,
	new_group.grp_id, 
	new_user.usr_id, 
	new_user_mod.usr_id,
	obj_group_access, 
	obj_other_access, 
	child.fol_flags
FROM 
	folders child, folders parent, objects,
		groups old_group,     users old_user,     users old_user_mod, 
	cec_groups new_group, cec_users new_user, cec_users new_user_mod
WHERE 
	child.fol_obj_ver_id IS NULL
	AND child.fol_parent_id = parent.fol_id
	AND parent.fol_obj_ver_id = obj_ver_id
	AND obj_grp_id = old_group.grp_id 
	AND obj_usr_id = old_user.usr_id 
	AND obj_last_modifier_usr_id = old_user_mod.usr_id 
	AND old_group.grp_name = new_group.grp_name 
	AND old_user.usr_login = new_user.usr_login
	AND old_user_mod.usr_login = new_user_mod.usr_login;
	

-- DROP TABLE tmp_objects;
	
CREATE TABLE tmp_objects(
 tmp_new_id NUMBER(10) NOT NULL,
 tmp_new_flags INTEGER DEFAULT 0 NOT NULL,
 tmp_old_id NUMBER(10) NOT NULL,
 tmp_other_id NUMBER(10) DEFAULT 0 NOT NULL,
 tmp_other_type INTEGER DEFAULT 0 NOT NULL
);

INSERT INTO 
	tmp_objects(tmp_new_id, tmp_old_id, tmp_new_flags)
SELECT 
  cec_objects_pk_seq.nextval, tmp_fol_obj_id, tmp_fol_obj_flags
FROM (SELECT DISTINCT 
			    tmp_fol_obj_id, tmp_fol_obj_flags 
			  FROM  tmp_folders
			  WHERE tmp_fol_obj_id IS NOT NULL
			  ORDER BY tmp_fol_obj_id
			);

-- SELECT * FROM TMP_OBJECTS ;

INSERT INTO 
	cec_migration_refobjects(obj_old_id, fol_id)
SELECT DISTINCT 
	tmp_fol_obj_id, tmp_fol_id
FROM 
	tmp_folders
WHERE 
	tmp_fol_obj_id IS NOT NULL;
	
-- Insertion des Objects avec des nouveaux ID
-- ------------------------------------------	
INSERT INTO 
	cec_objects(obj_id, obj_flags) 
SELECT 
	tmp_new_id, tmp_new_flags
FROM 
	tmp_objects;

-- Suppression des vrais doublons de la table extended_properties (epr_obj_ver_id, epr_name, epr_value)
DELETE
FROM   extended_properties tep1
WHERE  tep1.epr_id < ANY (
  SELECT tep2.epr_id
    FROM   extended_properties tep2
  WHERE tep1.epr_id <> tep2.epr_id
    AND tep1.epr_obj_ver_id = tep2.epr_obj_ver_id
    AND tep1.epr_name = tep2.epr_name 
    AND tep1.epr_value = tep2.epr_value);
	
-- Insertion des proprietes des objets
INSERT INTO
	cec_obj_properties(opr_id, opr_obj_id, opr_name, opr_value, opr_type)
SELECT
	cec_obj_properties_pk_seq.nextval, tmp_new_id, epr_name, epr_value, epr_type
FROM 
	tmp_objects, objects, extended_properties
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = epr_obj_ver_id
	AND epr_name <> 'project.criticity.definition';
 
UPDATE cec_obj_properties SET opr_type = 'Long'
	WHERE opr_type IS NULL AND opr_name = 'object.release';
	
UPDATE cec_obj_properties SET opr_type = 'Date'
	WHERE opr_type IS NULL AND opr_name = 'btp.substantiation.date';

UPDATE cec_obj_properties SET opr_type = 'Double'
	WHERE opr_type IS NULL AND opr_name = 'tree.compute.time';

-- Insertion des models des objets
-- Sans prendre en compte les simulateurs ou resultats sauvegardes
-- Sans prendre en compte les systemes compiles
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size
FROM 
	tmp_objects, objects, models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = mod_obj_ver_id
	AND mod_previous = 0
	AND NOT(models.mod_nature LIKE 'system.stepper.%') 
	AND NOT(models.mod_nature LIKE 'tree.compute.%') 
	AND NOT(models.mod_nature = 'system.compiled')
	;

UPDATE cec_obj_models SET mod_format = 'ZIP', mod_encoding =''
	WHERE mod_nature LIKE 'associated.file.%';
	
	
-- Sauvegarde des modeles MBSA dans l'ancien format (pour une meilleure garantie de conservation des donnees)
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, CONCAT(mod_nature, '.51'), mod_format, mod_encoding, mod_data, mod_data_size
FROM 
	tmp_objects, objects, models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = mod_obj_ver_id
	AND mod_previous = 0
	AND (
	   (models.mod_nature = 'type.structured') 
	OR (models.mod_nature = 'type.enumerated') 
	OR (models.mod_nature = 'operator')
	OR (models.mod_nature = 'component')
	OR (models.mod_nature = 'equipment')
	OR (models.mod_nature = 'system.local') )
	;

-- Convertion des proprietes etendues en models des objets
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, lepr_name, lepr_type, lepr_value, -1
FROM 
	tmp_objects, objects, long_extended_properties
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = lepr_obj_ver_id;

-- Convertion des fault-tree en models des objets
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, 'tree.dag', 'ARBOR', ftr_data_equ, ftr_data_equ_size
FROM 
	tmp_objects, objects, fault_trees
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = ftr_fol_obj_ver_id
	AND ftr_previous = 0;
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, 'tree.def', 'ARBOR', ftr_data_def, ftr_data_def_size
FROM 
	tmp_objects, objects, fault_trees
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = ftr_fol_obj_ver_id
	AND ftr_previous = 0;
INSERT INTO
  cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
  cec_obj_models_pk_seq.nextval, tmp_new_id, 'tree.def.51', 'ARBOR', ftr_data_def, ftr_data_def_size
FROM 
  tmp_objects, objects, fault_trees
WHERE
  tmp_old_id = obj_ver_id
  AND obj_ver_id = ftr_fol_obj_ver_id
  AND ftr_previous = 0;
	
-- Convertion des attributes en models des objets
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, 'attribute', 'FRB', att_type, LENGTH(att_type)
FROM 
	tmp_objects, tmp_folders, objects, attributes
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND tmp_fol_id = att_fol_id;
	
INSERT INTO cec_migration_attributes(att_id, att_fol_id)
  SELECT att_id, att_fol_id FROM attributes;
	
-- Convertion des parameters en models des objets
CREATE TABLE tmp_parameters(
	tmp_par_obj_id INTEGER NOT NULL UNIQUE,
	tmp_par_raw VARCHAR(2048) NOT NULL
);
INSERT INTO 
	tmp_parameters(tmp_par_obj_id, tmp_par_raw) 
SELECT
	tmp_new_id, 
	RAWTOHEX(CONCAT(CONCAT(CONCAT(CONCAT('<?xml version="1.0"?><cec.parameter type="', lpa_type_id), '">'), lpa_value), '</cec.parameter>'))
FROM 
	tmp_objects, tmp_folders, objects, law_parameters
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND tmp_fol_id = lpa_fol_id;
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_par_obj_id, 'parameter', 'RAW', tmp_par_raw, LENGTH(tmp_par_raw)
FROM 
	tmp_parameters;
DROP TABLE tmp_parameters;

INSERT INTO cec_migration_parameters(lpa_id, lpa_fol_id)
  SELECT lpa_id, lpa_fol_id FROM law_parameters;

-- Convertion des law_models en models des objets
CREATE TABLE tmp_laws(
	tmp_law_obj_id INTEGER NOT NULL UNIQUE,
	tmp_law_raw VARCHAR(2048) NOT NULL
);
INSERT INTO 
	tmp_laws(tmp_law_obj_id, tmp_law_raw) 
SELECT
	tmp_new_id, 
	RAWTOHEX(CONCAT(CONCAT(CONCAT(CONCAT('refApp=', lmd_app_fol_id), CONCAT(';refAut=', lmd_aut_fol_id)), CONCAT(';refSub=', lmd_sub_fol_id)), CONCAT(';law=', lmd_law)))
FROM 
	tmp_objects, tmp_folders, objects, law_models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND obj_ver_id = lmd_obj_ver_id
    AND lmd_sub_fol_id IS NOT NULL;
INSERT INTO 
	tmp_laws(tmp_law_obj_id, tmp_law_raw) 
SELECT
	tmp_new_id, 
	RAWTOHEX(CONCAT(CONCAT(CONCAT('refApp=', lmd_app_fol_id), CONCAT(';refAut=', lmd_aut_fol_id)), CONCAT(';refSub=;law=', lmd_law)))
FROM 
	tmp_objects, tmp_folders, objects, law_models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND obj_ver_id = lmd_obj_ver_id
    AND lmd_sub_fol_id IS NULL;
	
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_law_obj_id, 'frb.def', 'RAW', tmp_law_raw, LENGTH(tmp_law_raw)
FROM 
	tmp_laws;
DROP TABLE tmp_laws;

-- Copy des couleurs de simulation pour les modeles AltaRica du dossier modele aux dossiers fils versions
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, tmp_new_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size
FROM 
	tmp_objects, tmp_folders, models
WHERE
	tmp_old_id = tmp_fol_obj_id
	AND mod_nature = 'system.colors' 
	AND mod_fol_id = tmp_fol_parent_id
	AND mod_previous = 0;

-- Copy des configurations initiales pour les modeles AltaRica du dossier modele aux dossiers fils versions
CREATE TABLE tmp_configs(
 cfg_id NUMBER(10) NOT NULL,
 cfg_obj_id NUMBER(10) NOT NULL,
 cfg_nature VARCHAR2(255) NOT NULL,
 cfg_format VARCHAR2(10),
 cfg_encoding VARCHAR2(20),
 cfg_data BLOB NOT NULL,
 cfg_data_size NUMERIC DEFAULT 0 NOT NULL
);
CREATE SEQUENCE tmp_configs_pk_seq INCREMENT BY 1 START WITH 1  minvalue 1 nocycle nocache noorder;
INSERT INTO
	tmp_configs(cfg_id, cfg_obj_id, cfg_nature, cfg_format, cfg_encoding, cfg_data, cfg_data_size)
SELECT 
	tmp_configs_pk_seq.nextval, tmp_new_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size
FROM 
	tmp_objects, tmp_folders, models
WHERE
	tmp_old_id = tmp_fol_obj_id
	AND models.mod_nature LIKE 'system.states.%' 
	AND models.mod_fol_id = tmp_fol_parent_id
	AND models.mod_previous = 0;
DELETE FROM tmp_configs
WHERE cfg_id IN (SELECT cfg_id FROM tmp_configs, cec_obj_models 
				 WHERE cfg_obj_id = mod_obj_id AND cfg_nature = mod_nature);
INSERT INTO
	cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_data, mod_data_size)
SELECT
	cec_obj_models_pk_seq.nextval, cfg_obj_id, cfg_nature, cfg_format, cfg_encoding, cfg_data, cfg_data_size
FROM tmp_configs;
DROP TABLE tmp_configs;
DROP SEQUENCE tmp_configs_pk_seq;

-- Convertion des differentes valeurs de criticity par concatenation
CREATE TABLE tmp_criticities(
  tmp_criticity_obj_ver_id INTEGER NOT NULL UNIQUE,
  tmp_criticity_raw VARCHAR(2048) NOT NULL
);
INSERT INTO 
  tmp_criticities(tmp_criticity_obj_ver_id, tmp_criticity_raw) 
SELECT
  obj_ver_id, RAWTOHEX( LISTAGG(epr_value, ',') WITHIN GROUP (ORDER BY epr_value) )
FROM 
  objects, extended_properties
WHERE
  obj_ver_id = epr_obj_ver_id
  AND epr_name = 'project.criticity.definition'
GROUP BY obj_ver_id;
INSERT INTO
  cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
  cec_obj_models_pk_seq.nextval, tmp_new_id, 'criticity.def', 'RAW', tmp_criticity_raw, LENGTH(tmp_criticity_raw)
FROM 
  tmp_objects, tmp_criticities
WHERE
  tmp_old_id = tmp_criticity_obj_ver_id;
DROP TABLE tmp_criticities;


	
-- Insertion des Folders definitifs
-- ---------------------------------	

CREATE TABLE tmp_fol_objects(
 tfo_new_id INTEGER DEFAULT NULL,
 tfo_old_id INTEGER NOT NULL
);
INSERT INTO tmp_fol_objects(tfo_old_id) VALUES(-1);
INSERT INTO tmp_fol_objects(tfo_new_id, tfo_old_id) 
	SELECT tmp_new_id, tmp_old_id FROM tmp_objects;
UPDATE tmp_folders SET tmp_fol_obj_id = -1
	WHERE tmp_fol_obj_id IS NULL;

INSERT INTO 
	cec_folders(
		fol_id, fol_parent_id, fol_obj_id, 
		fol_name, fol_description,
		fol_date_creation, fol_date_modification,
		fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
		fol_access_group, fol_access_other, fol_flags
	) 
SELECT 
	tmp_fol_id, tmp_fol_parent_id, tfo_new_id, 
	tmp_fol_name, tmp_fol_description,
	tmp_fol_date_creation, tmp_fol_date_modification,
	tmp_fol_grp_id, tmp_fol_usr_id, tmp_fol_last_modifier_usr_id, 
	tmp_fol_access_group, tmp_fol_access_other, tmp_fol_flags
FROM tmp_folders, tmp_fol_objects
WHERE tmp_fol_obj_id = tfo_old_id
ORDER BY tmp_fol_id;

DROP TABLE tmp_fol_objects;

-- 
-- Mise a jour de la sequence pour la table cec_folders
--

DROP SEQUENCE cec_folders_pk_seq;
SET SERVEROUTPUT ON;
EXECUTE dbms_output.enable(1000000);

DECLARE
   new_max   INTEGER;
   strg      VARCHAR2 (255);
BEGIN
   SELECT MAX (fol_id)+1 INTO new_max FROM cec_folders;

   strg :=
         'CREATE SEQUENCE cec_folders_pk_seq INCREMENT BY 1 START WITH '
      || new_max
      || ' minvalue 1 nocycle nocache noorder ';

   EXECUTE IMMEDIATE strg;
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.Put_Line ('Operation failed');
      DBMS_OUTPUT.Put_Line (SQLERRM);
END;
/

	
-- Define APPL folders
UPDATE cec_folders SET fol_flags = to_number('00800000', 'XXXXXXXX') 
	WHERE fol_name = 'ROOT' AND fol_parent_id IS NULL;
UPDATE cec_folders SET fol_flags = to_number('00800000', 'XXXXXXXX') 
	WHERE fol_parent_id = (
		SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00800000', 'XXXXXXXX')
	);
UPDATE cec_folders SET fol_flags = to_number('00800000', 'XXXXXXXX') 
	WHERE fol_parent_id = (
		SELECT fol_id FROM cec_folders WHERE fol_name = 'BTP' AND fol_flags = to_number('00800000', 'XXXXXXXX')
	);

-- Change fol_flags's folder for application folders
UPDATE cec_folders SET fol_flags = to_number('00801000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'PROJECTS';
UPDATE cec_folders SET fol_flags = to_number('00802000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'COMPONENT_FAMILIES';
UPDATE cec_folders SET fol_flags = to_number('00803000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'EQUIPMENT_FAMILIES';
UPDATE cec_folders SET fol_flags = to_number('00804000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'OPERATOR_FAMILIES';
UPDATE cec_folders SET fol_flags = to_number('00805000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'TYPE_FAMILIES';
UPDATE cec_folders SET fol_flags = to_number('00806000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'LAW_MODELS';
UPDATE cec_folders SET fol_flags = to_number('00807000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'ATTRIBUTES';
UPDATE cec_folders SET fol_flags = to_number('00808000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'LAW_PARAMETERS';
UPDATE cec_folders SET fol_flags = to_number('00809000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'BTP_APPLICATIONS';
UPDATE cec_folders SET fol_flags = to_number('0080A000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'BTP_AUTHORS';
UPDATE cec_folders SET fol_flags = to_number('0080B000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'BTP_SUBSTANTIATIONS';
UPDATE cec_folders SET fol_flags = to_number('0080C000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'FMEA_MODELS';
UPDATE cec_folders SET fol_flags = to_number('0080F000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2 WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'IMAGE_FAMILIES';

-- Convertion du FaultTree folder en CCF folder
UPDATE cec_folders 
  SET fol_flags = to_number('0080D000', 'XXXXXXXX'), fol_access_group = 2, fol_access_other = 2, fol_name = 'CCF_MODELS'
  WHERE fol_flags = to_number('00800000', 'XXXXXXXX') AND fol_name = 'FAULT_TREES';
-- Change parent's folder for attributes and parameters
UPDATE cec_folders 
	SET fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00800000', 'XXXXXXXX')  AND fol_name = 'BTP')
	WHERE fol_flags >= to_number('00806000', 'XXXXXXXX')  AND fol_flags <= to_number('0080D000', 'XXXXXXXX')  ;

--
-- Typage des differents dossiers
--
	
-- Define PROJECT folders
UPDATE cec_folders SET fol_flags = to_number('00401800', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00801000', 'XXXXXXXX'));
-- Define SYSTEM folders
UPDATE cec_folders SET fol_flags = to_number('00401000', 'XXXXXXXX')
	WHERE fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00401800', 'XXXXXXXX'))=to_number('00401800', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);

-- Define BIGTREE folders
UPDATE cec_folders SET fol_flags = to_number('00201500', 'XXXXXXXX')
	WHERE fol_flags = 0 AND fol_id IN (
		SELECT M.fol_id 
		  FROM 
		    cec_folders S,
		    cec_folders M, 
		    cec_folders V,
			cec_objects O
		  WHERE M.fol_flags = 0
		    AND BITAND(S.fol_flags, to_number('00401000', 'XXXXXXXX'))=to_number('00401000', 'XXXXXXXX')  
		    AND M.fol_parent_id = S.fol_id
		    AND V.fol_parent_id = M.fol_id
		    AND V.fol_obj_id = O.obj_id
		    AND BITAND(O.obj_flags, 4)=4
		);
-- Define TREE folders
UPDATE cec_folders SET fol_flags = to_number('00201200', 'XXXXXXXX')
  WHERE fol_flags = 0 AND fol_id IN (
    SELECT C.fol_id FROM cec_folders C, cec_folders P
    WHERE BITAND(P.fol_flags, to_number('00401000', 'XXXXXXXX'))=to_number('00401000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define FMEA folders
UPDATE cec_folders SET fol_flags = to_number('00201400', 'XXXXXXXX')
  WHERE fol_flags = 1 AND fol_id IN (
    SELECT C.fol_id FROM cec_folders C, cec_folders P
    WHERE BITAND(P.fol_flags, to_number('00401000', 'XXXXXXXX'))=to_number('00401000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define MODEL folders
UPDATE cec_folders SET fol_flags = to_number('00201100', 'XXXXXXXX')
	WHERE fol_flags = 2 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00401000', 'XXXXXXXX'))=to_number('00401000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define DSF folders
UPDATE cec_folders SET fol_flags = to_number('00201300', 'XXXXXXXX')
  WHERE fol_flags = 3 AND fol_id IN (
    SELECT C.fol_id FROM cec_folders C, cec_folders P
    WHERE BITAND(P.fol_flags, to_number('00401000', 'XXXXXXXX'))=to_number('00401000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Patch pour les versions de DSF qui ont un Flag positionne a 3
UPDATE cec_folders SET fol_flags = 0
  WHERE fol_flags = 3 AND fol_id IN (
    SELECT C.fol_id FROM cec_folders C, cec_folders P
    WHERE BITAND(P.fol_flags, to_number('00201300', 'XXXXXXXX'))=to_number('00201300', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);

-- Define COMPONENT_FOLDER folders
UPDATE cec_folders SET fol_flags = to_number('00402000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00802000', 'XXXXXXXX'));
UPDATE cec_folders SET fol_flags = to_number('00402000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00402000', 'XXXXXXXX'))=to_number('00402000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define COMPONENT_MODEL folders
UPDATE cec_folders SET fol_flags = to_number('00202000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00402000', 'XXXXXXXX'))=to_number('00402000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);

-- Define EQUIPMENT_FOLDER folders
UPDATE cec_folders SET fol_flags = to_number('00403000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00803000', 'XXXXXXXX'));
UPDATE cec_folders SET fol_flags = to_number('00403000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00403000', 'XXXXXXXX'))=to_number('00403000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define EQUIPMENT_MODEL folders
UPDATE cec_folders SET fol_flags = to_number('00203000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00403000', 'XXXXXXXX'))=to_number('00403000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);

-- Define OPERATOR_FOLDER folders
UPDATE cec_folders SET fol_flags = to_number('00404000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00804000', 'XXXXXXXX'));
UPDATE cec_folders SET fol_flags = to_number('00404000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00404000', 'XXXXXXXX'))=to_number('00404000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define OPERATOR_MODEL folders
UPDATE cec_folders SET fol_flags = to_number('00204000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00404000', 'XXXXXXXX'))=to_number('00404000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
		
-- Define TYPE_FOLDER folders
UPDATE cec_folders SET fol_flags = to_number('00405000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00805000', 'XXXXXXXX'));
UPDATE cec_folders SET fol_flags = to_number('00405000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00405000', 'XXXXXXXX'))=to_number('00405000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define TYPE_MODEL folders Enum
UPDATE cec_folders SET fol_flags = to_number('00205100', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT M.fol_id FROM cec_folders F, cec_folders M, cec_folders V, cec_objects O, cec_obj_properties P
		WHERE BITAND(F.fol_flags, to_number('00405000', 'XXXXXXXX'))=to_number('00405000', 'XXXXXXXX') 
			AND M.fol_parent_id = F.fol_id AND V.fol_parent_id = M.fol_id 
			AND V.fol_obj_id = O.obj_id AND P.opr_obj_id = O.obj_id 
			AND P.opr_name='models.types.subtype' AND P.opr_value='type.enumerated'		
		);
-- Define TYPE_MODEL folders Link
UPDATE cec_folders SET fol_flags = to_number('00205200', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT M.fol_id FROM cec_folders F, cec_folders M, cec_folders V, cec_objects O, cec_obj_properties P
		WHERE BITAND(F.fol_flags, to_number('00405000', 'XXXXXXXX'))=to_number('00405000', 'XXXXXXXX') 
			AND M.fol_parent_id = F.fol_id AND V.fol_parent_id = M.fol_id 
			AND V.fol_obj_id = O.obj_id AND P.opr_obj_id = O.obj_id 
			AND P.opr_name='models.types.subtype' AND P.opr_value='type.structured'		
		);
	
-- Define IMAG_FOLDER folders
UPDATE cec_folders SET fol_flags = to_number('0040F000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('0080F000', 'XXXXXXXX'));
-- Define IMAG_MODEL folders
UPDATE cec_folders SET fol_flags = to_number('0020F000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('0040F000', 'XXXXXXXX'))=to_number('0040F000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);

-- Define LAW_MODELS_FOLDER folders
UPDATE cec_folders SET fol_flags = to_number('00406000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00806000', 'XXXXXXXX'));
UPDATE cec_folders SET fol_flags = to_number('00406000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00406000', 'XXXXXXXX'))=to_number('00406000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
UPDATE cec_folders SET fol_flags = to_number('00406000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00406000', 'XXXXXXXX'))=to_number('00406000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
UPDATE cec_folders SET fol_flags = to_number('00406000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00406000', 'XXXXXXXX'))=to_number('00406000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define LAW_MODELS folders
UPDATE cec_folders SET fol_flags = to_number('00206000', 'XXXXXXXX')
	WHERE BITAND(fol_flags, to_number('007FF000', 'XXXXXXXX')) = 0 AND fol_id IN (
		SELECT C.fol_id FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00406000', 'XXXXXXXX'))=to_number('00406000', 'XXXXXXXX') AND C.fol_parent_id = P.fol_id);
-- Define BTP_APPLICATIONS folders
UPDATE cec_folders SET fol_flags = to_number('00109000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00809000', 'XXXXXXXX'));
-- Define BTP_AUTHORS folders
UPDATE cec_folders SET fol_flags = to_number('0010A000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('0080A000', 'XXXXXXXX'));
-- Define BTP_SUBSTANTIATIONS folders
UPDATE cec_folders SET fol_flags = to_number('0010B000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('0080B000', 'XXXXXXXX'));

-- Define ATTRIBUTES folders
UPDATE cec_folders SET fol_flags = to_number('00207000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00807000', 'XXXXXXXX'));
-- Define LAW_PARAMETERS folders
UPDATE cec_folders SET fol_flags = to_number('00208000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00808000', 'XXXXXXXX'));

-- Define FMEA_MODELS folders
UPDATE cec_folders SET fol_flags = to_number('0020C000', 'XXXXXXXX')
	WHERE fol_parent_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('0080C000', 'XXXXXXXX'));


-- Define all version folders
CREATE TABLE flg_folders(
 flg_id INTEGER NOT NULL ,
 flg_parent_flags INTEGER NOT NULL
);
-- For information : No BITOR in oracle => BITOR(x,y) = x + y - BITAND(x,y)
INSERT INTO flg_folders(flg_id, flg_parent_flags)
	SELECT C.fol_id, P.fol_flags FROM cec_folders C, cec_folders P
		WHERE BITAND(P.fol_flags, to_number('00200000', 'XXXXXXXX'))!=0 AND C.fol_flags = 0 AND C.fol_parent_id = P.fol_id;
UPDATE cec_folders
	SET fol_flags = ( SELECT BITAND(flg_parent_flags + to_number('00100000', 'XXXXXXXX') - BITAND(flg_parent_flags, to_number('00100000', 'XXXXXXXX')), to_number('FFDFFFFF', 'XXXXXXXX'))
			            FROM flg_folders WHERE fol_id = flg_id )
	WHERE fol_flags = 0 AND fol_id IN ( SELECT flg_id FROM flg_folders );
DROP TABLE flg_folders;

-- Suppression des objets vides dans les arborescences

CREATE TABLE tmp_count_model (
	tmp_obj_id INTEGER NOT NULL UNIQUE,
	tmp_count INTEGER NOT NULL
);
INSERT INTO tmp_count_model(tmp_obj_id, tmp_count)
  SELECT obj_id, COUNT(*) 
    FROM cec_objects, cec_obj_models 
    WHERE obj_id = mod_obj_id 
    GROUP BY obj_id;

CREATE TABLE tmp_count_prop (
	tmp_obj_id INTEGER NOT NULL UNIQUE,
	tmp_count INTEGER NOT NULL
);
INSERT INTO tmp_count_prop(tmp_obj_id, tmp_count)
  SELECT obj_id, COUNT(*) 
    FROM cec_objects, cec_obj_properties 
    WHERE obj_id = opr_obj_id AND opr_name <> 'object.release'
    GROUP BY obj_id;

CREATE TABLE tmp_delete_obj (
	tmp_obj_id INTEGER NOT NULL UNIQUE
);
-- Ajout dans la liste des objets a supprimer les folders non versions qui n'ont ni modeles, ni proprietes
INSERT INTO tmp_delete_obj(tmp_obj_id)
  SELECT fol_obj_id FROM cec_folders
	WHERE (fol_obj_id IS NOT NULL)
	  AND (BITAND(fol_flags, to_number('00100000', 'XXXXXXXX')) = 0)
    AND ( NOT(fol_obj_id IN (SELECT tmp_obj_id FROM tmp_count_model )) )
    AND ( NOT(fol_obj_id IN (SELECT tmp_obj_id FROM tmp_count_prop  )) );
-- Ajout dans la liste des objets a supprimer les folders de type BPT_x qui n'ont ni modeles, ni proprietes
INSERT INTO tmp_delete_obj(tmp_obj_id)
  SELECT fol_obj_id FROM cec_folders
	WHERE (fol_obj_id IS NOT NULL) 
      AND (fol_flags = to_number('00109000', 'XXXXXXXX') OR fol_flags = to_number('0010A000', 'XXXXXXXX') OR fol_flags = to_number('0010B000', 'XXXXXXXX'))
    AND ( NOT(fol_obj_id IN (SELECT tmp_obj_id FROM tmp_count_model )) )
    AND ( NOT(fol_obj_id IN (SELECT tmp_obj_id FROM tmp_count_prop  )) );
-- Ajout dans la liste des objets a supprimer les folders de type PROJECT/version/model qui n'ont ni modeles, ni proprietes
INSERT INTO tmp_delete_obj(tmp_obj_id)
  SELECT fol_obj_id FROM cec_folders
	WHERE (fol_obj_id IS NOT NULL) 
	  AND (fol_flags = to_number('00101100', 'XXXXXXXX'))
      AND ( NOT(fol_obj_id IN (SELECT tmp_obj_id FROM tmp_count_model )) )
	  AND ( NOT(fol_obj_id IN (SELECT tmp_obj_id FROM tmp_count_prop  )) );

UPDATE cec_folders SET fol_obj_id = NULL
	WHERE fol_obj_id IN (SELECT tmp_obj_id FROM tmp_delete_obj);
DELETE FROM cec_objects WHERE obj_id IN (SELECT tmp_obj_id FROM tmp_delete_obj);

DROP TABLE tmp_delete_obj;
DROP TABLE tmp_count_model;
DROP TABLE tmp_count_prop;

-- Suppression de l'information BIGTREE sur la table des objets
UPDATE cec_objects SET obj_flags = BITAND(obj_flags, 4294967291) -- FFFF FFFB
  WHERE obj_id IN (
	SELECT O.obj_id
	  FROM 
	    cec_folders V,
		cec_objects O
	  WHERE V.fol_flags = to_number('00101500', 'XXXXXXXX') 
	    AND V.fol_obj_id = O.obj_id
	    AND BITAND(O.obj_flags, 4)=4
	);



-- Creation d'une famille par defaut pour les attributs
INSERT INTO cec_folders(
	fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
	fol_access_group, fol_access_other, fol_flags)  
SELECT
	cec_folders_pk_seq.nextval, fol_id, 'Default', fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
	2, 2, to_number('00407000', 'XXXXXXXX')
FROM 
	cec_folders
WHERE fol_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00807000', 'XXXXXXXX'));
-- Deplacement des attributs dans cette famille et changement des droits d'acces
UPDATE cec_folders 
	SET fol_access_group = 2, fol_access_other = 2,
		fol_parent_id = (SELECT fol_id FROM  cec_folders WHERE fol_flags = to_number('00407000', 'XXXXXXXX'))
	WHERE fol_flags = to_number('00207000', 'XXXXXXXX');
-- Changement des droits d'acces pour les versions (au moins lecture seule pour tous)
UPDATE cec_folders SET fol_access_other = 1 WHERE fol_flags = to_number('00107000', 'XXXXXXXX') AND fol_access_other = 0;
UPDATE cec_folders SET fol_access_group = fol_access_other 
	WHERE fol_flags = to_number('00107000', 'XXXXXXXX') AND fol_access_group < fol_access_other;

	
-- Creation d'une famille par defaut pour les parametres
INSERT INTO cec_folders(
	fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
	fol_access_group, fol_access_other, fol_flags)  
SELECT
	cec_folders_pk_seq.nextval, fol_id, 'Default', fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
	2, 2, to_number('00408000', 'XXXXXXXX')
FROM 
	cec_folders
WHERE fol_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('00808000', 'XXXXXXXX'));
-- Deplacement des parametres dans cette famille et changement des droits d'acces
UPDATE cec_folders 
	SET fol_access_group = 2, fol_access_other = 2,
		fol_parent_id = (SELECT fol_id FROM  cec_folders WHERE fol_flags = to_number('00408000', 'XXXXXXXX'))
	WHERE fol_flags = to_number('00208000', 'XXXXXXXX');
-- Changement des droits d'acces pour les versions (au moins lecture seule pour tous)
UPDATE cec_folders SET fol_access_other = 1 WHERE fol_flags = to_number('00108000', 'XXXXXXXX') AND fol_access_other = 0;
UPDATE cec_folders SET fol_access_group = fol_access_other 
	WHERE fol_flags = to_number('00108000', 'XXXXXXXX') AND fol_access_group < fol_access_other;



-- Convertion des CCF en Folder 
-- Partie folder::model
INSERT INTO cec_folders(
  fol_id, fol_parent_id, fol_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
  fol_access_group, fol_access_other, fol_flags)  
SELECT
  cec_folders_pk_seq.nextval, fol_id, ccf_name, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
  0, 0, to_number('0020D000', 'XXXXXXXX')
FROM 
  cec_folders, ccf
WHERE fol_id = (SELECT fol_id FROM cec_folders WHERE fol_flags = to_number('0080D000', 'XXXXXXXX'));
-- Create object for CCF
INSERT INTO 
  tmp_objects(tmp_new_id, tmp_old_id, tmp_other_id, tmp_other_type) 
SELECT 
  cec_objects_pk_seq.nextval, 0, ccf_id, 13
FROM 
  ccf;
INSERT INTO 
  cec_objects(obj_id, obj_flags) 
SELECT 
  tmp_new_id, tmp_new_flags
FROM 
  tmp_objects
WHERE tmp_other_id != 0 AND tmp_other_type = 13;
-- Partie folder::version
INSERT INTO cec_folders(
  fol_id, fol_parent_id, fol_obj_id, fol_name, fol_description, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
  fol_access_group, fol_access_other, fol_flags)  
SELECT
  cec_folders_pk_seq.nextval, fol_id, tmp_new_id, '1', ccf_description, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
  0, 0, to_number('0010D000', 'XXXXXXXX')
FROM 
  cec_folders, ccf, tmp_objects
WHERE fol_flags = to_number('0020D000', 'XXXXXXXX') AND fol_name = ccf_name AND ccf_id = tmp_other_id;
-- Convertion table CCF en flux de donnees
CREATE TABLE tmp_ccfs(
  tmp_ccf_obj_id INTEGER NOT NULL UNIQUE,
  tmp_ccf_raw VARCHAR(2048) NOT NULL
);
INSERT INTO 
  tmp_ccfs(tmp_ccf_obj_id, tmp_ccf_raw) 
SELECT tmp_new_id, 
  RAWTOHEX(CONCAT(CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('type=', ccf_type), CONCAT(';arg0=', ccf_factor_0)), CONCAT(';arg1=',ccf_factor_1)), CONCAT(';arg2=',ccf_factor_2)), CONCAT(';arg3=',ccf_factor_3)), CONCAT(';law=', ccf_law)))
FROM 
  tmp_objects, ccf
WHERE 
  tmp_other_id = ccf_id;
INSERT INTO
  cec_obj_models(mod_id, mod_obj_id, mod_nature, mod_format, mod_data, mod_data_size)
SELECT
  cec_obj_models_pk_seq.nextval, tmp_ccf_obj_id, 'ccf.def', 'RAW', tmp_ccf_raw, LENGTH(tmp_ccf_raw)
FROM 
  tmp_ccfs;
DROP TABLE tmp_ccfs;
-- Table de migration pour la migration des flux
INSERT INTO cec_migration_ccfs(ccf_id, ccf_fol_id)
  SELECT ccf_id, fol_id 
  FROM ccf, tmp_objects, cec_folders 
  WHERE tmp_other_type=13 AND tmp_other_id=ccf_id AND tmp_new_id = fol_obj_id;


-- Ajout d'une version pour les modeles d'AMDEC
INSERT INTO cec_folders(
  fol_id, fol_parent_id, fol_obj_id, fol_name, fol_description, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
  fol_date_creation, fol_date_modification, fol_access_group, fol_access_other, fol_flags)  
SELECT
  cec_folders_pk_seq.nextval, fol_id, fol_obj_id, '1', fol_description, fol_grp_id, fol_usr_id, fol_last_modifier_usr_id, 
  fol_date_creation, fol_date_modification, fol_access_group, fol_access_other, to_number('0010C000', 'XXXXXXXX')
FROM 
  cec_folders
WHERE fol_flags = to_number('0020C000', 'XXXXXXXX');
UPDATE cec_folders SET fol_obj_id = NULL, fol_description = NULL WHERE fol_flags = to_number('0020C000', 'XXXXXXXX') ;

-- Mise a jour de la proprietes permettant de connaitre le modele d'AMDEC d'une table d'AMDEC
INSERT INTO	
  cec_obj_properties(opr_id, opr_obj_id, opr_name, opr_value, opr_type)
SELECT
  cec_obj_properties_pk_seq.nextval, tmp_new_id, fep_name, M.fol_id, 'Long'
FROM
  tmp_folders C, tmp_folders P, cec_folders M, folder_ext_props, tmp_objects, objects
WHERE
  P.tmp_fol_id = fep_fol_id
  AND C.tmp_fol_parent_id = P.tmp_fol_id
  AND tmp_old_id = obj_ver_id
  AND C.tmp_fol_obj_id = obj_ver_id
  AND fep_name = 'fmea.model.id'
  AND fep_value = M.fol_parent_id;


-- SELECT  fol_id AS id, fol_parent_id AS parent, fol_name AS name, fol_description AS descr, fol_date_creation AS creat, fol_date_modification AS modif, fol_grp_id AS grp, fol_usr_id AS usr, fol_last_modifier_usr_id AS lusr, to_char(fol_flags,'XXXXXXX') AS flags FROM cec_folders WHERE fol_flags != 0 


-- Gestion des droits d'acces specifique
INSERT INTO 
	cec_accesses( acc_fol_id, acc_grp_id, acc_rights) 
SELECT 
	fol_id AS acc_fol_id, 
	new_group.grp_id AS acc_grp_id, 
	grp_acc_access AS acc_rights
FROM 
	folders, objects, group_access_rights,
		groups old_group, 
	cec_groups new_group
WHERE 
	fol_obj_ver_id = obj_ver_id 
	AND obj_ver_id = grp_acc_obj_ver_id
	AND grp_acc_grp_id = old_group.grp_id 
	AND old_group.grp_name = new_group.grp_name 
;


-- Ajout des relations entre dossiers
INSERT INTO 
	cec_relations(rel_src_id, rel_dst_id, rel_src_type, rel_dst_type) 
SELECT 
	comp_rel_ref_id,
	comp_rel_model_id,
	comp_rel_ref_type,
	comp_rel_model_type
FROM composition_relationships;

-- Ajout des relations entre models de BTP et APPLICATION/AUTHOR/SUBSTANTIATION
INSERT INTO 
	cec_relations(rel_src_id, rel_dst_id, rel_src_type, rel_dst_type) 
SELECT
	tmp_fol_id, lmd_app_fol_id, 'FRB_MODEL', 'FRB_APPL'
FROM 
	tmp_objects, tmp_folders, objects, law_models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND obj_ver_id = lmd_obj_ver_id;
INSERT INTO 
	cec_relations(rel_src_id, rel_dst_id, rel_src_type, rel_dst_type) 
SELECT
	tmp_fol_id, lmd_aut_fol_id, 'FRB_MODEL', 'FRB_AUTHOR'
FROM 
	tmp_objects, tmp_folders, objects, law_models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND obj_ver_id = lmd_obj_ver_id;
INSERT INTO 
	cec_relations(rel_src_id, rel_dst_id, rel_src_type, rel_dst_type) 
SELECT
	tmp_fol_id, lmd_sub_fol_id, 'FRB_MODEL', 'FRB_SUBST'
FROM 
	tmp_objects, tmp_folders, objects, law_models
WHERE
	tmp_old_id = obj_ver_id
	AND obj_ver_id = tmp_fol_obj_id
	AND obj_ver_id = lmd_obj_ver_id
	AND lmd_sub_fol_id IS NOT NULL;


	
	
	
-- Suppression recursive des dossiers avec des simulations compiles seules
CREATE TABLE tmp_rec_folder (
	rec_fol_parent_id INTEGER NOT NULL,
    rec_fol_id INTEGER NOT NULL,
	rec_level INTEGER NOT NULL
);
CREATE TABLE tmp_cpt_folder (
    cpt_fol_id INTEGER NOT NULL,
	cpt_nbr INTEGER NOT NULL
);

INSERT INTO tmp_rec_folder(rec_fol_parent_id, rec_fol_id, rec_level)
  SELECT fol_parent_id, fol_id, 0
    FROM cec_folders
    WHERE NVL(fol_obj_id, -1) = -1 and fol_flags = to_number('00101100', 'XXXXXXXX');
DELETE FROM cec_folders
    WHERE NVL(fol_obj_id, -1) = -1 and fol_flags = to_number('00101100', 'XXXXXXXX');

INSERT INTO tmp_rec_folder(rec_fol_parent_id, rec_fol_id, rec_level)
  SELECT fol_parent_id, fol_id, 1
    FROM cec_folders 
    WHERE fol_id IN (SELECT rec_fol_parent_id FROM tmp_rec_folder WHERE rec_level=0);
INSERT INTO tmp_cpt_folder(cpt_fol_id, cpt_nbr)
  SELECT tmp_rec_folder.rec_fol_id, COUNT(cec_folders.fol_parent_id)
    FROM tmp_rec_folder 
      LEFT JOIN cec_folders ON tmp_rec_folder.rec_fol_id = cec_folders.fol_parent_id
    WHERE rec_level= 1
    GROUP BY tmp_rec_folder.rec_fol_id;
DELETE FROM cec_folders
    WHERE fol_id IN (SELECT cpt_fol_id FROM tmp_cpt_folder WHERE cpt_nbr = 0);
DELETE FROM tmp_cpt_folder;

INSERT INTO tmp_rec_folder(rec_fol_parent_id, rec_fol_id, rec_level)
  SELECT fol_parent_id, fol_id, 2
    FROM cec_folders 
    WHERE fol_id IN (SELECT rec_fol_parent_id FROM tmp_rec_folder WHERE rec_level=1);
INSERT INTO tmp_cpt_folder(cpt_fol_id, cpt_nbr)
  SELECT tmp_rec_folder.rec_fol_id, COUNT(cec_folders.fol_parent_id)
    FROM tmp_rec_folder 
      LEFT JOIN cec_folders ON tmp_rec_folder.rec_fol_id = cec_folders.fol_parent_id
    WHERE rec_level=2
    GROUP BY tmp_rec_folder.rec_fol_id;
DELETE FROM cec_folders
    WHERE fol_id IN (SELECT cpt_fol_id FROM tmp_cpt_folder WHERE cpt_nbr = 0);
DELETE FROM tmp_cpt_folder;

INSERT INTO tmp_rec_folder(rec_fol_parent_id, rec_fol_id, rec_level)
  SELECT fol_parent_id, fol_id, 3
    FROM cec_folders 
    WHERE fol_id IN (SELECT rec_fol_parent_id FROM tmp_rec_folder WHERE rec_level=2);
INSERT INTO tmp_cpt_folder(cpt_fol_id, cpt_nbr)
  SELECT tmp_rec_folder.rec_fol_id, COUNT(cec_folders.fol_parent_id)
    FROM tmp_rec_folder 
      LEFT JOIN cec_folders ON tmp_rec_folder.rec_fol_id = cec_folders.fol_parent_id
    WHERE rec_level=3
    GROUP BY tmp_rec_folder.rec_fol_id;
DELETE FROM cec_folders
    WHERE fol_id IN (SELECT cpt_fol_id FROM tmp_cpt_folder WHERE cpt_nbr = 0);
DELETE FROM tmp_cpt_folder;

DROP TABLE tmp_rec_folder;
DROP TABLE tmp_cpt_folder;




	
	
-- Suppression des donnees inutiles
DELETE FROM cec_obj_properties 
WHERE opr_name = 'models.types.subtype';

	
-- Suppression des tables temporaires
DROP TABLE tmp_objects;
DROP TABLE tmp_folders;


-- 
-- Mise a jour du numero de version du schema de la base de données
--
INSERT INTO cec_db_properties(dbp_name, dbp_value, dbp_description) values('version', '6.0', 'Version of database');


--
-- Commit en fin de traitement
--
COMMIT;
