/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.diag;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.SftpStatVFS;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;

public class JschSftp {
    private static String help = "      Available commands:\n      * means unimplemented command.\ncd path                       Change remote directory to 'path'\nlcd path                      Change local directory to 'path'\nchgrp grp path                Change group of file 'path' to 'grp'\nchmod mode path               Change permissions of file 'path' to 'mode'\nchown own path                Change owner of file 'path' to 'own'\ndf [path]                     Display statistics for current directory or\n                              filesystem containing 'path'\nhelp                          Display this help text\nget remote-path [local-path]  Download file\nget-resume remote-path [local-path]  Resume to download file.\nget-append remote-path [local-path]  Append remote file to local file\nhardlink oldpath newpath      Hardlink remote file\n*lls [ls-options [path]]      Display local directory listing\nln oldpath newpath            Symlink remote file\n*lmkdir path                  Create local directory\nlpwd                          Print local working directory\nls [path]                     Display remote directory listing\n*lumask umask                 Set local umask to 'umask'\nmkdir path                    Create remote directory\nput local-path [remote-path]  Upload file\nput-resume local-path [remote-path]  Resume to upload file\nput-append local-path [remote-path]  Append local file to remote file.\npwd                           Display remote working directory\nstat path                     Display info about path\nexit                          Quit sftp\nquit                          Quit sftp\nrename oldpath newpath        Rename remote file\nrmdir path                    Remove remote directory\nrm path                       Delete remote file\nsymlink oldpath newpath       Symlink remote file\nreadlink path                 Check the target of a symbolic link\nrealpath path                 Canonicalize the path\nrekey                         Key re-exchanging\ncompression level             Packet compression will be enabled\nversion                       Show SFTP version\n?                             Synonym for help";

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] arg) {
        block81: {
            try {
                JSch jsch = new JSch();
                String host = null;
                host = arg.length > 0 ? arg[0] : JOptionPane.showInputDialog("Enter username@hostname", (Object)(System.getProperty("user.name") + "@localhost"));
                String user = host.substring(0, host.indexOf(64));
                host = host.substring(host.indexOf(64) + 1);
                int port = 22;
                Session session = jsch.getSession(user, host, port);
                MyUserInfo ui = new MyUserInfo();
                session.setUserInfo((UserInfo)ui);
                session.connect();
                Channel channel = session.openChannel("sftp");
                channel.connect();
                ChannelSftp c = (ChannelSftp)channel;
                InputStream in = System.in;
                PrintStream out = System.out;
                Vector<String> cmds = new Vector<String>();
                byte[] buf = new byte[1024];
                int level = 0;
                block26: while (true) {
                    int foo;
                    String path;
                    String cmd;
                    block80: {
                        byte k;
                        byte[] bar;
                        out.print("sftp> ");
                        cmds.removeAllElements();
                        int i = in.read(buf, 0, 1024);
                        boolean bl = true;
                        while (true) {
                            int ii;
                            block85: {
                                int s;
                                block86: {
                                    block83: {
                                        block84: {
                                            block82: {
                                                if (!bl || (bl = false)) break block82;
                                                if (i <= 0) break block83;
                                                if (--i > 0 && buf[i - 1] == 13) {
                                                    --i;
                                                }
                                                s = 0;
                                                ii = 0;
                                            }
                                            if (ii >= i) break block84;
                                            if (buf[ii] != 32) break block85;
                                            if (ii - s <= 0) break block86;
                                            cmds.addElement(new String(buf, s, ii - s));
                                            break block86;
                                        }
                                        if (s < i) {
                                            cmds.addElement(new String(buf, s, i - s));
                                        }
                                        if (cmds.size() == 0) continue block26;
                                        cmd = (String)cmds.elementAt(0);
                                        if (cmd.equals("quit")) {
                                            c.quit();
                                        } else if (cmd.equals("exit")) {
                                            c.exit();
                                        } else {
                                            String p1;
                                            if (cmd.equals("rekey")) {
                                                session.rekey();
                                                continue block26;
                                            }
                                            if (cmd.equals("compression")) {
                                                if (cmds.size() < 2) {
                                                    out.println("compression level: " + level);
                                                    continue block26;
                                                }
                                                try {
                                                    level = Integer.parseInt((String)cmds.elementAt(1));
                                                    if (level == 0) {
                                                        session.setConfig("compression.s2c", "none");
                                                        session.setConfig("compression.c2s", "none");
                                                    } else {
                                                        session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                                                        session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                session.rekey();
                                                continue block26;
                                            }
                                            if (cmd.equals("cd") || cmd.equals("lcd")) {
                                                if (cmds.size() < 2) continue block26;
                                                path = (String)cmds.elementAt(1);
                                                try {
                                                    if (cmd.equals("cd")) {
                                                        c.cd(path);
                                                        continue block26;
                                                    }
                                                    c.lcd(path);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("rm") || cmd.equals("rmdir") || cmd.equals("mkdir")) {
                                                if (cmds.size() < 2) continue block26;
                                                path = (String)cmds.elementAt(1);
                                                try {
                                                    if (cmd.equals("rm")) {
                                                        c.rm(path);
                                                        continue block26;
                                                    }
                                                    if (cmd.equals("rmdir")) {
                                                        c.rmdir(path);
                                                        continue block26;
                                                    }
                                                    c.mkdir(path);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("chgrp") || cmd.equals("chown") || cmd.equals("chmod")) {
                                                if (cmds.size() != 3) continue block26;
                                                path = (String)cmds.elementAt(2);
                                                foo = 0;
                                                if (cmd.equals("chmod")) {
                                                    bar = ((String)cmds.elementAt(1)).getBytes();
                                                    break;
                                                }
                                                try {
                                                    foo = Integer.parseInt((String)cmds.elementAt(1));
                                                    break block80;
                                                }
                                                catch (Exception e) {
                                                    continue block26;
                                                }
                                            }
                                            if (cmd.equals("pwd") || cmd.equals("lpwd")) {
                                                Object str = cmd.equals("pwd") ? "Remote" : "Local";
                                                str = (String)str + " working directory: ";
                                                str = cmd.equals("pwd") ? (String)str + c.pwd() : (String)str + c.lpwd();
                                                out.println((String)str);
                                                continue block26;
                                            }
                                            if (cmd.equals("ls") || cmd.equals("dir")) {
                                                path = ".";
                                                if (cmds.size() == 2) {
                                                    path = (String)cmds.elementAt(1);
                                                }
                                                try {
                                                    Vector vv = c.ls(path);
                                                    if (vv == null) continue block26;
                                                    int ii2 = 0;
                                                    while (true) {
                                                        if (ii2 >= vv.size()) continue block26;
                                                        Object obj = vv.elementAt(ii2);
                                                        if (obj instanceof ChannelSftp.LsEntry) {
                                                            out.println(((ChannelSftp.LsEntry)obj).getLongname());
                                                        }
                                                        ++ii2;
                                                    }
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                    continue block26;
                                                }
                                            }
                                            if (cmd.equals("lls") || cmd.equals("ldir")) {
                                                path = ".";
                                                if (cmds.size() == 2) {
                                                    path = (String)cmds.elementAt(1);
                                                }
                                                try {
                                                    File file = new File(path);
                                                    if (!file.exists()) {
                                                        out.println(path + ": No such file or directory");
                                                        continue block26;
                                                    }
                                                    if (file.isDirectory()) {
                                                        String[] list = file.list();
                                                        int ii3 = 0;
                                                        while (true) {
                                                            if (ii3 >= list.length) continue block26;
                                                            out.println(list[ii3]);
                                                            ++ii3;
                                                        }
                                                    }
                                                    out.println(path);
                                                }
                                                catch (Exception e) {
                                                    System.out.println(e);
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("get") || cmd.equals("get-resume") || cmd.equals("get-append") || cmd.equals("put") || cmd.equals("put-resume") || cmd.equals("put-append")) {
                                                if (cmds.size() != 2 && cmds.size() != 3) continue block26;
                                                p1 = (String)cmds.elementAt(1);
                                                String p2 = ".";
                                                if (cmds.size() == 3) {
                                                    p2 = (String)cmds.elementAt(2);
                                                }
                                                try {
                                                    int mode;
                                                    MyProgressMonitor monitor = new MyProgressMonitor();
                                                    if (cmd.startsWith("get")) {
                                                        mode = 0;
                                                        if (cmd.equals("get-resume")) {
                                                            mode = 1;
                                                        } else if (cmd.equals("get-append")) {
                                                            mode = 2;
                                                        }
                                                        c.get(p1, p2, (SftpProgressMonitor)monitor, mode);
                                                        continue block26;
                                                    }
                                                    mode = 0;
                                                    if (cmd.equals("put-resume")) {
                                                        mode = 1;
                                                    } else if (cmd.equals("put-append")) {
                                                        mode = 2;
                                                    }
                                                    c.put(p1, p2, (SftpProgressMonitor)monitor, mode);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("ln") || cmd.equals("symlink") || cmd.equals("rename") || cmd.equals("hardlink")) {
                                                if (cmds.size() != 3) continue block26;
                                                p1 = (String)cmds.elementAt(1);
                                                String p2 = (String)cmds.elementAt(2);
                                                try {
                                                    if (cmd.equals("hardlink")) {
                                                        c.hardlink(p1, p2);
                                                        continue block26;
                                                    }
                                                    if (cmd.equals("rename")) {
                                                        c.rename(p1, p2);
                                                        continue block26;
                                                    }
                                                    c.symlink(p1, p2);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("df")) {
                                                if (cmds.size() > 2) continue block26;
                                                p1 = cmds.size() == 1 ? "." : (String)cmds.elementAt(1);
                                                SftpStatVFS stat = c.statVFS(p1);
                                                long size = stat.getSize();
                                                long used = stat.getUsed();
                                                long avail = stat.getAvailForNonRoot();
                                                long root_avail = stat.getAvail();
                                                long capacity = stat.getCapacity();
                                                System.out.println("Size: " + size);
                                                System.out.println("Used: " + used);
                                                System.out.println("Avail: " + avail);
                                                System.out.println("(root): " + root_avail);
                                                System.out.println("%Capacity: " + capacity);
                                                continue block26;
                                            }
                                            if (cmd.equals("stat") || cmd.equals("lstat")) {
                                                if (cmds.size() != 2) continue block26;
                                                p1 = (String)cmds.elementAt(1);
                                                SftpATTRS attrs = null;
                                                try {
                                                    attrs = cmd.equals("stat") ? c.stat(p1) : c.lstat(p1);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                if (attrs == null) continue block26;
                                                out.println(attrs);
                                                continue block26;
                                            }
                                            if (cmd.equals("readlink")) {
                                                if (cmds.size() != 2) continue block26;
                                                p1 = (String)cmds.elementAt(1);
                                                String filename = null;
                                                try {
                                                    filename = c.readlink(p1);
                                                    out.println(filename);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("realpath")) {
                                                if (cmds.size() != 2) continue block26;
                                                p1 = (String)cmds.elementAt(1);
                                                String filename = null;
                                                try {
                                                    filename = c.realpath(p1);
                                                    out.println(filename);
                                                }
                                                catch (SftpException e) {
                                                    System.out.println(e.toString());
                                                }
                                                continue block26;
                                            }
                                            if (cmd.equals("version")) {
                                                out.println("SFTP protocol version " + c.version());
                                                continue block26;
                                            }
                                            if (cmd.equals("help") || cmd.equals("?")) {
                                                out.println(help);
                                                continue block26;
                                            }
                                            out.println("unimplemented command: " + cmd);
                                            continue block26;
                                        }
                                    }
                                    session.disconnect();
                                    break block81;
                                }
                                while (ii < i && buf[ii] == 32) {
                                    ++ii;
                                }
                                s = ii;
                            }
                            ++ii;
                        }
                        for (int j = 0; j < bar.length; foo |= k - 48, ++j) {
                            k = bar[j];
                            if (k < 48 || k > 55) {
                                foo = -1;
                                break;
                            }
                            foo <<= 3;
                        }
                        if (foo == -1) continue;
                    }
                    try {
                        if (cmd.equals("chgrp")) {
                            c.chgrp(foo, path);
                            continue;
                        }
                        if (cmd.equals("chown")) {
                            c.chown(foo, path);
                            continue;
                        }
                        if (!cmd.equals("chmod")) continue;
                        c.chmod(foo, path);
                    }
                    catch (SftpException e) {
                        System.out.println(e.toString());
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        System.exit(0);
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, destination + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                for (int i = 0; i < prompt.length; ++i) {
                    response[i] = texts[i].getText();
                }
                return response;
            }
            return null;
        }
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        ProgressMonitor _monitor;
        long _count = 0L;
        long _max = 0L;
        private long percent = -1L;

        public void init(int op, String src, String dest, long max) {
            this._max = max;
            this._monitor = new ProgressMonitor(null, (op == 0 ? "put" : "get") + ": " + src, "", 0, (int)max);
            this._count = 0L;
            this.percent = -1L;
            this._monitor.setProgress((int)this._count);
            this._monitor.setMillisToDecideToPopup(1000);
        }

        public boolean count(long count) {
            this._count += count;
            if (this.percent >= this._count * 100L / this._max) {
                return true;
            }
            this.percent = this._count * 100L / this._max;
            this._monitor.setNote("Completed " + this._count + "(" + this.percent + "%) out of " + this._max + ".");
            this._monitor.setProgress((int)this._count);
            return !this._monitor.isCanceled();
        }

        public void end() {
            this._monitor.close();
        }
    }
}

