/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.io;

import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.logging.CRCLogManager;
import com.dassault.cecilia.crc.common.logging.CRCLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class IOFilesExchange {
    protected static final String DATA_FILENAME = "eq.dag";
    private static final CRCLogger logger = CRCLogManager.getLogger(IOFilesExchange.class);

    protected IOFilesExchange() {
    }

    public abstract void upload(long var1, File var3) throws CRCException;

    public abstract void download(long var1, Path var3, boolean var4) throws CRCException;

    public abstract void download(long var1, File var3, boolean var4) throws CRCException;

    protected void dezipFile(InputStream inputStream, File resultFile) throws CRCException {
        File destDir = resultFile.getParentFile();
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        try {
            int len;
            zipEntry = zis.getNextEntry();
            logger.log(Level.INFO, "dezip to " + zipEntry.getName() + "...");
            File newFile = this.newFile(destDir, zipEntry.getName());
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Erreur lors du dezippage : " + resultFile, e);
            throw new CRCException("Error during unzip file - " + e.getMessage(), e);
        }
    }

    protected File newFile(File destinationDir, String name) throws IOException {
        File destFile = new File(destinationDir, name);
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + name);
        }
        return destFile;
    }
}

