/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.pojo;

import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.logging.CRCLogManager;
import com.dassault.cecilia.crc.common.logging.CRCLogger;
import com.dassault.cecilia.crc.common.pojo.SftpInfosResponse;
import com.dassault.cecilia.crc.common.util.EncryptUtil;
import java.util.Objects;
import java.util.logging.Level;

public class SftpProperties {
    private Boolean enabled;
    private String host;
    private Integer port;
    private String login;
    private String password;
    private String baseDirectory;
    private String computationDirectory = ".";
    private Integer clientKeepAliveInterval;
    private static final CRCLogger logger = CRCLogManager.getLogger(SftpProperties.class);
    Boolean _withSftp = null;

    public SftpProperties() {
    }

    public SftpProperties(SftpInfosResponse infos) {
        this.host = infos.getSftpHost();
        this.port = infos.getSftpPort();
        this.computationDirectory = infos.getComputationDirectory();
        if (infos.getCredentials() != null) {
            try {
                String[] credentials = EncryptUtil.decryptCredentials(infos.getCredentials());
                if (credentials.length >= 2) {
                    this.login = credentials[0];
                    this.password = credentials[1];
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error decrypting credentials", e);
            }
        }
        this.clientKeepAliveInterval = infos.getClientKeepAliveInterval();
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.baseDirectory, this.computationDirectory, this.host, this.login, this.password, this.port, this.clientKeepAliveInterval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SftpProperties other = (SftpProperties)obj;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.baseDirectory, other.baseDirectory) && Objects.equals(this.computationDirectory, other.computationDirectory) && Objects.equals(this.host, other.host) && Objects.equals(this.login, other.login) && Objects.equals(this.password, other.password) && Objects.equals(this.port, other.port) && Objects.equals(this.clientKeepAliveInterval, other.clientKeepAliveInterval);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public String getComputationDirectory() {
        return this.computationDirectory;
    }

    public void setComputationDirectory(String computationDirectory) {
        this.computationDirectory = computationDirectory;
    }

    public Integer getClientKeepAliveInterval() {
        return this.clientKeepAliveInterval;
    }

    public void setClientKeepAliveInterval(Integer clientKeepAliveInterval) {
        this.clientKeepAliveInterval = clientKeepAliveInterval;
    }

    public String toString() {
        return "SftpProps{enabled='" + this.enabled + "', host='" + this.host + "', port=" + this.port + ", login='" + this.login + "', password='" + this.password + "', baseDirectory='" + this.baseDirectory + "', computationDirectory='" + this.computationDirectory + "'}";
    }

    public synchronized boolean withSftp() {
        if (this._withSftp == null) {
            this._withSftp = false;
            if (this.getEnabled() != null && this.getEnabled().booleanValue() && this.getHost() != null && !this.getHost().isEmpty() && this.getBaseDirectory() != null && !this.getBaseDirectory().isEmpty()) {
                this._withSftp = true;
            }
            logger.log(Level.INFO, "SftpConfigurations withSftp() => " + this._withSftp);
        }
        return this._withSftp;
    }

    public SftpInfosResponse getCredentials() throws CRCException {
        SftpInfosResponse response = new SftpInfosResponse();
        if (this.withSftp()) {
            response.setSftpHost(this.getHost());
            if (this.getPort() != null) {
                response.setSftpPort(this.getPort());
            }
            response.setComputationDirectory(this.getComputationDirectory());
            if (this.getLogin() != null && !this.getLogin().isBlank()) {
                try {
                    String credentials = EncryptUtil.encryptText("login=%spassword=%s".formatted(this.getLogin(), this.getPassword()));
                    response.setCredentials(credentials);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Create credential - Error Encrypting data", e);
                }
            }
            if (this.getClientKeepAliveInterval() != null) {
                response.setClientKeepAliveInterval(this.getClientKeepAliveInterval());
            }
        }
        return response;
    }
}

