/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.template;

import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.logging.CRCLogManager;
import com.dassault.cecilia.crc.common.logging.CRCLogger;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class RestTemplateConfig {
    private static final CRCLogger logger = CRCLogManager.getLogger(RestTemplateConfig.class);
    int timeOut = 20000;
    boolean enableSSL = false;
    String exclusifCertificatePath = null;
    String exclusifCertificatePasswd = null;

    public boolean isHttps() {
        return this.enableSSL;
    }

    public RestTemplateConfig setHttps(boolean https) {
        this.enableSSL = https;
        return this;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public RestTemplateConfig setTimeOut(int timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public String getExclusifCertificatePath() {
        return this.exclusifCertificatePath;
    }

    public RestTemplateConfig setExclusifCertificatePath(String exclusifCertificatePath) {
        this.exclusifCertificatePath = exclusifCertificatePath;
        return this;
    }

    public String getExclusifCertificatePasswd() {
        return this.exclusifCertificatePasswd;
    }

    public RestTemplateConfig setExclusifCertificatePasswd(String exclusifCertificatePasswd) {
        this.exclusifCertificatePasswd = exclusifCertificatePasswd;
        return this;
    }

    public RestTemplate create() throws CRCException {
        if (this.enableSSL) {
            try {
                SSLContext sslContext = null;
                if (this.exclusifCertificatePath != null && !this.exclusifCertificatePath.trim().isEmpty()) {
                    SSLContextBuilder sslBuilder = new SSLContextBuilder();
                    File keyStore = new File(this.exclusifCertificatePath);
                    logger.log(Level.INFO, "keyStore: " + keyStore.getAbsolutePath());
                    if (this.exclusifCertificatePasswd != null && !this.exclusifCertificatePasswd.isEmpty()) {
                        sslBuilder.loadTrustMaterial(keyStore, this.exclusifCertificatePasswd.toCharArray());
                    } else {
                        sslBuilder.loadTrustMaterial(keyStore);
                    }
                    sslContext = sslBuilder.build();
                } else {
                    sslContext = SSLContext.getDefault();
                }
                SSLConnectionSocketFactory sslConFactory = new SSLConnectionSocketFactory(sslContext);
                PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConFactory).build();
                CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
                requestFactory.setConnectTimeout(this.timeOut);
                return new RestTemplate((ClientHttpRequestFactory)requestFactory);
            }
            catch (KeyManagementException e) {
                logger.log(Level.SEVERE, "Create RestTemplate exception - KeyManagementException: " + e.getMessage());
                logger.log(Level.FINE, e);
                throw new CRCException(e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.SEVERE, "Create RestTemplate exception - NoSuchAlgorithmException: " + e.getMessage());
                logger.log(Level.FINE, e);
                throw new CRCException(e);
            }
            catch (KeyStoreException e) {
                logger.log(Level.SEVERE, "Create RestTemplate exception - KeyStoreException: " + e.getMessage());
                logger.log(Level.FINE, e);
                throw new CRCException(e);
            }
            catch (CertificateException e) {
                logger.log(Level.SEVERE, "Create RestTemplate exception - CertificateException: " + e.getMessage());
                logger.log(Level.FINE, e);
                throw new CRCException(e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Create RestTemplate exception - IOException: " + e.getMessage());
                logger.log(Level.FINE, e);
                throw new CRCException(e);
            }
        }
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(this.timeOut);
        clientHttpRequestFactory.setReadTimeout(this.timeOut);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }
}

