/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.crc.common.template;

import com.dassault.cecilia.crc.common.CRCClientException;
import com.dassault.cecilia.crc.common.CRCException;
import com.dassault.cecilia.crc.common.logging.CRCLogManager;
import com.dassault.cecilia.crc.common.logging.CRCLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static final CRCLogger logger = CRCLogManager.getLogger(RestTemplateUtil.class);
    private static long _currentRequestID = 0L;

    public static <T> ResponseEntity<T> postForEntity(RestTemplate restTemplate, String uriString, Object request, Class<T> responseType) throws CRCException {
        try {
            URI uri = new URI(uriString);
            return RestTemplateUtil.postForEntity(restTemplate, uri, request, responseType);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "URISyntaxException (post): " + uriString + " => " + e.getMessage());
            logger.log(Level.FINE, e);
            throw new CRCException(e);
        }
    }

    public static <T> ResponseEntity<T> postForEntity(RestTemplate restTemplate, URI uri, Object request, Class<T> responseType) throws CRCException {
        long reqID = _currentRequestID++;
        try {
            logger.log(Level.FINE, "[" + reqID + "] Calling URI (post): " + uri);
            ResponseEntity response = restTemplate.postForEntity(uri, request, responseType);
            logger.log(Level.FINER, "[" + reqID + "] StatusCode: " + response.getStatusCode().value());
            return response;
        }
        catch (RestClientResponseException e) {
            logger.log(Level.WARNING, "[" + reqID + "] " + ((Object)((Object)e)).getClass().getSimpleName() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.INFO, "[" + reqID + "] StatusCode: " + e.getStatusCode().value());
            logger.log(Level.FINER, e);
            throw new CRCClientException((RestClientException)((Object)e));
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, "[" + reqID + "] " + ((Object)((Object)e)).getClass().getSimpleName() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.FINER, e);
            throw new CRCClientException(e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[" + reqID + "] " + e.getClass().getSimpleName() + " (" + e.getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.FINE, e);
            throw new CRCException(e);
        }
    }

    public static <T> T postForObject(RestTemplate restTemplate, String uriString, Object request, Class<T> responseType) throws CRCException {
        try {
            URI uri = new URI(uriString);
            return RestTemplateUtil.postForObject(restTemplate, uri, request, responseType);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "URISyntaxException (postObj): " + uriString + " => " + e.getMessage());
            logger.log(Level.FINE, e);
            throw new CRCException(e);
        }
    }

    public static <T> T postForObject(RestTemplate restTemplate, URI uri, Object request, Class<T> responseType) throws CRCException {
        long reqID = _currentRequestID++;
        try {
            logger.log(Level.FINE, "[" + reqID + "] Calling URI (postObj): " + uri);
            Object response = restTemplate.postForObject(uri, request, responseType);
            logger.log(Level.FINER, "[" + reqID + "] postForObject Ok");
            return (T)response;
        }
        catch (RestClientResponseException e) {
            logger.log(Level.WARNING, "[" + reqID + "] " + ((Object)((Object)e)).getClass().getSimpleName() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.INFO, "[" + reqID + "] StatusCode: " + e.getStatusCode().value());
            logger.log(Level.FINER, e);
            throw new CRCClientException((RestClientException)((Object)e));
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, "[" + reqID + "] " + ((Object)((Object)e)).getClass().getSimpleName() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.FINER, e);
            throw new CRCClientException(e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[" + reqID + "] " + e.getClass().getSimpleName() + " (" + e.getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.FINE, e);
            throw new CRCException(e);
        }
    }

    public static <T> T getForEntity(RestTemplate restTemplate, String uriString, Class<T> responseType) throws CRCException {
        try {
            URI uri = new URI(uriString);
            T result = RestTemplateUtil.getForEntity(restTemplate, uri, responseType);
            if (result == null) {
                throw new CRCException("RestTemplateUtil.getForEntity(..., " + uriString + ", " + responseType.getName() + ") return null");
            }
            return result;
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "URISyntaxException (get): " + uriString + " => " + e.getMessage());
            logger.log(Level.FINE, e);
            throw new CRCException(e);
        }
    }

    protected static <T> T getForEntity(RestTemplate restTemplate, URI uri, Class<T> responseType) throws CRCException {
        long reqID = _currentRequestID++;
        try {
            logger.log(Level.FINE, "[" + reqID + "] Calling URI (get): " + uri);
            ResponseEntity response = restTemplate.getForEntity(uri, responseType);
            logger.log(Level.FINER, "[" + reqID + "] StatusCode: " + response.getStatusCode().value());
            return (T)response.getBody();
        }
        catch (RestClientResponseException e) {
            logger.log(Level.WARNING, "[" + reqID + "] " + ((Object)((Object)e)).getClass().getSimpleName() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.INFO, "[" + reqID + "] StatusCode: " + e.getStatusCode().value());
            logger.log(Level.FINER, e);
            throw new CRCClientException((RestClientException)((Object)e));
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, "[" + reqID + "] " + ((Object)((Object)e)).getClass().getSimpleName() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.FINER, e);
            throw new CRCClientException(e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[" + reqID + "] " + e.getClass().getSimpleName() + " (" + e.getClass().getSimpleName() + "): " + e.getMessage());
            logger.log(Level.FINE, e);
            throw new CRCException(e);
        }
    }
}

