/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban;

import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessListener;
import java.io.File;
import java.util.Collection;

public final class BanEntry {
    BanEntry _previous;
    BanProcess _process = new BanProcess(this);

    public BanEntry() throws BanLicenseException {
        this._process.init(null);
        this._process.setUserProperty("ban.version", BanProcess.getBanVersion());
    }

    public BanEntry(BanEntry previous) throws BanLicenseException {
        this._process.init(previous);
        this._previous = previous;
    }

    public void addProcessListener(BanProcessListener listener) {
        this._process.addProcessListener(listener);
    }

    public void removeProcessListener(BanProcessListener listener) {
        this._process.removeProcessListener(listener);
    }

    public void requestResume() {
        this._process.requestResume();
    }

    public void requestStop() {
        this._process.requestStop();
    }

    public void requestSuspend() {
        this._process.requestSuspend();
    }

    public String getInfo(String key) {
        return this._process.getInfo(key);
    }

    public void addUnit(Class unit) {
        this._process.addUnit(unit);
    }

    public void setIdObject(String id, Object obj) {
        this._process.setIdObject(id, obj);
    }

    public void setUserProperty(String name, String value) {
        this._process.setUserProperty(name, value);
    }

    public Object getIdObject(String id) {
        return this._process.getIdObject(id);
    }

    public Collection<String> listIdObject() {
        return this._process._idObjects.keySet();
    }

    public Object getValueOfVariable(String name) {
        return this._process.getValueOfVariable(name);
    }

    public void execute(File processFile) {
        if (this._previous != null) {
            this.collectObject(this._previous);
            this._previous = null;
        }
        this._process.setUserProperty("ban.file", processFile.getAbsolutePath());
        this._process.setUserProperty("ban.file.path", processFile.getAbsoluteFile().getParent());
        this._process.configureProcess(processFile);
        this._process.execute();
    }

    public void execute(BanInputStream input) {
        if (this._previous != null) {
            this.collectObject(this._previous);
            this._previous = null;
        }
        this._process.setUserProperty("ban.location", input.getLocation());
        this._process.configureProcess(input);
        this._process.execute();
    }

    private void collectObject(BanEntry previous) {
        for (String key : previous.listIdObject()) {
            if (this.getIdObject(key) != null) continue;
            this._process.setIdObject(key, previous.getIdObject(key));
        }
    }

    public void dispose() {
        this._process.dispose();
    }
}

