/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanFinnish;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanLicenseManager;
import com.dassault.cecilia.lib.ban.BanProcessEvent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.BanProcessListener;
import com.dassault.cecilia.lib.ban.BanStoppedException;
import com.dassault.cecilia.lib.ban.Block;
import com.dassault.cecilia.lib.ban.BlockRoot;
import com.dassault.cecilia.lib.ban.ReturnException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.loader.UnitLoaderHelper;
import com.dassault.cecilia.lib.ban.loader.UnitRepositoring;
import com.dassault.cecilia.lib.ban.parser.XmlParseHelper;
import com.dassault.cecilia.lib.ban.type.Handle;
import com.dassault.cecilia.lib.ban.type.Var;
import com.dassault.cecilia.lib.util.ControllableAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

public final class BanProcess
implements ControllableAction {
    public static final String PROP_BAN_LOG_FILE = "cecilia.ban.logging.file";
    public static final String PROP_BAN_BASEDIR = "cecilia.ban.basedir";
    public static final String PROP_BAN_PATH_EXE = "cecilia.ban.path";
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final Object _logMutex = new Object();
    private static ThreadLocal _logInit = new ThreadLocal();
    private static Logger __logger = null;
    private UnitLoaderHelper _unitLoaderHelper;
    protected Map<String, Object> _idObjects;
    private Map<String, String> _userProperties;
    private File _baseDir;
    private Object _lockerUnit = new Object();
    private Unit _currentUnit;
    protected Block _root;
    private LinkedList<Block> _callStack;
    protected BanFinnish _finnisher;
    BanEntry _ownerEntry;
    List<BanProcessListener> _listeners = new ArrayList<BanProcessListener>();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Object _locker = new Object();
    private boolean _requestSuspend = false;
    private boolean _requestStop = false;
    String _progressMsg = "";
    private static final Object _verMutex = new Object();
    private static ThreadLocal _verInit = new ThreadLocal();
    private static String __banVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultLog(String msg, int msgLevel) {
        if (_logInit.get() == null) {
            Object object = _logMutex;
            synchronized (object) {
                if (__logger == null) {
                    File logFile;
                    String logPath = System.getProperty(PROP_BAN_LOG_FILE);
                    if (logPath == null || logPath.length() == 0) {
                        logPath = "log4ban.properties";
                    }
                    if ((logFile = new File(logPath)).canRead()) {
                        try {
                            FileInputStream fis = new FileInputStream(logFile);
                            LogManager.getLogManager().readConfiguration(fis);
                        }
                        catch (IOException e) {
                            System.err.println("During logging configuration : " + e.getMessage());
                        }
                    }
                    __logger = Logger.getLogger(BanProcess.class.getPackage().getName());
                }
                _logInit.set(Boolean.TRUE);
            }
        }
        String className = this.getClass().getName();
        String methodName = "log";
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 3; i < stack.length; ++i) {
                if (stack[i].getMethodName().equalsIgnoreCase("log")) continue;
                className = stack[i].getClassName();
                methodName = stack[i].getMethodName();
                break;
            }
        }
        catch (SecurityException stack) {
            // empty catch block
        }
        Level lvl = this.convertLogLevel(msgLevel);
        __logger.logp(lvl, className, methodName, msg);
    }

    private Level convertLogLevel(int banLevel) {
        switch (banLevel) {
            case 0: {
                return Level.SEVERE;
            }
            case 1: {
                return Level.WARNING;
            }
            default: {
                return Level.INFO;
            }
            case 3: {
                return Level.FINE;
            }
            case 4: 
        }
        return Level.FINER;
    }

    public void log(String msg, int level) {
        this.defaultLog(msg, level);
        this.fireMessageLogged(this, msg, level);
    }

    public void log(Unit unit, String msg, int level) {
        this.defaultLog(msg, level);
        this.fireMessageLogged(unit, msg, level);
    }

    public ClassLoader getClassLoader() {
        return this._unitLoaderHelper.getClassLoader();
    }

    public UnitRepositoring getUnitDefs() {
        return this._unitLoaderHelper.getUnitDefs();
    }

    public void addUnit(Class unit) {
        this.getUnitDefs().add(unit);
    }

    public Object getIdObject(String id) {
        Object result = this._idObjects.get(id);
        if (result == null) {
            this.log("Id   | getIdObject(" + id + ") return null", 4);
        }
        return result;
    }

    public void setIdObject(String id, Object obj, int level) {
        Object result = this._idObjects.get(id);
        if (result != null) {
            String msg = "Id   | setIdObject(...) : Id already assign : " + id;
            this.log(msg, level);
        }
        this._idObjects.put(id, obj);
    }

    public void setIdObject(String id, Object obj) {
        this.setIdObject(id, obj, 3);
    }

    public void setUserProperty(String name, String value) {
        String oval = System.getProperty(name);
        if (oval != null) {
            this.log("Prop | System property [" + name + "=" + oval + "] mask user property", 0);
            return;
        }
        if (this._userProperties.containsKey(name)) {
            oval = this._userProperties.get(name);
            if (oval.equals(value)) {
                return;
            }
            this.log("Prop | User property [" + name + "] change : " + oval + " => " + value, 2);
        }
        this._userProperties.put(name, value);
    }

    public void setSysProperty(String name, String value) {
        System.setProperty(name, value);
    }

    public String getProperty(String name, int levelLog) {
        String result = System.getProperty(name);
        if (result == null) {
            result = this._userProperties.get(name);
        }
        if (result == null) {
            this.log("Prop | User property [" + name + "] unknow", levelLog);
        }
        return result;
    }

    public String getProperty(String name) {
        return this.getProperty(name, 2);
    }

    public void setBaseDir(File baseDir) throws BanProcessException {
        if (!baseDir.exists()) {
            throw new BanProcessException("Basedir " + baseDir.getAbsolutePath() + " does not exist");
        }
        if (!baseDir.isDirectory()) {
            throw new BanProcessException("Basedir " + baseDir.getAbsolutePath() + " is not a directory");
        }
        this._baseDir = baseDir;
        this.setSysProperty(PROP_BAN_BASEDIR, this._baseDir.getPath());
        this.log("Proj | basedir set to: " + this._baseDir, 3);
    }

    void dispose() {
        this._idObjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute() {
        this.fireProcessStarted();
        Throwable reason = null;
        try {
            Object object = this._lockerUnit;
            synchronized (object) {
                this._currentUnit = this._root;
            }
            this._root.execute();
            object = this._lockerUnit;
            synchronized (object) {
                this._currentUnit = null;
            }
        }
        catch (ReturnException e) {
            reason = e;
            this.log("Call return in current process", 1);
        }
        catch (BanStoppedException e) {
            reason = e;
            this.log("Stop current process", 2);
            throw e;
        }
        catch (Error e) {
            reason = e;
            throw e;
        }
        finally {
            this.fireProcessFinished(reason);
        }
    }

    public Block getRootUnit() {
        return this._root;
    }

    Object getValueOfVariable(String name) {
        Var var = this._root.getVariable(name);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    public Block getCurrentBlock() {
        return this._callStack.getFirst();
    }

    public void push(Block block) {
        this._callStack.addFirst(block);
    }

    public Block pop() {
        return this._callStack.removeFirst();
    }

    protected Iterator<Block> iteratorBlock() {
        return new IteratorNotRemove<Block>(this._callStack, false);
    }

    BanProcess(BanEntry owner) {
        this._ownerEntry = owner;
        this._idObjects = new HashMap<String, Object>();
        this._callStack = new LinkedList();
        this._userProperties = new TreeMap<String, String>();
    }

    protected final void init(BanEntry previous) throws BanLicenseException {
        BanLicenseManager license = BanLicenseManager.getManager();
        long tok = -1L;
        if (previous == null) {
            tok = license.popToken();
        }
        this._finnisher = new BanFinnish(this);
        this.defaultLog("Ban version : " + BanProcess.getBanVersion(), 4);
        this._unitLoaderHelper = new UnitLoaderHelper(this);
        if (previous == null) {
            tok = license.verifyLicense(tok, this);
        }
        this.setIdObject("ban.OUTPUT", Handle.OUTPUT);
        if (previous == null) {
            license.pushToken(tok);
        }
        this.setIdObject("ban.ERROR", Handle.ERROR);
    }

    protected final void configureProcess(File processFile) {
        XmlParseHelper helper = new XmlParseHelper();
        this._root = new BlockRoot();
        this._root.setProcess(this);
        helper.parse(this, processFile);
        this._root.setLocationFile(processFile.getPath());
    }

    protected final void configureProcess(BanInputStream input) {
        XmlParseHelper helper = new XmlParseHelper();
        this._root = new BlockRoot();
        this._root.setProcess(this);
        InputSource source = new InputSource(input);
        helper.parse(this, source);
        this._root.setLocationFile(input.getLocation());
    }

    public synchronized void addProcessListener(BanProcessListener listener) {
        List<BanProcessListener> listeners = this.getProcessListeners();
        listeners.add(listener);
        this._listeners = listeners;
    }

    public synchronized void removeProcessListener(BanProcessListener listener) {
        List<BanProcessListener> listeners = this.getProcessListeners();
        listeners.remove(listener);
        this._listeners = listeners;
    }

    public List<BanProcessListener> getProcessListeners() {
        return new ArrayList<BanProcessListener>(this._listeners);
    }

    public void fireProcessStarted() {
        BanProcessEvent event = new BanProcessEvent(this);
        for (BanProcessListener listener : this._listeners) {
            listener.processStarted(event);
        }
    }

    public void fireProcessFinished(Throwable exception) {
        BanProcessEvent event = new BanProcessEvent(this);
        event.setException(exception);
        for (BanProcessListener listener : this._listeners) {
            listener.processFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUnitStarted(Unit unit) {
        Object object = this._lockerUnit;
        synchronized (object) {
            this._currentUnit = unit;
        }
        BanProcessEvent event = new BanProcessEvent(unit);
        for (BanProcessListener listener : this._listeners) {
            listener.unitStarted(event);
        }
    }

    protected void fireUnitProgressed(Unit unit, float progress) {
        BanProcessEvent event = new BanProcessEvent(unit);
        event.setProgress(progress);
        for (BanProcessListener listener : this._listeners) {
            listener.unitProgressed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUnitFinished(Unit unit, Throwable exception) {
        Object object = this._lockerUnit;
        synchronized (object) {
            this._currentUnit = null;
        }
        System.out.flush();
        System.err.flush();
        BanProcessEvent event = new BanProcessEvent(unit);
        event.setException(exception);
        for (BanProcessListener listener : this._listeners) {
            listener.unitFinished(event);
        }
    }

    private void fireMessageLoggedEvent(BanProcessEvent evt, String msg, int lvl) {
        if (msg.endsWith(LINE_SEP)) {
            int endIndex = msg.length() - LINE_SEP.length();
            evt.setMessage(msg.substring(0, endIndex), lvl);
        } else {
            evt.setMessage(msg, lvl);
        }
        for (BanProcessListener listener : this._listeners) {
            listener.messageLogged(evt);
        }
    }

    protected void fireMessageLogged(BanProcess process, String msg, int level) {
        BanProcessEvent event = new BanProcessEvent(process);
        this.fireMessageLoggedEvent(event, msg, level);
    }

    protected void fireMessageLogged(Unit unit, String msg, int level) {
        BanProcessEvent event = new BanProcessEvent(unit);
        this.fireMessageLoggedEvent(event, msg, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSuspend() {
        Object object = this._lockerUnit;
        synchronized (object) {
            if (this._currentUnit != null && this._currentUnit instanceof ControllableAction) {
                ((ControllableAction)((Object)this._currentUnit)).requestSuspend();
            }
        }
        this._requestSuspend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSuspended() throws InterruptedException {
        Object object = this._locker;
        synchronized (object) {
            while (this._requestSuspend) {
                this._locker.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestResume() {
        this._requestSuspend = false;
        Object object = this._lockerUnit;
        synchronized (object) {
            if (this._currentUnit != null && this._currentUnit instanceof ControllableAction) {
                ((ControllableAction)((Object)this._currentUnit)).requestResume();
            }
        }
        object = this._locker;
        synchronized (object) {
            this._locker.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this._requestStop = true;
        if (this._requestSuspend) {
            this.requestResume();
        }
        Object object = this._lockerUnit;
        synchronized (object) {
            if (this._currentUnit != null && this._currentUnit instanceof ControllableAction) {
                ((ControllableAction)((Object)this._currentUnit)).requestStop();
            }
        }
    }

    protected boolean checkStopped() {
        return this._requestStop;
    }

    public void setProgress(String value) {
        this._progressMsg = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        String result = null;
        if (key == null) {
            return Long.toString(new Date().getTime());
        }
        Object object = this._lockerUnit;
        synchronized (object) {
            if (this._currentUnit != null && this._currentUnit instanceof ControllableAction) {
                result = ((ControllableAction)((Object)this._currentUnit)).getInfo(key);
            }
        }
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            if (result == null) {
                return this._progressMsg;
            }
            return this._progressMsg + " : " + result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBanVersion() throws BanProcessException {
        if (_verInit.get() == null) {
            Object object = _verMutex;
            synchronized (object) {
                if (__banVersion == null) {
                    try {
                        Properties props = new Properties();
                        String path = BanProcess.class.getPackage().getName();
                        InputStream in = BanProcess.class.getResourceAsStream("/" + path.replace(".", "/") + "/properties.txt");
                        props.load(in);
                        in.close();
                        StringBuffer msg = new StringBuffer();
                        msg.append("Ban version ");
                        msg.append(props.getProperty("ban.version"));
                        __banVersion = msg.toString();
                    }
                    catch (IOException ioe) {
                        throw new BanProcessException("Could not load the version information:" + ioe.getMessage());
                    }
                    catch (NullPointerException npe) {
                        throw new BanProcessException("Could not load the version information.");
                    }
                }
                _verInit.set(Boolean.TRUE);
            }
        }
        return __banVersion;
    }

    class IteratorNotRemove<E>
    implements Iterator<E> {
        ListIterator<E> _delegate;
        boolean _inverse;

        public IteratorNotRemove(AbstractList<E> list, boolean inverse) {
            this._inverse = inverse;
            this._delegate = this._inverse ? list.listIterator(list.size()) : list.listIterator(0);
        }

        @Override
        public boolean hasNext() {
            if (this._inverse) {
                return this._delegate.hasPrevious();
            }
            return this._delegate.hasNext();
        }

        @Override
        public E next() {
            if (this._inverse) {
                return this._delegate.previous();
            }
            return this._delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

