/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.examples;

import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class BanUseExample {
    protected static boolean _pauseAtExit = false;

    protected static int readArgs(BanEntry ban, String[] args) {
        int idFile = 1;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-pause")) {
                _pauseAtExit = true;
                continue;
            }
            if (arg.startsWith("-lang=")) {
                String lang = arg.substring("-lang=".length());
                System.setProperty("user.language", lang);
                continue;
            }
            if (arg.startsWith("-launch=")) {
                String path = arg.substring("-launch=".length());
                File input = new File(path);
                if (!(input.exists() && input.isFile() && input.canRead())) {
                    System.err.println("BanUseExample : launch file error [" + path + "]");
                    return 2;
                }
                try {
                    Properties props = new Properties();
                    FileInputStream fis = new FileInputStream(input);
                    props.load(fis);
                    fis.close();
                    Enumeration<?> values = props.propertyNames();
                    while (values.hasMoreElements()) {
                        String key = (String)values.nextElement();
                        String value = props.getProperty(key).trim();
                        ban.setUserProperty(key, value);
                    }
                    continue;
                }
                catch (IOException e) {
                    System.err.println("BanUseExample : launch file error [" + path + "]\n" + e.getMessage());
                    return 2;
                }
            }
            if (arg.startsWith("-D")) {
                String data = arg.substring(2);
                int pos = data.indexOf(61);
                if (pos == -1) {
                    ban.setUserProperty(data, "true");
                    continue;
                }
                String key = data.substring(0, pos);
                String val = data.substring(pos + 1);
                int len = val.length();
                if (len >= 2 && val.charAt(0) == '\"' && val.charAt(len - 1) == '\"') {
                    val = val.substring(1, len - 1);
                }
                ban.setUserProperty(key, val);
                continue;
            }
            File input = new File(arg);
            if (!(!input.exists() || input.isFile() && input.canRead())) {
                System.err.println("BanUseExample : input file error [" + arg + "]");
                return 2;
            }
            ban.setIdObject("Input." + idFile, input);
            ban.setUserProperty("example.input." + idFile, input.getAbsolutePath());
            ban.setUserProperty("data.input." + idFile, arg);
            ++idFile;
        }
        return 0;
    }

    private static int Main(String[] args) {
        if (args.length < 1) {
            System.err.println("BanUseExample : syntax launch error");
            return 2;
        }
        File script = new File(args[0]);
        if (!(script.exists() && script.isFile() && script.canRead())) {
            System.err.println("BanUseExample : script file error");
            return 2;
        }
        BanEntry ban = null;
        try {
            ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            System.err.println("BanUseExample : License exception\n[" + e.getMessage() + "]");
            return 5;
        }
        int result = BanUseExample.readArgs(ban, args);
        if (result != 0) {
            return result;
        }
        try {
            ban.execute(script);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("BanUseExample : No Error");
        }
        catch (BanProcessException e) {
            System.err.println("BanUseExample : process exception\n[" + e.getMessage() + "]");
            return 1;
        }
        catch (Exception e) {
            System.err.println("BanUseExample : unknow exception\n[" + e.getMessage() + "]");
            return 3;
        }
        catch (Error e) {
            System.err.println("BanUseExample : unknow error\n[" + e.getMessage() + "]");
            return 3;
        }
        System.out.println("\nObjects");
        Iterator<String> iter = ban.listIdObject().iterator();
        while (iter.hasNext()) {
            System.out.println("\t=> " + iter.next());
        }
        if (_pauseAtExit) {
            System.out.println("Waiting 1800 sec. for display possible LUM trace");
            try {
                Thread.sleep(1800000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        int result = BanUseExample.Main(args);
        System.gc();
        System.exit(result);
    }
}

