/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.launcher;

import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecorder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DestinationOutputStream
extends ByteArrayOutputStream {
    private LogExecRecorder _recorder;
    private boolean _output;

    public DestinationOutputStream(LogExecRecorder recorder, boolean output) {
        this._recorder = recorder;
        this._output = output;
    }

    protected void publish(String line, boolean forceError) {
        LogExecRecord.LogType type = LogExecRecord.LogType.OUT;
        if (forceError || !this._output) {
            type = LogExecRecord.LogType.ERR;
        }
        this._recorder.addRecord(new LogExecRecord(type, line));
    }

    protected void verifyBuffer() {
        for (int i = this.count - 1; i >= 0; --i) {
            if (this.buf[i] != 10 && this.buf[i] != 13) continue;
            this.publish(new String(this.buf, 0, i + 1), false);
            byte[] newbuf = new byte[this.buf.length];
            System.arraycopy(this.buf, i, newbuf, 0, this.count - i);
            this.buf = newbuf;
            this.count -= i;
            return;
        }
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
        this.verifyBuffer();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.verifyBuffer();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.count > 0) {
            this._recorder.addRecord(new LogExecRecord(this._output ? LogExecRecord.LogType.OUT : LogExecRecord.LogType.ERR, new String(this.buf, 0, this.count)));
        }
        this.count = 0;
        super.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.count > 0) {
            this._recorder.addRecord(new LogExecRecord(this._output ? LogExecRecord.LogType.OUT : LogExecRecord.LogType.ERR, new String(this.buf, 0, this.count)));
        }
        this.count = 0;
        super.close();
    }
}

