/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.loader;

import com.dassault.cecilia.lib.ban.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

public class UnitLoader
extends URLClassLoader {
    List<URL> _urls = new ArrayList<URL>();
    List<String> _jars = new ArrayList<String>();
    String _defPath = System.getProperty("cecilia.ban.basedir");

    public UnitLoader(URL[] urls, String[] jarPath, ClassLoader parent) {
        super(urls, parent);
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            this._urls.add(urls[i]);
            this._jars.add(FileUtility.getDiffPath(this._defPath, jarPath[i]));
        }
    }

    protected void addJar(URL url, String jarPath) {
        String path = FileUtility.getDiffPath(this._defPath, jarPath);
        if (!this._jars.contains(path)) {
            this._jars.add(path);
            this._urls.add(url);
            this.addURL(url);
        }
    }

    protected boolean contains(String path) {
        path = FileUtility.getDiffPath(this._defPath, path);
        for (int i = 0; i < this._jars.size(); ++i) {
            if (!this._jars.get(i).equalsIgnoreCase(path)) continue;
            return true;
        }
        return false;
    }

    protected String findPath(String className) {
        String classPath = className.replace('.', '/') + ".class";
        for (int i = 0; i < this._urls.size(); ++i) {
            try {
                ZipFile zipFile;
                File jarFile = new File(this._jars.get(i));
                if (!jarFile.isAbsolute()) {
                    jarFile = new File(this._defPath + File.separator + this._jars.get(i));
                }
                if ((zipFile = new ZipFile(jarFile)).getEntry(classPath) == null) continue;
                return this._jars.get(i);
            }
            catch (IOException e) {
                System.err.println("IOException [" + this._jars.get(i) + "] file \n  at " + this.getClass().getName() + ":60");
            }
        }
        return "[classpath]" + File.separatorChar + "[default]";
    }

    protected void removeJar(String jarPath) {
        String path = FileUtility.getDiffPath(this._defPath, jarPath);
        int idx = this._jars.indexOf(path);
        if (idx >= 0) {
            this._jars.remove(idx);
            this._urls.remove(idx);
        }
    }
}

