/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.loader;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.loader.UnitLoader;
import com.dassault.cecilia.lib.ban.loader.UnitRepositoring;
import com.dassault.cecilia.lib.ban.parser.XmlHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnitLoaderHelper {
    BanProcess _process;
    UnitLoader _loaderUnit;
    UnitRepositoring _defineUnit;
    private static final FileFilter __filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            if (!pathname.isFile()) {
                return false;
            }
            String path = pathname.getAbsolutePath();
            if (!path.endsWith(".class")) {
                return false;
            }
            return path.indexOf(36) < 0;
        }
    };
    private Set<String> _jarPathSet = new HashSet<String>();

    public UnitLoaderHelper(BanProcess process) {
        this._process = process;
        this._defineUnit = new UnitRepositoring(process);
        this.createUnitLoader();
    }

    public ClassLoader getClassLoader() {
        if (this._loaderUnit == null) {
            return this.getClass().getClassLoader();
        }
        return this._loaderUnit;
    }

    public UnitRepositoring getUnitDefs() {
        return this._defineUnit;
    }

    public void addJar(File jarFile) {
        try {
            String path = jarFile.getCanonicalPath();
            URL url = jarFile.toURI().toURL();
            if (this._loaderUnit == null) {
                URL[] urls = new URL[]{url};
                String[] jars = new String[]{path};
                this._loaderUnit = new UnitLoader(urls, jars, this.getClass().getClassLoader());
            } else {
                this._loaderUnit.addJar(url, path);
            }
            this.examineFromJar(url);
        }
        catch (MalformedURLException e) {
            this._process.log("Can't load Jar File [" + jarFile.getAbsolutePath() + "] : " + e.getMessage(), 0);
        }
        catch (IOException e) {
            this._process.log("Can't load Jar File [" + jarFile.getAbsolutePath() + "] : " + e.getMessage(), 0);
        }
    }

    protected void createUnitLoader() {
        this.examineFromClassPath(Unit.class.getPackage().getName());
        this.examineFromClassPath("com.dassault.cecilia.lib.ban");
        this.examineFromClassPath("com.dassault.cecilia.lib.mbsa");
        this.examineFromClassPath("com.dassault.cecilia.lib.mcs");
        this.examineFromClassPath("com.dassault.cecilia.lib.util");
    }

    private void examineFromClassPath(String packageName) {
        String packageFileName = packageName.replace('.', File.separatorChar);
        packageName = packageName.replace('.', '/');
        try {
            Enumeration<URL> e = this.getClassLoader().getResources(packageName);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String fileName = url.getFile();
                    this.examineFromDirectory(new File(URLDecoder.decode(fileName, "UTF-8")), packageFileName);
                    continue;
                }
                if (protocol.equals("jar")) {
                    this.examineFromJar(url);
                    continue;
                }
                throw new BanProcessException("Unknow protocole : " + protocol);
            }
        }
        catch (BanProcessException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void examineFromDirectory(File directory, String packageFileName) {
        block7: {
            String name = "<unknow>";
            if (!directory.isDirectory()) {
                return;
            }
            try {
                File[] files = directory.listFiles(__filter);
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.isDirectory()) {
                        this.examineFromDirectory(file, packageFileName);
                        continue;
                    }
                    name = file.getAbsolutePath();
                    int pos = name.indexOf(packageFileName);
                    if (pos == -1) continue;
                    name = name.substring(pos, name.length() - 6).replace(File.separatorChar, '.');
                    Class<?> plugin = this.getClassLoader().loadClass(name);
                    if (!UnitLoaderHelper.isUnit(plugin) || this._defineUnit.contains(plugin)) continue;
                    this._defineUnit.add(plugin);
                }
            }
            catch (ClassNotFoundException e) {
                if (!name.contains("Test") || !e.getMessage().contains("junit")) {
                    this._process.log("ClassNotFoundException from classname [" + name + "] during examine directory [" + directory + "] : " + e.getMessage(), 0);
                }
            }
            catch (NoClassDefFoundError e) {
                if (name.contains("Test") && e.getMessage().contains("junit")) break block7;
                this._process.log("NoClassDefFoundError from classname [" + name + "] during examine directory [" + directory + "] : " + e.getMessage(), 0);
            }
        }
    }

    private void examineFromJar(URL url) {
        String name = "<unknow>";
        String jarName = url.getFile();
        jarName = jarName.substring(jarName.indexOf(58) + 1);
        if (this._jarPathSet.contains(jarName = jarName.substring(0, jarName.indexOf(33)))) {
            this._process.log("already examine Jar [" + jarName + "]", 3);
            return;
        }
        this._jarPathSet.add(jarName);
        try {
            URI uri = new URI("file:" + jarName);
            ZipFile zipFile = new ZipFile(new File(uri));
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                name = entry.getName();
                if (!name.endsWith(".class") || name.indexOf(36) >= 0) continue;
                name = name.substring(0, name.length() - 6);
                name = name.replace('/', '.');
                Class<?> plugin = this.getClassLoader().loadClass(name);
                if (!UnitLoaderHelper.isUnit(plugin) || this._defineUnit.contains(plugin)) continue;
                this._defineUnit.add(plugin);
            }
            zipFile.close();
        }
        catch (IOException e) {
            this._process.log("IOException from examine Jar [" + jarName + "] : " + e.getMessage(), 0);
        }
        catch (ClassNotFoundException e) {
            if (!name.contains("Test") || !e.getMessage().contains("junit")) {
                this._process.log("ClassNotFoundException from classname [" + name + "] during examine Jar [" + jarName + "] : " + e.getMessage(), 0);
            }
        }
        catch (NoClassDefFoundError e) {
            if (!name.contains("Test") || !e.getMessage().contains("junit")) {
                this._process.log("NoClassDefFoundError from classname [" + name + "] during examine Jar [" + jarName + "] : " + e.getMessage(), 0);
            }
        }
        catch (URISyntaxException e) {
            this._process.log("URISyntaxException from convert Jar [" + jarName + "] : " + e.getMessage(), 0);
        }
    }

    private static boolean isUnit(Class cl) {
        if (!Unit.class.isAssignableFrom(cl)) {
            return false;
        }
        return !Modifier.isAbstract(cl.getModifiers());
    }

    public static Unit createUnit(Class cl, BanProcess process) {
        if (!UnitLoaderHelper.isUnit(cl)) {
            throw new BanProcessException("Class [" + cl.getName() + "] is not Unit");
        }
        try {
            Unit result = (Unit)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.setProcess(process);
            return result;
        }
        catch (Exception e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not instantiate", e);
        }
    }

    public static XmlHandler findGetHandler(Object obj, BanProcess process) {
        Class<?> cl = obj.getClass();
        try {
            Method method = cl.getMethod("getHandler", new Class[0]);
            Object result = method.invoke(obj, new Object[0]);
            if (result instanceof XmlHandler) {
                return (XmlHandler)result;
            }
        }
        catch (SecurityException e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not reflect", e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            process.log("Class [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (IllegalAccessException e) {
            process.log("Class [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (InvocationTargetException e) {
            process.log("Class [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        return null;
    }

    private static String convertName(String base, String add) {
        StringBuffer sb = new StringBuffer(base.length() + add.length() + 2);
        sb.append(base);
        sb.append(Character.toUpperCase(add.charAt(0)));
        sb.append(add.substring(1).toLowerCase());
        return sb.toString();
    }

    public static void invokeSetAttribut(Object obj, String name, String value, BanProcess process) {
        Class<?> cl = obj.getClass();
        try {
            Method method = cl.getMethod(UnitLoaderHelper.convertName("set", name), String.class);
            method.invoke(obj, value);
        }
        catch (SecurityException e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not reflect", e);
        }
        catch (NoSuchMethodException e) {
            throw new BanProcessException("Element [" + name + "] not possible for unit [" + cl.getSimpleName() + "]", e);
        }
        catch (IllegalArgumentException e) {
            throw new BanProcessException("Error in method set" + name + "(String ...) of class [" + cl.getName() + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new BanProcessException("Error in method set" + name + "(String ...) of class [" + cl.getName() + "]", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            t = e.getCause();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            throw new BanProcessException("Error in method set" + name + "(String ...) of class [" + cl.getName() + "]", e);
        }
    }

    public static Object invokeCreateElement(Object obj, String name, BanProcess process) {
        Class<?> cl = obj.getClass();
        try {
            Method method = cl.getMethod(UnitLoaderHelper.convertName("create", name), new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        catch (SecurityException e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not reflect", e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            process.log("CreateElement [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (IllegalAccessException e) {
            process.log("CreateElement [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            t = e.getCause();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            process.log("CreateElement [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        return null;
    }

    public static void invokeSetProcess(Object obj, BanProcess process) {
        Class<?> cl = obj.getClass();
        try {
            Method method = cl.getMethod("setProcess", BanProcess.class);
            method.invoke(obj, process);
        }
        catch (SecurityException e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not reflect", e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            process.log("SetProcess [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (IllegalAccessException e) {
            process.log("SetProcess [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            t = e.getCause();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            process.log("SetProcess [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
    }

    public static void invokeValidElement(Object obj, String prefix, BanProcess process) {
        Class<?> cl = obj.getClass();
        String name = prefix + "Valid";
        try {
            Method method = cl.getMethod(name, new Class[0]);
            method.invoke(obj, new Object[0]);
        }
        catch (SecurityException e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not reflect", e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            process.log(name + " [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (IllegalAccessException e) {
            process.log(name + " [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            t = e.getCause();
            if (t instanceof BanProcessException) {
                throw (BanProcessException)t;
            }
            process.log(name + " [" + cl.getName() + "] : " + e.getMessage(), 4);
        }
    }
}

