/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.parser;

import org.xml.sax.Locator;

public class XmlLocator
implements Locator {
    private String _publicId;
    private String _systemId;
    private int _column;
    private int _line;

    public XmlLocator() {
        this(null, null, 0, 0);
    }

    public XmlLocator(String sId) {
        this(null, sId, 0, 0);
    }

    public XmlLocator(String sId, int line, int column) {
        this(null, sId, line, column);
    }

    public XmlLocator(Locator loc) {
        this(loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber());
    }

    public XmlLocator(String pId, String sId, int line, int column) {
        this._publicId = pId;
        this._systemId = sId;
        this._line = line;
        this._column = column;
    }

    @Override
    public int getColumnNumber() {
        return this._column;
    }

    @Override
    public int getLineNumber() {
        return this._line;
    }

    @Override
    public String getPublicId() {
        return this._publicId;
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("[line=");
        if (this._line != -1) {
            sb.append(this._line);
        } else {
            sb.append("?");
        }
        sb.append("] ");
        if (this._systemId == null) {
            sb.append("[Unknow origin]");
        } else if (this._systemId.startsWith("file:") && this._systemId.length() > 7) {
            sb.append(this._systemId.substring(7));
        } else {
            sb.append(this._systemId);
        }
        return sb.toString();
    }
}

