/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.type.Pattern;
import com.dassault.cecilia.lib.ban.type.PatternSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileSet
extends BanProcessComponent {
    PatternSet _defaultPatternSet = new PatternSet();
    String _dir;
    String _file;
    List<PatternSet> _patternList = new ArrayList<PatternSet>();
    File _baseFile;

    public Pattern createExclude() {
        return this._defaultPatternSet.createExclude();
    }

    public Pattern createInclude() {
        return this._defaultPatternSet.createInclude();
    }

    public void setExcludes(String value) {
        this._defaultPatternSet.setExcludes(value);
    }

    public void setIncludes(String value) {
        this._defaultPatternSet.setIncludes(value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._defaultPatternSet.setProcess(process);
    }

    public void setDir(String value) {
        if (this._file != null) {
            throw new BanProcessException("Attribute 'file' already define : " + this._file);
        }
        this._dir = value;
    }

    public void setFile(String value) {
        if (this._dir != null) {
            throw new BanProcessException("Attribute 'dir' already define : " + this._dir);
        }
        this._file = value;
    }

    public PatternSet createPatternset() {
        PatternSet pattern = new PatternSet();
        this._patternList.add(pattern);
        return pattern;
    }

    public boolean verifyDefault() {
        if (!this._defaultPatternSet.convertAttributes() && this._patternList.size() <= 0 && this._dir == null && this._file == null) {
            return false;
        }
        this.endValid();
        return true;
    }

    public void endValid() {
        if (this._dir == null && this._file == null) {
            throw new BanProcessException("Attributes 'file' or 'dir' must be define");
        }
        if (this._defaultPatternSet.convertAttributes()) {
            this._patternList.add(this._defaultPatternSet);
        }
    }

    public void prepare() {
        if (this._dir != null) {
            this._baseFile = new File(this.expanse(this._dir));
            if (!this._baseFile.isDirectory()) {
                throw new BanProcessException("Attribute 'dir' is not directory : " + this._dir);
            }
        } else if (this._file != null) {
            this._baseFile = new File(this.expanse(this._file));
            if (!this._baseFile.isFile()) {
                throw new BanProcessException("Attribute 'file' is not file : " + this._file);
            }
        } else {
            throw new BanProcessException("Internal error (not call endValue)");
        }
        for (PatternSet pattern : this._patternList) {
            pattern.prepare();
        }
    }

    public File getBaseDir() {
        if (this._baseFile == null) {
            throw new BanProcessException("Internal error (not call prepare)");
        }
        if (this._dir != null) {
            return this._baseFile;
        }
        if (this._file != null) {
            return this._baseFile.getParentFile();
        }
        throw new BanProcessException("Internal error (not call endValue)");
    }

    public String[] getIncludedFiles() {
        if (this._file != null) {
            String[] result = new String[]{"/" + this._baseFile.getName()};
            return result;
        }
        if (this._dir != null) {
            ArrayList<String> files = new ArrayList<String>();
            this.scanDir(this._baseFile, null, files);
            String[] result = new String[files.size()];
            return files.toArray(result);
        }
        throw new BanProcessException("Internal error (not call endValue)");
    }

    protected void scanDir(File base, String addPath, List<String> result) {
        if (base.isDirectory()) {
            addPath = addPath == null ? "" : (String)addPath + "/" + base.getName();
            File[] files = base.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.scanDir(files[i], (String)addPath, result);
                }
            } else {
                this.log("ScanDir - Acces denied : " + base, 4);
            }
        } else if (base.isFile()) {
            Object path = addPath == null ? "" : addPath;
            path = (String)path + "/" + base.getName();
            boolean accept = true;
            for (PatternSet pattern : this._patternList) {
                if (!(accept &= pattern.accept((String)path))) break;
            }
            if (accept) {
                result.add((String)path);
            }
        }
    }
}

