/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.Closable;
import com.dassault.cecilia.lib.ban.type.Handle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public abstract class HandleReader
extends Handle
implements Closable {
    BufferedReader _reader;
    boolean _closed = false;

    protected HandleReader(Reader read) {
        if (read instanceof BufferedReader) {
            this._reader = (BufferedReader)read;
        }
        this._reader = new BufferedReader(read);
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public String read() throws IOException {
        return this._reader.readLine();
    }

    @Override
    public String read(int size) throws IOException {
        char[] buffer = new char[size];
        if (this._reader.read(buffer) > 0) {
            return new String(buffer);
        }
        return null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public void write(String msg) throws IOException {
        throw new IOException("Handle in read mode");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close(BanProcess process) {
        if (this._closed) {
            return;
        }
        try {
            this._closed = true;
            this._reader.close();
        }
        catch (IOException e) {
            process.log("Close Handle ioexception : " + e.getMessage(), 1);
        }
    }
}

