/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.type;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.util.destination.Layout;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class layout
extends BanProcessComponent {
    String _name;
    String _class;
    List<Param> _params = new ArrayList<Param>();

    private void verifyKey() {
        if (this._name != null) {
            throw new BanProcessException("Attribute 'name' already define : " + this._name);
        }
        if (this._class != null) {
            throw new BanProcessException("Attribute 'class' already define : " + this._class);
        }
    }

    public void setName(String value) {
        this.verifyKey();
        this._name = value;
    }

    String getName() {
        String name = this.expanse(this._name);
        if (name.equalsIgnoreCase("default")) {
            return "default";
        }
        if (name.equalsIgnoreCase("txt")) {
            return "txt";
        }
        if (name.equalsIgnoreCase("xml")) {
            return "xml";
        }
        this.log("Attribute 'name' of layout not define : " + name, 1);
        return name;
    }

    public void setClass(String value) {
        this.verifyKey();
        this._class = value;
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    private Class<? extends Layout> configureLayout(Map<String, String> params, LayoutDefiner definer) {
        Class<?> result = null;
        if (this._name != null) {
            result = definer.configureLayout(this.getName(), params);
        } else if (this._class != null) {
            String classs = this.expanse(this._class);
            ClassLoader loader = this.getProcess().getClassLoader();
            try {
                result = loader.loadClass(classs);
            }
            catch (ClassNotFoundException e) {
                throw new BanProcessException("Class [" + classs + "] not found");
            }
            if (!Layout.class.isAssignableFrom(result) || Modifier.isAbstract(result.getModifiers())) {
                throw new BanProcessException("Class [" + classs + "] is not Layout");
            }
        } else {
            result = definer.configureLayout("default", params);
        }
        return result;
    }

    public Layout constructLayout(LayoutDefiner definer) {
        Map<String, String> params = Param.mapParams(this._params);
        Class<? extends Layout> cl = this.configureLayout(params, definer);
        return layout.constructLayout(cl, params);
    }

    public static Layout constructDefaultLayout(LayoutDefiner definer) {
        HashMap<String, String> params = new HashMap<String, String>();
        Class cl = definer.configureLayout("default", params);
        return layout.constructLayout(cl, params);
    }

    public static Layout constructLayout(Class<? extends Layout> cl, Map<String, String> params) {
        if (cl == null) {
            throw new BanProcessException("Internal error");
        }
        try {
            Layout result = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.configure(params);
            return result;
        }
        catch (Exception e) {
            throw new BanProcessException("Class [" + cl.getName() + "] not instantiate", e);
        }
    }
}

