/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.diff;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.diff.DiffLayoutSimple;
import com.dassault.cecilia.lib.util.diff.DiffLayoutXML;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDiff
extends Unit
implements UnitValued,
LayoutDefiner {
    protected boolean _result;
    UtilFileSrc _src1 = new UtilFileSrc();
    UtilFileSrc _src2 = new UtilFileSrc();
    protected List<destination> _destinations = new ArrayList<destination>();

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setSrc1file(String value) {
        this._src1.setFile("src1file", value);
    }

    public void setSrc1ref(String value) {
        this._src1.setRef("src1ref", value);
    }

    public void setSrc2file(String value) {
        this._src2.setFile("src2file", value);
    }

    public void setSrc2ref(String value) {
        this._src2.setRef("src2ref", value);
    }

    public void setText(String value) {
        this._src2.setText(value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src1.setProcess(process);
        this._src2.setProcess(process);
    }

    public void endValid() {
        this._src1.endValid();
        this._src2.endValid();
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
    }

    protected File getSrc1File() {
        return this._src1.getSrcFile();
    }

    protected File getSrc2File() {
        return this._src2.getSrcFile();
    }

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    @Override
    public Class configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return DiffLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return DiffLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for diff unit : " + key);
    }
}

