/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.file;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.util.UtilFile;
import java.io.File;

public class FCheck
extends Unit
implements UnitValued {
    private boolean _result;
    UtilFile _src = new UtilFile();
    private String _test;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setFile(String value) {
        this._src.setFile("file", value);
    }

    public void setFileref(String value) {
        this._src.setRef("fileref", value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
    }

    public void setTest(String value) {
        if (this._test != null) {
            this.log("File 'test' already define : " + this._test + " => " + value, 1);
        }
        this._test = value;
    }

    public void endValid() {
        this._src.endValid();
        if (this._test == null) {
            throw new BanProcessException("Attribute 'test' not define");
        }
    }

    private boolean verifyFile(File tmp, String test) {
        block8: for (int i = 0; i < test.length(); ++i) {
            switch (test.charAt(i)) {
                case 'e': {
                    if (tmp.exists()) continue block8;
                    return false;
                }
                case 'f': {
                    if (tmp.isFile()) continue block8;
                    return false;
                }
                case 'd': {
                    if (tmp.isDirectory()) continue block8;
                    return false;
                }
                case 'r': {
                    if (tmp.canRead()) continue block8;
                    return false;
                }
                case 'w': {
                    if (tmp.canWrite()) continue block8;
                    return false;
                }
                case 'h': {
                    if (tmp.isHidden()) continue block8;
                    return false;
                }
                default: {
                    throw new BanProcessException("Attribute 'test' must be included '" + test.substring(i, i + 1) + "' character");
                }
            }
        }
        return true;
    }

    @Override
    public void execute() {
        String test = this.expanse(this._test);
        if (test.length() == 0) {
            throw new BanProcessException("Attribute 'test' must be length greater than 0 : " + this._test + " => " + test);
        }
        File tmp = this._src.getFile();
        this._result = this.verifyFile(tmp, test);
    }
}

